/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPElementFilter;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OPPPropertyModel
extends OPPXMLElementAdapter
implements OPPParseConstants {
    protected static final OPPElementFilter DEFAULT_FILTER = new OPPElementFilter(){

        @Override
        public boolean accept(XMLElement element) {
            String tag = element.getTagName();
            return !"infoTuple".equals(tag) && !"infoMap".equals(tag) && !"infoList".equals(tag) && !"array".equals(tag);
        }
    };
    private final OPPContainer _parent;
    private final OPPElementFilter _filter;
    private final Map<String, Object> _props;
    private final Set<String> _supportedProps;

    public OPPPropertyModel(OPPContainer parent, XMLElement xmlSource) {
        this(parent, xmlSource, null);
    }

    public OPPPropertyModel(OPPContainer parent, XMLElement xmlSource, OPPElementFilter filter) {
        super(xmlSource);
        this._parent = parent;
        this._filter = filter != null ? filter : DEFAULT_FILTER;
        NodeList children = xmlSource.getChildNodes();
        this._props = new LinkedHashMap<String, Object>((int)((float)children.getLength() / 0.75f));
        int isize = children.getLength();
        for (int i = 0; i < isize; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            XMLElement element = (XMLElement)node;
            String tag = element.getTagName();
            if (!this._filter.accept(element)) continue;
            String prop = OPPParseUtil.getNameAttribute(element);
            Object value = OPPParseUtil.parseTypedProperty(element);
            this._props.put(prop, value);
        }
        this._supportedProps = Collections.unmodifiableSet(this._props.keySet());
    }

    public final boolean hasProperty(String propKey) {
        return this._props.containsKey(propKey);
    }

    public final Object getPropertyValue(String propKey) {
        return this._props.get(propKey);
    }

    public final Set<String> getSupportedProperties() {
        return this._supportedProps;
    }

    public final OPPContainer getParent() {
        return this._parent;
    }

    protected final OPPElementFilter getFilter() {
        return this._filter;
    }
}

