/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDiagramElement;
import oracle.diagram.oppparse.OPPDiagramVisitor;
import oracle.diagram.oppparse.OPPDimension;
import oracle.diagram.oppparse.OPPDisplayData;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPShapeState;
import oracle.diagram.oppparse.OPPShapeStateData;
import oracle.diagram.oppparse.OPPTopLevelShape;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OPPDiagramShape
extends OPPDiagramElement {
    private static final List<OPPTopLevelShape> EMPTY_SHAPES = Collections.unmodifiableList(new ArrayList(0));
    private static final List<OPPDiagramShape> EMPTY_INTERNAL_SHAPES = Collections.unmodifiableList(new ArrayList(0));
    private final String _name;
    private OPPShapeState _state = OPPShapeState.NORMAL;
    private Point2D _position = null;
    private boolean _visible = true;
    private final List<OPPDiagramShape> _internalShapes;
    private final Map<OPPShapeState, OPPShapeStateData> _states = new HashMap<OPPShapeState, OPPShapeStateData>();
    private final OPPDisplayData _displayData;

    OPPDiagramShape(OPPContainer parent, XMLElement xmlSource) {
        this(parent, xmlSource, false);
    }

    OPPDiagramShape(OPPContainer parent, XMLElement xmlSource, boolean cacheShape) {
        super(parent, xmlSource);
        XMLElement dd;
        int i;
        int isize;
        if (cacheShape) {
            this.getContext().cacheShape(this);
        }
        this._name = OPPParseUtil.getNameAttribute(xmlSource);
        XMLElement gd = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "graphicalData");
        if (gd != null) {
            NodeList children = gd.getChildNodes();
            isize = children.getLength();
            for (i = 0; i < isize; ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                XMLElement child = (XMLElement)node;
                String name = OPPParseUtil.getNameAttribute(child);
                if ("elementPosition".equals(name)) {
                    this._position = (Point2D)OPPParseUtil.parseTypedProperty(child);
                    continue;
                }
                if ("visibility".equals(name)) {
                    this._visible = (Boolean)OPPParseUtil.parseTypedProperty(child);
                    continue;
                }
                if ("shapeState".equals(name)) {
                    String state = (String)OPPParseUtil.parseTypedProperty(child);
                    if ("iconic".equals(state)) {
                        this._state = OPPShapeState.ICONIC;
                        continue;
                    }
                    if ("symbolic".equals(state)) {
                        this._state = OPPShapeState.NORMAL;
                        continue;
                    }
                    if ("expanded".equals(state)) {
                        this._state = OPPShapeState.EXPANDED;
                        continue;
                    }
                    throw new IllegalArgumentException("unrecognized state: " + state);
                }
                if (!"diagramStateProperties".equals(name)) continue;
                this.populateStateData(child);
            }
        }
        if (this._position == null) {
            this._position = new Point2D.Float(0.0f, 0.0f);
        }
        this._displayData = (dd = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "displayData")) != null ? new OPPDisplayData(this, dd) : null;
        XMLElement contained = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "containedShapes");
        if (contained != null) {
            NodeList cs = contained.getChildrenByTagName("infoMap");
            if (cs != null) {
                ArrayList<OPPDiagramShape> l = new ArrayList<OPPDiagramShape>(cs.getLength());
                isize = cs.getLength();
                for (i = 0; i < isize; ++i) {
                    XMLElement child = (XMLElement)cs.item(i);
                    l.add(new OPPDiagramShape(this, child));
                }
                this._internalShapes = Collections.unmodifiableList(l);
            } else {
                this._internalShapes = null;
            }
        } else {
            this._internalShapes = EMPTY_INTERNAL_SHAPES;
        }
    }

    public final String getName() {
        return this._name;
    }

    public final boolean isVisible() {
        return this._visible;
    }

    public final Point2D getPosition() {
        return this._position;
    }

    public final OPPShapeState getState() {
        return this._state;
    }

    public final List<OPPDiagramShape> getInternalShapes() {
        return this._internalShapes;
    }

    public final Set<OPPShapeState> getAvailableStates() {
        return Collections.unmodifiableSet(this._states.keySet());
    }

    public final OPPShapeStateData getShapeStateData(OPPShapeState state) {
        return this._states.get((Object)state);
    }

    public final List<OPPTopLevelShape> getCurrentChildShapes() {
        return this.getChildShapes(this.getState());
    }

    public final List<OPPTopLevelShape> getChildShapes(OPPShapeState state) {
        OPPShapeStateData data;
        if (state == OPPShapeState.EXPANDED && (data = this.getShapeStateData(state)) != null) {
            return data.getChildShapes();
        }
        return EMPTY_SHAPES;
    }

    public final Rectangle2D getCurrentExtent() {
        return this.getExtent(this.getState());
    }

    public final OPPDimension getCurrentSize() {
        return this.getSize(this.getState());
    }

    public final OPPDimension getSize(OPPShapeState state) {
        OPPShapeStateData data = this.getShapeStateData(state);
        if (data != null) {
            return data.getShapeSize();
        }
        return null;
    }

    public final Rectangle2D getExtent(OPPShapeState state) {
        OPPDimension size;
        OPPShapeStateData data = this.getShapeStateData(state);
        if (data != null && (size = data.getShapeSize()) != null) {
            return new Rectangle2D.Float((float)this._position.getX(), (float)this._position.getY(), size.getWidth(), size.getHeight());
        }
        return null;
    }

    public final OPPDisplayData getDisplayData() {
        return this._displayData;
    }

    void resolveShapeReferences() {
        for (OPPDiagramShape shape : this.getInternalShapes()) {
            shape.resolveShapeReferences();
        }
        for (OPPShapeState state : this.getAvailableStates()) {
            for (OPPTopLevelShape shape : this.getShapeStateData(state).getChildShapes()) {
                shape.resolveShapeReferences();
            }
        }
    }

    void visit(OPPDiagramVisitor visitor, boolean nodePass) {
    }

    /*
     * WARNING - void declaration
     */
    protected void populateStateData(XMLElement dsp) {
        NodeList states = dsp.getChildrenByTagName("infoMap");
        int isize = states.getLength();
        for (int i = 0; i < isize; ++i) {
            void var5_7;
            OPPShapeState istate;
            XMLElement state = (XMLElement)states.item(i);
            String name = OPPParseUtil.getNameAttribute(state);
            if ("iconic".equals(name)) {
                istate = OPPShapeState.ICONIC;
            } else if ("symbolic".equals(name)) {
                istate = OPPShapeState.NORMAL;
            } else {
                if (!"expanded".equals(name)) continue;
                istate = OPPShapeState.EXPANDED;
            }
            this._states.put((OPPShapeState)var5_7, new OPPShapeStateData(this, (OPPShapeState)var5_7, state));
        }
    }
}

