/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import oracle.diagram.oppparse.OPPParseConstants;

public class OPPCID
implements OPPParseConstants {
    private static final String CID_DELIMITER = "::";
    private final String[] _components;

    public OPPCID(String id) {
        this._components = OPPCID.parseCID(id);
    }

    public final String getGuid() {
        return this._components[0];
    }

    public final String getPath() {
        return this._components[1];
    }

    public final String getType() {
        return this._components[2];
    }

    public static String[] parseCID(String cid) {
        int last;
        int first = cid.indexOf(CID_DELIMITER);
        if (first == (last = cid.lastIndexOf(CID_DELIMITER))) {
            return null;
        }
        String[] result = new String[]{cid.substring(0, first), cid.substring(first + CID_DELIMITER.length(), last), cid.substring(last + CID_DELIMITER.length())};
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OPPCID) {
            OPPCID other = (OPPCID)obj;
            if ("".equals(this.getGuid())) {
                if ("".equals(other.getGuid())) {
                    return this.getPath().equals(other.getPath());
                }
                return false;
            }
            if ("".equals(other.getGuid())) {
                return false;
            }
            return this.getGuid().equals(other.getGuid());
        }
        return false;
    }

    public int hashCode() {
        if ("".equals(this.getGuid())) {
            return this.getPath().hashCode();
        }
        return this.getGuid().hashCode();
    }
}

