/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.util;

import java.awt.Font;

public final class FontUtil {
    public static final String encodeFont(Font font) {
        return font.getName() + "," + FontUtil.encodeFontStyle(font.getStyle()) + "," + font.getSize();
    }

    public static final Font decodeFont(String fontString) {
        if (fontString == null) {
            return null;
        }
        int ind1 = fontString.indexOf(44);
        int ind2 = fontString.lastIndexOf(44);
        String name = fontString.substring(0, ind1);
        String style = fontString.substring(ind1 + 1, ind2);
        String size = fontString.substring(ind2 + 1);
        return new Font(name, FontUtil.decodeFontStyle(style), Integer.valueOf(size));
    }

    protected static int decodeFontStyle(String style) {
        if ("plain".equals(style)) {
            return 0;
        }
        if ("bold".equals(style)) {
            return 1;
        }
        if ("italic".equals(style)) {
            return 2;
        }
        if ("bold+italic".equals(style)) {
            return 3;
        }
        throw new IllegalArgumentException("invalid style: " + style);
    }

    protected static String encodeFontStyle(int style) {
        if ((style & 3) == 3) {
            return "bold+italic";
        }
        if ((style & 1) != 0) {
            return "bold";
        }
        if ((style & 2) != 0) {
            return "italic";
        }
        return "plain";
    }

    private FontUtil() {
    }
}

