/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.undo;

import java.util.ArrayList;
import java.util.List;
import oracle.diagram.framework.undo.UndoableStep;

public class CompositeUndoableStep
implements UndoableStep {
    private List<UndoableStep> _steps = new ArrayList<UndoableStep>();
    private final boolean _forwardOrder;

    public CompositeUndoableStep() {
        this(false);
    }

    public CompositeUndoableStep(boolean forwardOrderForUndo) {
        this._forwardOrder = forwardOrderForUndo;
    }

    public void addUndoableStep(UndoableStep step) {
        if (step != null) {
            this._steps.add(step);
        }
    }

    @Override
    public void undo() throws Exception {
        UndoableStep[] steps = this._steps.toArray(new UndoableStep[this._steps.size()]);
        if (!this._forwardOrder) {
            for (int i = steps.length - 1; i >= 0; --i) {
                steps[i].undo();
            }
        } else {
            for (int i = 0; i < steps.length; ++i) {
                steps[i].undo();
            }
        }
    }

    @Override
    public void redo() throws Exception {
        UndoableStep[] steps = this._steps.toArray(new UndoableStep[this._steps.size()]);
        for (int i = 0; i < steps.length; ++i) {
            steps[i].redo();
        }
    }

    @Override
    public void performPostUndoRedoAction() throws Exception {
        UndoableStep[] steps = this._steps.toArray(new UndoableStep[this._steps.size()]);
        for (int i = 0; i < steps.length; ++i) {
            steps[i].performPostUndoRedoAction();
        }
    }

    @Override
    public void storeUndoState() {
        UndoableStep[] steps = this._steps.toArray(new UndoableStep[this._steps.size()]);
        for (int i = 0; i < steps.length; ++i) {
            steps[i].storeUndoState();
        }
    }

    @Override
    public void storeRedoState() {
        UndoableStep[] steps = this._steps.toArray(new UndoableStep[this._steps.size()]);
        for (int i = 0; i < steps.length; ++i) {
            steps[i].storeRedoState();
        }
    }

    public final boolean hasSteps() {
        return !this._steps.isEmpty();
    }
}

