/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.ui.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyInspectorContainer;
import oracle.bali.inspector.PropertyModel;
import oracle.diagram.framework.preference.MapPreferenceStore;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.PreferenceStorePropertyModel;
import oracle.diagram.framework.preference.PreferenceUtil;
import oracle.diagram.framework.preference.ui.generic.PageData;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class GenericPreferencePanel
extends DefaultTraversablePanel {
    private final PageData[] _pages;
    private PropertyInspectorContainer _container = null;
    private JLabel _hintLabel = null;

    public GenericPreferencePanel(String hintText, PageData[] pages) {
        this._pages = pages;
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this._hintLabel = new JLabel();
        this._hintLabel.setText(hintText);
        this.add(this._hintLabel, "North");
        this._container = new PropertyInspectorContainer();
        this._container.removeAllInspectors();
        this.add((Component)this._container, "Center");
        for (PageData p : this._pages) {
            PropertyInspector inspector = new PropertyInspector();
            inspector.setActionToolBar(null);
            this._container.addInspector((Component)inspector, p.getTitle());
            this._container.setComponentTitle((Component)inspector, p.getTitle());
        }
        this.validate();
    }

    public void onEntry(TraversableContext dataContext) {
        super.onEntry(dataContext);
        this._container.setSelectedComponent(this._container.getInspector(0));
        for (int i = 0; i < this._pages.length; ++i) {
            MapPreferenceStore store = new MapPreferenceStore();
            PreferenceUtil.copyPreferences(this._pages[i].getPreferences(), this._pages[i].getPreferenceStore(dataContext), store);
            PreferenceStorePropertyModel model = new PreferenceStorePropertyModel(this._pages[i].getTitle(), this._pages[i].getPreferences(), store);
            ((PropertyInspector)this._container.getInspector(i)).setUnderlyingPropertyModel((PropertyModel)model);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        for (int i = 0; i < this._pages.length; ++i) {
            PreferenceStorePropertyModel model = (PreferenceStorePropertyModel)((PropertyInspector)this._container.getInspector(i)).getUnderlyingPropertyModel();
            PreferenceStore store = model.getPreferenceStore();
            PreferenceUtil.copyPreferences(this._pages[i].getPreferences(), store, this._pages[i].getPreferenceStore(dataContext));
        }
        super.onExit(dataContext);
    }
}

