/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.beans.PropertyEditor;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.diagram.framework.preference.ActionGroupProvider;
import oracle.diagram.framework.preference.MultiPreferenceStore;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.propertyeditor.BooleanPropertyEditor;
import oracle.diagram.framework.preference.propertyeditor.PaintableBooleanPropertyEditor;
import oracle.diagram.framework.preference.propertyeditor.PropertyEditorFactory2Delegate;
import oracle.diagram.framework.preference.propertyeditor.PropertyEditorFactoryDelegate;

public class PreferenceStorePropertyModel
extends PropertyModel {
    private static Object[] COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_NAME, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_EDITOR_FACTORY_2, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_ACTIONS, PropertyModel.COLUMN_IS_HIDDEN};
    private final String _name;
    private final PreferenceDefinition[] _definitions;
    private final PreferenceStore _store;
    private final PropertyEditorFactory[] _factories;
    private final PropertyEditorFactory2[] _factories2;

    public PreferenceStorePropertyModel(String displayName, PreferenceDefinition[] preferences, PreferenceStore store) {
        this._name = displayName;
        this._definitions = new PreferenceDefinition[preferences.length];
        System.arraycopy(preferences, 0, this._definitions, 0, preferences.length);
        this._store = store;
        this._factories = new PropertyEditorFactory[preferences.length];
        this._factories2 = new PropertyEditorFactory2[preferences.length];
    }

    public PreferenceDefinition[] getPreferences() {
        return this._definitions;
    }

    public PreferenceStore getPreferenceStore() {
        return this._store;
    }

    public Object[] getColumnMapping() {
        return COLUMNS;
    }

    public String getTargetDisplayName() {
        return this._name;
    }

    public void invalidateValueData() {
    }

    public int getRowCount() {
        return this._definitions.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= COLUMNS.length) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        PreferenceDefinition pref = this._definitions[rowIndex];
        Object type = COLUMNS[columnIndex];
        if (type == PropertyModel.COLUMN_ID) {
            return pref.getId();
        }
        if (type == PropertyModel.COLUMN_VALUE) {
            return this._store.getPreferenceValue(pref);
        }
        if (type == PropertyModel.COLUMN_DISPLAY_VALUE) {
            return this._store.getPreferenceValue(pref);
        }
        if (type == PropertyModel.COLUMN_GROUP) {
            return pref.getPropertyGroup();
        }
        if (type == PropertyModel.COLUMN_DISPLAY_NAME) {
            return pref.getNLSName();
        }
        if (type == PropertyModel.COLUMN_NAME) {
            return pref.getStorageKey();
        }
        if (type == PropertyModel.COLUMN_DESCRIPTION) {
            return pref.getNLSDescription();
        }
        if (type == PropertyModel.COLUMN_EDITOR_FACTORY_2) {
            PropertyEditorFactory pef;
            if (this._factories2[rowIndex] == null && (pef = (PropertyEditorFactory)this.getData(PropertyModel.COLUMN_EDITOR_FACTORY, rowIndex)) != null) {
                Class<? extends PropertyEditorFactory> clazz = pref.getPropertyEditorFactoryClass();
                if (BooleanPropertyEditor.class.equals(clazz)) {
                    pef = this.getPropertyEditorFactoryForClass(clazz);
                }
                if (pef instanceof InspectorPropertyEditor) {
                    this._factories2[rowIndex] = (InspectorPropertyEditor)pef;
                } else {
                    PropertyEditor pe;
                    PropertyEditor propertyEditor = pef instanceof PropertyEditorAdapter ? ((PropertyEditorAdapter)pef).getPropertyEditor() : (pe = pef instanceof PropertyEditor ? (PropertyEditor)pef : null);
                    if (pe != null) {
                        this._factories2[rowIndex] = pe instanceof PropertyEditorFactory2 ? new PropertyEditorFactory2Delegate((PropertyEditorFactory2)pe, pe) : (pef instanceof PropertyEditorFactory2 ? new PropertyEditorFactory2Delegate((PropertyEditorFactory2)pef, pe) : new JavaBeansPropertyEditorAdapter(pe));
                    } else if (pef instanceof PropertyEditorFactory2) {
                        this._factories2[rowIndex] = new PropertyEditorFactory2Delegate((PropertyEditorFactory2)pe);
                    }
                }
            }
            return this._factories2[rowIndex];
        }
        if (type == PropertyModel.COLUMN_EDITOR_FACTORY) {
            if (this._factories[rowIndex] == null) {
                Class<? extends PropertyEditorFactory> clazz = pref.getPropertyEditorFactoryClass();
                this._factories[rowIndex] = this.getGenericPropertyEditorFactoryForClass(clazz);
            }
            return this._factories[rowIndex];
        }
        if (type == PropertyModel.COLUMN_IS_READABLE) {
            return Boolean.TRUE;
        }
        if (type == PropertyModel.COLUMN_IS_WRITABLE) {
            return Boolean.TRUE;
        }
        if (type == PropertyModel.COLUMN_IS_HIDDEN) {
            return Boolean.FALSE;
        }
        if (type == PropertyModel.COLUMN_ACTIONS) {
            if (this._factories[rowIndex] instanceof ActionGroupProvider) {
                return ((ActionGroupProvider)this._factories[rowIndex]).getActionGroups();
            }
            return null;
        }
        return PropertyModel.DOES_NOT_EXIST;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= COLUMNS.length) {
            return;
        }
        PreferenceDefinition pref = this._definitions[rowIndex];
        Object type = COLUMNS[columnIndex];
        if (type == PropertyModel.COLUMN_VALUE) {
            this.setPreferenceValueInStore(this._store, pref, value);
        }
    }

    public boolean isDataConflicting(int column, int row) {
        if (this._store instanceof MultiPreferenceStore) {
            MultiPreferenceStore store = (MultiPreferenceStore)this._store;
            if (column < COLUMNS.length && (COLUMNS[column] == PropertyModel.COLUMN_VALUE || COLUMNS[column] == PropertyModel.COLUMN_DISPLAY_VALUE)) {
                return store.hasConflictingValues(this._definitions[row]);
            }
        }
        return super.isDataConflicting(column, row);
    }

    public boolean isPropertyCommon(int row) {
        if (this._store instanceof MultiPreferenceStore) {
            MultiPreferenceStore store = (MultiPreferenceStore)this._store;
            return store.isCommon(this._definitions[row]);
        }
        return super.isPropertyCommon(row);
    }

    protected void setPreferenceValueInStore(PreferenceStore store, PreferenceDefinition preference, Object value) {
        store.setPreferenceValue(preference, value);
    }

    private PropertyEditorFactory getGenericPropertyEditorFactoryForClass(Class<? extends PropertyEditorFactory> clazz) {
        if (clazz != null) {
            if (BooleanPropertyEditor.class.equals(clazz)) {
                clazz = PaintableBooleanPropertyEditor.class;
            }
            return this.getPropertyEditorFactoryForClass(clazz);
        }
        return null;
    }

    protected PropertyEditorFactory getPropertyEditorFactoryForClass(Class<? extends PropertyEditorFactory> clazz) {
        if (clazz != null) {
            try {
                Object pef = clazz.newInstance();
                if (pef != null && !(pef instanceof PropertyEditorAdapter)) {
                    pef = pef instanceof PropertyEditor ? new PropertyEditorFactoryDelegate((PropertyEditorFactory)pef, (PropertyEditor)pef) : new PropertyEditorFactoryDelegate((PropertyEditorFactory)pef);
                }
                return pef;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }
}

