/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import ilog.views.IlvNamedProperty;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import oracle.diagram.framework.preference.MapPreferenceStore;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.PreferenceStoreListener;
import oracle.ide.util.ModelUtil;

public class PreferenceStoreNamedProperty
extends IlvNamedProperty
implements PreferenceStore {
    private static final String SEPARATOR = "::";
    private static final String INTEGER = "Integer";
    private static final String FLOAT = "Float";
    private static final String DOUBLE = "Double";
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";
    private static final String COLOR = "Color";
    private static final String FONT = "Font";
    private static final String GRADIENT_PAINT = "GradientPaint";
    private final MapPreferenceStore _store = new MapPreferenceStore();

    public PreferenceStoreNamedProperty(IlvInputStream inputStream) throws IlvReadFileException {
        super(inputStream);
        this.read(inputStream);
    }

    public PreferenceStoreNamedProperty(IlvNamedProperty source) {
        super(source);
        PreferenceStoreNamedProperty src = (PreferenceStoreNamedProperty)source;
        ModelUtil.deepCopy(src._store.getStorage(), this._store.getStorage());
    }

    public PreferenceStoreNamedProperty(String name) {
        super(name);
    }

    public IlvNamedProperty copy() {
        return new PreferenceStoreNamedProperty(this);
    }

    @Override
    public final Object getPreferenceValue(PreferenceDefinition preference) {
        return this._store.getPreferenceValue(preference);
    }

    @Override
    public final boolean hasPreferenceValue(PreferenceDefinition preference) {
        return this._store.hasPreferenceValue(preference);
    }

    @Override
    public final void addPreferenceStoreListener(PreferenceStoreListener listener) {
        this._store.addPreferenceStoreListener(listener);
    }

    @Override
    public final void removePreferenceStoreListener(PreferenceStoreListener listener) {
        this._store.removePreferenceStoreListener(listener);
    }

    @Override
    public final Object setPreferenceValue(PreferenceDefinition preference, Object value) {
        return this._store.setPreferenceValue(preference, value);
    }

    @Override
    public final void setPreferenceValues(PreferenceDefinition[] preferences, Object[] values) {
        this._store.setPreferenceValues(preferences, values);
    }

    public boolean isPersistent() {
        return true;
    }

    public final void write(IlvOutputStream outputStream) throws IOException {
        Object value;
        super.write(outputStream);
        Map<String, Object> storage = this._store.getStorage();
        ArrayList<String> dictionary = new ArrayList<String>();
        for (String key : storage.keySet()) {
            value = storage.get(key);
            if (value == null) {
                dictionary.add(key);
                continue;
            }
            dictionary.add(key + SEPARATOR + this.valueClassToString(value.getClass()));
        }
        outputStream.write("dict", dictionary.toArray(new String[dictionary.size()]));
        for (String key : storage.keySet()) {
            value = storage.get(key);
            if (value == null) continue;
            this.writeValue(outputStream, key, value);
        }
    }

    protected String valueClassToString(Class clazz) {
        if (Font.class.equals((Object)clazz)) {
            return FONT;
        }
        if (Color.class.equals((Object)clazz)) {
            return COLOR;
        }
        if (Integer.class.equals((Object)clazz)) {
            return INTEGER;
        }
        if (Double.class.equals((Object)clazz)) {
            return DOUBLE;
        }
        if (Float.class.equals((Object)clazz)) {
            return FLOAT;
        }
        if (Boolean.class.equals((Object)clazz)) {
            return BOOLEAN;
        }
        if (String.class.equals((Object)clazz)) {
            return STRING;
        }
        if (GradientPaint.class.equals((Object)clazz)) {
            return GRADIENT_PAINT;
        }
        return clazz.getName();
    }

    protected void writeValue(IlvOutputStream outputStream, String key, Object value) throws IOException {
        if (value instanceof String) {
            outputStream.write(key, (String)value);
        } else if (value instanceof Float) {
            outputStream.write(key, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            outputStream.write(key, ((Integer)value).intValue());
        } else if (value instanceof Double) {
            outputStream.write(key, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            outputStream.write(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Color) {
            outputStream.write(key, (Color)value);
        } else if (value instanceof Font) {
            outputStream.write(key, (Font)value);
        } else if (value instanceof GradientPaint) {
            outputStream.write(key, (GradientPaint)value);
        }
    }

    protected final void read(IlvInputStream inputStream) throws IlvReadFileException {
        String[] dict;
        Map<String, Object> storage = this._store.getStorage();
        for (String entry : dict = inputStream.readStringArray("dict")) {
            String type;
            String key;
            int ind = entry.indexOf(SEPARATOR);
            if (ind == -1) {
                key = entry;
                type = null;
            } else {
                key = entry.substring(0, ind);
                type = entry.substring(ind + SEPARATOR.length());
            }
            if (type != null) {
                storage.put(key, this.readValue(inputStream, key, type));
                continue;
            }
            storage.put(key, null);
        }
    }

    protected Object readValue(IlvInputStream inputStream, String key, String type) throws IlvReadFileException {
        if (INTEGER.equals(type)) {
            return new Integer(inputStream.readInt(key));
        }
        if (FLOAT.equals(type)) {
            return new Float(inputStream.readFloat(key));
        }
        if (DOUBLE.equals(type)) {
            return new Double(inputStream.readDouble(key));
        }
        if (BOOLEAN.equals(type)) {
            return inputStream.readBoolean(key) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (STRING.equals(type)) {
            return inputStream.readString(key);
        }
        if (COLOR.equals(type)) {
            return inputStream.readColor(key);
        }
        if (FONT.equals(type)) {
            return inputStream.readFont(key);
        }
        if (GRADIENT_PAINT.equals(type)) {
            return inputStream.readGradient(key);
        }
        throw new IlvReadFileException("Unrecognized type: " + type);
    }
}

