/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.framework.graphic.GraphicUtils;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.DragEventBridge;
import oracle.diagram.framework.palette.interactor.IlvMakeLinkInteractor2;
import oracle.diagram.framework.palette.interactor.LinkItemFactory;
import oracle.diagram.framework.readonly.ReadOnlyUtil;

public class MakeLinkInteractor
extends IlvMakeLinkInteractor2
implements DragAndDropAwareInteractor {
    private final PaletteTask _task;
    private IlvGraphic _newGraphic = null;
    private IlvGraphic _interactorGraphic = null;
    private MyTransformerListener _transformerListener;
    private MouseEvent _lastDragEvent;
    private boolean _isFinalCreate = false;
    private DropTargetListener _dtl = new DragEventBridge(){

        @Override
        protected boolean isValidTarget(DropTargetEvent event) {
            return MakeLinkInteractor.this.getLastHit() != null;
        }

        @Override
        protected void processAWTEvent(AWTEvent event) {
            MakeLinkInteractor.this.processEvent(event);
        }
    };

    public MakeLinkInteractor(PaletteTask task, LinkItemFactory factory) {
        this._task = task;
        this.setLinkFactory(factory);
        this.setOriented(factory.isOriented());
        this.setLinkConnectionMode(factory.canConnectLinks());
        this.setSubshapeConnectionMode(factory.canConnectSubshapes());
        this.setAllowingMultiplePoints(true);
        this.setCreationInSubManagersAllowed(true);
        this.setSelfLinkAllowed(true);
        this.setSelectionMode(true);
        this.setOpaqueMode(true);
        this.setGridMode(false);
        this.enableEvents(8L);
    }

    @Override
    protected Class getLinkClass() {
        return this.getLinkFactory().getLinkImageClass();
    }

    @Override
    protected IlvLinkImage createLink(IlvGraphic from, IlvGraphic to, IlvPoint[] points) {
        if (!this.isCreating()) {
            return super.createLink(from, to, points);
        }
        LinkItemFactory factory = (LinkItemFactory)this.getLinkFactory();
        IlvPoint[] adjPoints = new IlvPoint[points.length];
        System.arraycopy(points, 0, adjPoints, 0, points.length);
        IlvGrapher contextGrapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)GraphicUtils.getManagedParent(from), (IlvGraphic)GraphicUtils.getManagedParent(to));
        IlvTransformer tx = ManagerUtil.getConversionTransformer(this.getManager(), (IlvManager)contextGrapher);
        for (IlvPoint p : adjPoints) {
            tx.inverse(p);
        }
        return factory.createAndConnectLink(contextGrapher, from, to, adjPoints);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && this.getManagerView().getInteractor() == this) {
            this.getManagerView().popInteractor();
            keyEvent.consume();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    protected final PaletteTask getPaletteTask() {
        return this._task;
    }

    @Override
    protected void attach(final IlvManagerView view) {
        super.attach(view);
        this._transformerListener = new MyTransformerListener();
        view.addTransformerListener((TransformerListener)this._transformerListener);
        this.setGrapherMode(view.getManager() instanceof IlvGrapher);
        if (!ReadOnlyUtil.checkWritable(this.getPaletteTask().getDiagramContext())) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeLinkInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
        }
    }

    protected void detach() {
        this.getManagerView().removeTransformerListener((TransformerListener)this._transformerListener);
        this._transformerListener = null;
        super.detach();
        if (!this._task.isAborting()) {
            this._task.finished();
        }
    }

    @Override
    protected IlvGraphic makePolyPoint(IlvPoint[] points) {
        IlvGraphic g = super.makePolyPoint(points);
        if (this._isFinalCreate && g != null) {
            IlvGrapher parent;
            IlvLinkImage link = (IlvLinkImage)g;
            IlvGraphic from = link.getFrom();
            IlvGraphic to = link.getTo();
            Object object = parent = from.getGraphicBag() != to.getGraphicBag() ? IlvGrapher.getLowestCommonGrapher((IlvGraphic)from, (IlvGraphic)to) : (IlvManager)from.getGraphicBag();
            if (parent == null) {
                throw new IllegalStateException("no common parent grapher for link");
            }
            ((LinkItemFactory)this.getLinkFactory()).initializeNewObject(this._task.getDiagramContext(), this._task.getPaletteItem(), (IlvGraphic)parent, g);
            this._newGraphic = g;
            this._newGraphic.setProperty("JustCreated", (Object)Boolean.TRUE);
        } else {
            this._interactorGraphic = g;
        }
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doIt() {
        final IlvManagerView view = this.getManagerView();
        IlvGraphic from = this.getFrom();
        IlvGraphic to = this.getTo();
        if (!ReadOnlyUtil.checkWritableCreateLink(this.getPaletteTask().getDiagramContext(), (IlvGraphic)IlvGrapher.getLowestCommonGrapher((IlvGraphic)from, (IlvGraphic)to), this._interactorGraphic, from, to)) {
            this._newGraphic = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeLinkInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
            return;
        }
        try {
            IlvLinkImage link;
            this._isFinalCreate = true;
            IlvPoint[] points = this.getPoints(false);
            super.doIt();
            if (this._newGraphic == null && points != null && points.length == 1 && this.isSelfLinkAllowed()) {
                IlvManager topMgr;
                IlvRect bbox = from.boundingBox();
                IlvManager fromMgr = ManagerUtil.getManager(from);
                if (fromMgr != (topMgr = ManagerUtil.getTopManager(from))) {
                    IlvTransformer t = ManagerUtil.getConversionTransformer(topMgr, fromMgr);
                    t.apply(bbox);
                }
                float[] deltas = new float[]{1.0f, -1.0f, 0.0f, 0.0f};
                for (int i = 0; i < deltas.length; ++i) {
                    IlvPoint newPoint = new IlvPoint(points[0].x + deltas[deltas.length - 1 - i], points[0].y + deltas[i]);
                    if (!bbox.inside(newPoint.x, newPoint.y)) continue;
                    IlvManagerView currentView = this.getManagerView();
                    if (currentView == null) {
                        this.attach(view);
                    }
                    this.doIt(from, from, new IlvPoint[]{points[0], newPoint});
                    if (currentView == null) {
                        this.detach();
                    }
                    if (this._newGraphic != null) break;
                }
            }
            if ((link = (IlvLinkImage)this._newGraphic) != null) {
                IlvManager mgr = ManagerUtil.getManager((IlvGraphic)link);
                mgr.setSelectionAdjusting(true);
                mgr.deSelectAll(true);
                mgr.setSelected((IlvGraphic)link, true, true);
                mgr.setSelectionAdjusting(false);
                ((LinkItemFactory)this.getLinkFactory()).postCreateNewObject(this._task.getDiagramContext(), this._task.getPaletteItem(), (IlvGraphic)ManagerUtil.getManager((IlvGraphic)link), (IlvGraphic)link, false);
            }
        }
        finally {
            this._isFinalCreate = false;
            if (this._newGraphic != null) {
                this._newGraphic.removeProperty("JustCreated");
            }
            this._newGraphic = null;
        }
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        boolean allowEnsureVisible = this.allowEnsureVisible();
        this.allowEnsureVisible(false);
        super.processMouseMotionEvent(event);
        this.allowEnsureVisible(allowEnsureVisible);
        if (event.getID() == 506) {
            this._lastDragEvent = event;
        }
    }

    @Override
    public DragGestureListener getDragGestureListener() {
        return null;
    }

    @Override
    public DragSourceListener getDragSourceListener() {
        return null;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dtl;
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (MakeLinkInteractor.this._lastDragEvent != null && MakeLinkInteractor.this.getManagerView().getInteractor() == MakeLinkInteractor.this) {
                final MouseEvent event = new MouseEvent(MakeLinkInteractor.this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), MakeLinkInteractor.this._lastDragEvent.getModifiers(), MakeLinkInteractor.this._lastDragEvent.getX(), MakeLinkInteractor.this._lastDragEvent.getY(), MakeLinkInteractor.this._lastDragEvent.getClickCount(), false, MakeLinkInteractor.this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MakeLinkInteractor.this.processEvent(event);
                    }
                });
            }
        }
    }
}

