/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.ADACreateLink;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.manager.VisibleObjectsIterator;
import oracle.diagram.framework.palette.interactor.LinkItemFactory;
import oracle.ide.palette2.PaletteItem;

public class CreateDefaultLinkHandler
extends ADACreateLink {
    private final DiagramContext _context;
    private final PaletteItem _item;
    private final LinkItemFactory _factory;

    public CreateDefaultLinkHandler(DiagramContext context, PaletteItem item, LinkItemFactory factory) {
        this._context = context;
        this._item = item;
        this._factory = factory;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this.getDiagramContext().getManagerView();
    }

    protected final PaletteItem getPaletteItem() {
        return this._item;
    }

    protected final LinkItemFactory getFactory() {
        return this._factory;
    }

    @Override
    protected boolean createLink(IlvGraphic src, IlvGraphic target) {
        IlvGrapher grapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)src, (IlvGraphic)target);
        IlvTransformer convSrcTx = ManagerUtil.getConversionTransformer((IlvManager)grapher, (IlvManager)src.getGraphicBag());
        IlvTransformer convDstTx = ManagerUtil.getConversionTransformer((IlvManager)grapher, (IlvManager)target.getGraphicBag());
        IlvPoint srcPoint = new IlvPoint();
        if (((IlvGrapher)src.getGraphicBag()).isLink(src)) {
            srcPoint.setLocation((Point2D)this.calcMidPoint(((IlvLinkImage)src).getLinkPoints(null)));
        } else {
            IlvRect rSrc = src.boundingBox();
            srcPoint.setLocation((float)rSrc.getCenterX(), (float)rSrc.getCenterY());
        }
        IlvPoint dstPoint = new IlvPoint();
        if (((IlvGrapher)target.getGraphicBag()).isLink(target)) {
            dstPoint.setLocation((Point2D)this.calcMidPoint(((IlvLinkImage)target).getLinkPoints(null)));
        } else {
            IlvRect rDst = target.boundingBox();
            dstPoint.setLocation((float)rDst.getCenterX(), (float)rDst.getCenterY());
        }
        IlvPoint linkSrcPoint = new IlvPoint(srcPoint);
        convSrcTx.apply(linkSrcPoint);
        IlvPoint linkDstPoint = new IlvPoint(dstPoint);
        convDstTx.apply(linkDstPoint);
        IlvLinkImage link = this.getFactory().createAndConnectLink(grapher, src, target, new IlvPoint[]{linkSrcPoint, linkDstPoint});
        if (link != null) {
            grapher.addLink(link, true);
            grapher.setSelectionAdjusting(true);
            grapher.deSelectAll(true);
            grapher.setSelected((IlvGraphic)link, true, true);
            grapher.setSelectionAdjusting(false);
            this.getFactory().initializeNewObject(this.getDiagramContext(), this.getPaletteItem(), (IlvGraphic)grapher, (IlvGraphic)link);
            this.getFactory().postCreateNewObject(this.getDiagramContext(), this.getPaletteItem(), (IlvGraphic)grapher, (IlvGraphic)link, true);
        }
        return true;
    }

    protected IlvPoint calcMidPoint(IlvPoint[] points) {
        int count = points.length;
        if (count % 2 == 1) {
            int i = count / 2;
            IlvPoint p1 = points[i];
            return new IlvPoint(p1.x, p1.y);
        }
        int i = (count - 1) / 2;
        IlvPoint p1 = points[i + 1];
        IlvPoint p0 = points[i];
        return new IlvPoint((p0.x + p1.x) / 2.0f, (p0.y + p1.y) / 2.0f);
    }

    @Override
    protected NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getManagerView(), g, NavigableGraphicPlugin.class);
    }

    @Override
    protected PresentableGraphicPlugin getPresentableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getManagerView(), g, PresentableGraphicPlugin.class);
    }

    @Override
    protected String getType() {
        return this.getFactory().getType(this.getPaletteItem());
    }

    @Override
    protected IlvGraphic getInitialSelection() {
        IlvManager mgr = this.getManagerView().getManager();
        int count = mgr.getSelectedObjectsCount(true);
        if (count == 1) {
            return mgr.getSelectedObjects(true).nextElement();
        }
        return null;
    }

    @Override
    protected List<IlvGraphic> getValidSources() {
        IlvManagerView view = this.getManagerView();
        IlvManager mgr = view.getManager();
        int count = mgr.getCardinal(true);
        ArrayList<IlvGraphic> valid = new ArrayList<IlvGraphic>(count);
        for (IlvGraphic g : new VisibleObjectsIterator(mgr, true)) {
            if (g instanceof IMultipresentationView || !this.getFactory().isValidSource(this.getPaletteItem(), g)) continue;
            valid.add(g);
        }
        return Collections.unmodifiableList(valid);
    }

    @Override
    protected List<IlvGraphic> getValidTargets(IlvGraphic source) {
        IlvManagerView view = this.getManagerView();
        IlvManager mgr = view.getManager();
        int count = mgr.getCardinal(true);
        ArrayList<IlvGraphic> valid = new ArrayList<IlvGraphic>(count);
        for (IlvGraphic g : new VisibleObjectsIterator(mgr, true)) {
            if (g instanceof IMultipresentationView || !this.getFactory().isValidDestination(this.getPaletteItem(), source, g)) continue;
            valid.add(g);
        }
        return Collections.unmodifiableList(valid);
    }
}

