/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.menu;

import java.awt.Component;
import javax.swing.JMenu;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.menu.AbstractDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;

public class DefaultDiagramMainMenuPlugin
extends AbstractDiagramMainMenuPlugin {
    private static final DiagramMainMenuPlugin INSTANCE = new DefaultDiagramMainMenuPlugin(true);
    private JMenu _zoom = null;

    public static final DiagramMainMenuPlugin getInstance() {
        return INSTANCE;
    }

    public DefaultDiagramMainMenuPlugin() {
    }

    public DefaultDiagramMainMenuPlugin(boolean cache) {
        super(cache);
    }

    @Override
    public void addMenuItems(Menubar mb, JMenu menu) {
        this.addAlignDistributeSectionItems(mb, menu, 10.0f);
        this.addArrangeSectionItems(mb, menu, 20.0f);
        this.addZoomSectionItems(mb, menu, 30.0f);
        this.addPublishSectionItems(mb, menu, 40.0f);
        this.addOtherSectionItems(mb, menu);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this._zoom = null;
    }

    protected void addAlignDistributeSectionItems(Menubar mb, JMenu parent, float sectionId) {
        mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ALIGN, 200.0f), parent, sectionId);
        mb.add((Component)mb.createMenuItem((ToggleAction)Actions.DISTRIBUTE, 210.0f), parent, sectionId);
    }

    protected void addArrangeSectionItems(Menubar mb, JMenu parent, float sectionId) {
        mb.add((Component)mb.createMenuItem((ToggleAction)Actions.BRING_TO_FRONT, 400.0f), parent, sectionId);
        mb.add((Component)mb.createMenuItem((ToggleAction)Actions.SEND_TO_BACK, 410.0f), parent, sectionId);
    }

    protected void addZoomSectionItems(Menubar mb, JMenu parent, float sectionId) {
        if (this._zoom == null) {
            JMenu zoom = mb.createSubMenu(RB.getString("ZoomMenu.text"), DefaultDiagramMainMenuPlugin.makeMnemonic(RB.getString("ZoomMenu.mnemonic")), 600.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_IN, 10.0f), zoom, 10.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_OUT, 20.0f), zoom, 10.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_400_PERCENT, 30.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_200_PERCENT, 40.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_150_PERCENT, 50.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_125_PERCENT, 60.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_100_PERCENT, 70.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_75_PERCENT, 80.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_50_PERCENT, 90.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_40_PERCENT, 100.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_25_PERCENT, 110.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_15_PERCENT, 120.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_10_PERCENT, 130.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_5_PERCENT, 140.0f), zoom, 210.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_SELECTED, 150.0f), zoom, 410.0f);
            mb.add((Component)mb.createMenuItem((ToggleAction)Actions.ZOOM_FIT_TO_WINDOW, 160.0f), zoom, 410.0f);
            this._zoom = zoom;
        }
        mb.add((Component)this._zoom, parent, sectionId);
    }

    protected void addPublishSectionItems(Menubar mb, JMenu parent, float sectionId) {
        mb.add((Component)mb.createMenuItem((ToggleAction)Actions.PUBLISH_DIAGRAM, 800.0f), parent, sectionId);
    }

    protected void addOtherSectionItems(Menubar mb, JMenu parent) {
    }
}

