/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.geom.Vector2DUtil;
import oracle.diagram.framework.link.Glyph;

public abstract class RenderedGlyph
implements Glyph {
    private RenderingHints _renderHints;
    private Color _foreground;
    private IlvPoint _from;
    private IlvPoint _to;
    private Shape _cachedShape;
    private IlvRect _boundingBox = new IlvRect();

    protected abstract Shape getShape();

    protected abstract FillColor getFillColor();

    public void setRenderingHints(RenderingHints renderHints) {
        this._renderHints = renderHints;
    }

    protected RenderingHints getRenderingHints() {
        return this._renderHints;
    }

    public void setForeground(Color color) {
        this._foreground = color;
    }

    @Override
    public void draw(Graphics g, IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        Shape shape = this.fetchShape(node, from, to, transformer, dx);
        Graphics2D g2d = (Graphics2D)g.create();
        this.setUpGraphics(g2d, node, shape, transformer);
        Color oldColor = g2d.getColor();
        Color glyphColor = this._foreground != null ? this._foreground : oldColor;
        AffineTransform g2dTrans = g2d.getTransform();
        AffineTransform localTrans = new AffineTransform(g2dTrans);
        localTrans.scale(transformer.getx11(), transformer.getx22());
        g2d.setTransform(localTrans);
        AffineTransform reverseScale = new AffineTransform();
        reverseScale.scale(transformer.getx11(), transformer.getx22());
        try {
            reverseScale = reverseScale.createInverse();
        }
        catch (NoninvertibleTransformException nex) {
            reverseScale = new AffineTransform();
        }
        shape = reverseScale.createTransformedShape(shape);
        FillColor fillColor = this.getFillColor();
        if (fillColor != FillColor.NULL_COLOR) {
            if (fillColor == FillColor.EDGE_COLOR) {
                g2d.setColor(glyphColor);
            } else if (fillColor == FillColor.BACK_COLOR) {
                GraphicsConfiguration gc = g2d.getDeviceConfiguration();
                if (gc != null && (gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1)) {
                    g2d.setColor(Color.WHITE);
                } else {
                    g2d.setColor(g2d.getBackground());
                }
            } else {
                g2d.setColor(fillColor.getColor());
            }
            g2d.fill(shape);
        }
        g2d.setColor(glyphColor);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(shape);
    }

    private Shape fetchShape(IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        if (!from.equals((Object)this._from) || !to.equals((Object)this._to)) {
            if (this._from == null) {
                this._from = new IlvPoint(from);
            }
            if (this._to == null) {
                this._to = new IlvPoint(from.x + 1.0f, from.y);
            }
            if (from.equals((Object)to)) {
                IlvPoint p;
                float[] v = new float[2];
                Vector2DUtil.unit(this._to.x - this._from.x, this._to.y - this._from.y, v);
                to = p = new IlvPoint(from.x + v[0], from.y + v[1]);
            }
            this._cachedShape = this.getTransformedShape(node, from, to, transformer, dx);
            this._boundingBox.setFrame(this._cachedShape.getBounds2D());
            this._boundingBox.expand(2.0f);
            transformer.inverse(this._boundingBox);
            this._from.setLocation((Point2D)from);
            this._to.setLocation((Point2D)to);
        }
        return this._cachedShape;
    }

    public IlvRect boundingBox(IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer t) {
        this.fetchShape(node, from, to, t, 0.0f);
        return this.boundingBox();
    }

    protected void setUpGraphics(Graphics2D g2d, IlvGraphic node, Shape shape, IlvTransformer transformer) {
        if (this._renderHints != null) {
            g2d.setRenderingHints(this._renderHints);
        }
    }

    @Override
    public float getWidth() {
        return (float)this.getShape().getBounds2D().getWidth();
    }

    @Override
    public float getHeight() {
        return (float)this.getShape().getBounds2D().getHeight();
    }

    @Override
    public IlvRect boundingBox() {
        return this._boundingBox;
    }

    protected AffineTransform calcAffineTransform(IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        AffineTransform t = new AffineTransform();
        t.translate(to.x, to.y);
        float a = to.x - from.x;
        float b = to.y - from.y;
        double angle = 0.0;
        if (a == 0.0f) {
            angle = 1.5707963267948966 * (double)Math.signum(b);
        } else {
            angle = Math.atan(b / a);
            if (a < 0.0f) {
                angle += Math.PI;
            }
        }
        t.rotate(angle);
        if (dx != 0.0f) {
            t.translate(dx, 0.0);
        }
        t.scale(transformer.getx11(), transformer.getx22());
        return t;
    }

    public Shape getTransformedShape(IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        AffineTransform t = this.calcAffineTransform(from, to, transformer, dx);
        if (t != null) {
            return t.createTransformedShape(this.getShape());
        }
        return null;
    }

    protected static Rectangle2D grow(Rectangle2D rect, double dw, double dh) {
        rect.setRect(rect.getX() - dw, rect.getY() - dh, rect.getWidth() + dw * 2.0, rect.getHeight() + dh * 2.0);
        return rect;
    }

    protected static class FillColor {
        public static final FillColor EDGE_COLOR = new FillColor();
        public static final FillColor BACK_COLOR = new FillColor();
        public static final FillColor NULL_COLOR = new FillColor();
        private Color _color;

        private FillColor() {
        }

        public FillColor(Color color) {
            this._color = color;
        }

        public Color getColor() {
            return this._color;
        }
    }
}

