/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreSelectInteractorMoveSelection;
import oracle.diagram.core.util.IlvGraphicEnumerationFromIterator;
import oracle.diagram.core.util.Translator;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.interaction.MoveGraphicsEvent;
import oracle.diagram.framework.interaction.MoveGraphicsHelper;
import oracle.diagram.framework.interaction.MoveGraphicsListener;
import oracle.diagram.framework.interaction.MoveGraphicsPlugin;
import oracle.diagram.framework.interaction.SelectInteractor;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.framework.selection.DiagramIdeSelectionPlugin;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubSelectableShape;
import oracle.diagram.framework.undo.CompositeUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;

public class SelectInteractorMoveSelection
extends CoreSelectInteractorMoveSelection {
    private Set<IlvGraphic> _allMovingGraphics;
    private List<MoveGraphicsHelper> _helpers = Collections.emptyList();
    private LinkedList<MoveGraphicsListener> _listeners = new LinkedList();
    private Set<IlvGraphic> _noHelpersMovingGraphics;
    private MoveGraphicsEvent _event;
    private boolean _diagramIdeSelectionPluginDisabled = false;
    private IlvPoint _mgrDragEventPoint = new IlvPoint();

    public SelectInteractorMoveSelection(SelectInteractor inter) {
        super(inter);
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    public List<MoveGraphicsListener> getMoveGraphicsListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    @Override
    protected void detach() {
        IlvManagerView view = this.getManagerView();
        DiagramContext dc = DiagramContext.getDiagramContext(view);
        DiagramIdeSelectionPlugin esp = dc.getPlugin(DiagramIdeSelectionPlugin.class);
        if (esp != null && this._diagramIdeSelectionPluginDisabled) {
            this._diagramIdeSelectionPluginDisabled = false;
            esp.setEnabled(true);
        }
        super.detach();
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        IlvManagerView view = this.getManagerView();
        DiagramContext dc = DiagramContext.getDiagramContext(view);
        DiagramIdeSelectionPlugin esp = dc.getPlugin(DiagramIdeSelectionPlugin.class);
        if (esp != null && !this._diagramIdeSelectionPluginDisabled) {
            esp.setEnabled(false);
            this._diagramIdeSelectionPluginDisabled = true;
        }
        super.processKeyEvent(keyEvent);
    }

    public void addMoveGraphicsListener(MoveGraphicsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeMoveGraphicsListener(MoveGraphicsListener l) {
        if (this._listeners.contains(l)) {
            this._listeners.remove(l);
        }
    }

    @Override
    protected void cleanupMoveState() {
        super.cleanupMoveState();
        this._allMovingGraphics.clear();
        this._noHelpersMovingGraphics.clear();
        for (MoveGraphicsHelper helper : this._helpers) {
            helper.cleanUp();
        }
        this._helpers.clear();
        this._event = null;
    }

    protected UndoableStep createUndoableStep() {
        if (!this._helpers.isEmpty()) {
            CompositeUndoableStep cs = new CompositeUndoableStep();
            for (MoveGraphicsHelper helper : this._helpers) {
                UndoableStep step = helper.createUndoableStep();
                if (step == null) continue;
                cs.addUndoableStep(step);
            }
            if (cs.hasSteps()) {
                return cs;
            }
        }
        return null;
    }

    @Override
    protected void prepareInitialMoveState() {
        super.prepareInitialMoveState();
        this._allMovingGraphics = new HashSet<IlvGraphic>();
        IlvGraphicEnumeration movingObjects = this.getMovingObjects();
        while (movingObjects.hasMoreElements()) {
            IlvGraphic g = movingObjects.nextElement();
            if (this._movingContainedObjects.contains(g)) continue;
            this._allMovingGraphics.add(g);
        }
        this._noHelpersMovingGraphics = new HashSet<IlvGraphic>(this._allMovingGraphics);
        IlvManagerView view = this.getManagerView();
        DiagramContext dc = DiagramContext.getDiagramContext(view);
        MoveGraphicsPlugin plugin = dc.getPlugin(MoveGraphicsPlugin.class);
        if (plugin != null) {
            this._helpers = plugin.createMoveGraphicsHelpers(this._noHelpersMovingGraphics);
        }
        this._event = new MoveGraphicsEvent(this.getManagerView().getManager(), 0, this._allMovingGraphics);
        for (MoveGraphicsListener l : this._listeners) {
            l.graphicsMoving(this._event);
        }
    }

    @Override
    protected boolean handleButtonDown(MouseEvent event) {
        IlvManagerView view = this.getManagerView();
        DiagramContext dc = DiagramContext.getDiagramContext(view);
        DiagramIdeSelectionPlugin esp = dc.getPlugin(DiagramIdeSelectionPlugin.class);
        if (esp != null && !this._diagramIdeSelectionPluginDisabled) {
            esp.setEnabled(false);
            this._diagramIdeSelectionPluginDisabled = true;
        }
        this._mgrDragEventPoint.setLocation((float)event.getX(), (float)event.getY());
        view.getTransformer().inverse(this._mgrDragEventPoint);
        view.getManager().getTopLevelTransformer().inverse(this._mgrDragEventPoint);
        return super.handleButtonDown(event);
    }

    @Override
    protected void rectangleDragged(AWTEvent event, float dx, float dy) {
        float cdx = dx;
        float cdy = dy;
        if (event instanceof MouseEvent) {
            IlvPoint lastPoint = new IlvPoint(this._mgrDragEventPoint);
            this._mgrDragEventPoint.setLocation((float)((MouseEvent)event).getX(), (float)((MouseEvent)event).getY());
            IlvManagerView view = this.getManagerView();
            view.getTransformer().inverse(this._mgrDragEventPoint);
            view.getManager().getTopLevelTransformer().inverse(this._mgrDragEventPoint);
        }
        super.rectangleDragged(event, cdx, cdy);
    }

    @Override
    protected void translateObjectsImpl(IlvGraphicEnumeration movingObjects, Translator translator, float dx, float dy) {
        float cdx = dx;
        float cdy = dy;
        for (MoveGraphicsHelper helper : this._helpers) {
            DimensionFloat vector = helper.getConstrainedMoveVector(cdx, cdy);
            if (vector.width == 0.0f && vector.height == 0.0f) {
                return;
            }
            cdx = vector.width;
            cdy = vector.height;
        }
        for (MoveGraphicsHelper helper : this._helpers) {
            helper.translateGraphics(translator, cdx, cdy);
        }
        super.translateObjectsImpl(new IlvGraphicEnumerationFromIterator(this._noHelpersMovingGraphics.iterator()), translator, cdx, cdy);
        if (this._event != null) {
            this._event.setType(1);
            for (MoveGraphicsListener l : this._listeners) {
                l.graphicsMoving(this._event);
            }
        }
    }

    @Override
    protected IlvGraphic getHitSubObject(IlvGraphic mainObject, IlvManagerView view, IlvPoint mousePoint) {
        if (mainObject instanceof SubSelectableShape) {
            return SubSelectionManager.getInstance().getSubObject(mainObject, mousePoint, view);
        }
        return null;
    }

    @Override
    protected void highlight(IlvGraphic targetObject, IlvGraphic targetSubObject, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        if (targetValidity == CoreSelectInteractorMoveSelection.MoveType.SIMPLE_MOVE) {
            super.highlight(targetObject, targetSubObject, targetValidity);
            return;
        }
        if (targetObject != this.getManager()) {
            this.setSelectedMainObject(targetObject, true);
        }
        if (targetSubObject != null) {
            SubSelectionManager.getInstance().select(targetObject, targetSubObject, true, true);
        }
    }

    @Override
    protected void unhighlight(IlvGraphic targetObject, IlvGraphic targetSubObject, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        if (targetValidity == CoreSelectInteractorMoveSelection.MoveType.SIMPLE_MOVE) {
            super.unhighlight(targetObject, targetSubObject, targetValidity);
            return;
        }
        if (targetObject != this.getManager()) {
            this.setSelectedMainObject(targetObject, false);
        }
        if (targetSubObject != null) {
            SubSelectionManager.getInstance().select(targetObject, targetSubObject, false, true);
        }
    }

    @Override
    protected CoreSelectInteractorMoveSelection.MoveType validateTarget(IlvGraphic hitObject, IlvGraphic hitSubObject, int modifiers) {
        CoreSelectInteractorMoveSelection.MoveType moveType = CoreSelectInteractorMoveSelection.MoveType.INVALID;
        if ((modifiers & 1) != 0) {
            moveType = CoreSelectInteractorMoveSelection.MoveType.MOVE;
        } else if ((modifiers & 2) != 0) {
            moveType = CoreSelectInteractorMoveSelection.MoveType.COPY;
        } else if ((modifiers & 8) != 0) {
            moveType = CoreSelectInteractorMoveSelection.MoveType.LINK;
        } else if (this.hasLeftOriginalContext()) {
            moveType = CoreSelectInteractorMoveSelection.MoveType.MOVE;
        } else {
            moveType = super.validateTarget(hitObject, hitSubObject, modifiers);
            if (moveType == CoreSelectInteractorMoveSelection.MoveType.INVALID) {
                return moveType;
            }
        }
        for (MoveGraphicsHelper helper : this._helpers) {
            moveType = helper.validateMoveTarget(hitObject, hitSubObject, modifiers, this._mgrDragEventPoint, moveType);
            if (moveType != CoreSelectInteractorMoveSelection.MoveType.INVALID) continue;
            return moveType;
        }
        return moveType;
    }

    @Override
    protected void moveComplete(AWTEvent event, IlvGraphic target, IlvGraphic subTarget, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        super.moveComplete(event, target, subTarget, targetValidity);
        this.moveCompleteImpl(event, target, subTarget, targetValidity);
    }

    protected void moveCompleteImpl(AWTEvent event, IlvGraphic target, IlvGraphic subTarget, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        if (event instanceof MouseEvent && !this._helpers.isEmpty()) {
            IlvPoint mgrDropPoint = new IlvPoint((float)((MouseEvent)event).getX(), (float)((MouseEvent)event).getY());
            IlvManagerView view = this.getManagerView();
            view.getTransformer().inverse(mgrDropPoint);
            view.getManager().getTopLevelTransformer().inverse(mgrDropPoint);
            IlvPoint mgrSourcePoint = new IlvPoint(this.getLastMousePressed());
            view.getTransformer().inverse(mgrSourcePoint);
            view.getManager().getTopLevelTransformer().inverse(mgrSourcePoint);
            CoreSelectInteractorMoveSelection.MoveType moveType = targetValidity;
            for (MoveGraphicsHelper helper : this._helpers) {
                moveType = helper.moveComplete(mgrSourcePoint, mgrDropPoint, target, subTarget, targetValidity);
            }
        }
        if (this._event != null) {
            this._event.setType(2);
            for (MoveGraphicsListener l : this._listeners) {
                l.graphicsMoving(this._event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSelectedMainObject(IlvGraphic ilvgraphic, boolean select) {
        IlvManager ilvmanager = (IlvManager)ilvgraphic.getGraphicBag();
        IlvManager ilvmanager1 = this.getManager();
        try {
            if (ilvmanager != ilvmanager1) {
                ilvmanager.setContentsAdjusting(true, true);
                ilvmanager1.setSelectionAdjusting(true);
            }
            if (ilvmanager.isSelectable(ilvgraphic)) {
                ilvmanager.setSelected(ilvgraphic, select, true);
            }
        }
        finally {
            if (ilvmanager != ilvmanager1) {
                ilvmanager1.setSelectionAdjusting(false);
                ilvmanager.setContentsAdjusting(false, true);
            }
        }
    }

    @Override
    protected boolean isMoveAllowed() {
        if (super.isMoveAllowed()) {
            IlvGraphic[] graphics = new IlvGraphic[this.getMovingObjectsCount() + this.getMovingSubObjectsCount()];
            int i = 0;
            IlvGraphicEnumeration e = this.getMovingObjects();
            while (e.hasMoreElements()) {
                graphics[i++] = e.nextElement();
            }
            e = this.getMovingSubObjects();
            while (e.hasMoreElements()) {
                graphics[i++] = e.nextElement();
            }
            return ReadOnlyUtil.checkWritableMoveGraphics(this.getDiagramContext(), graphics);
        }
        return false;
    }
}

