/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.SelectionHandles;
import oracle.diagram.framework.interaction.ReadOnlyReshapeSelection;
import oracle.diagram.framework.interaction.ReshapeSelectionHelper;
import oracle.diagram.framework.interaction.ReshapeSelectionPlugin;
import oracle.diagram.framework.undo.CompositeUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.diagram.framework.undo.UndoableStepManager;

public class ReshapeSelectionInteractor
extends ReadOnlyReshapeSelection
implements SelectionHandles {
    private UndoableStep _undoStep = null;
    private boolean _isPivotAllowed = true;
    private IlvRect _originalRect;
    private int _handle = -1;
    private List<ReshapeSelectionHelper> _helpers = Collections.emptyList();
    private boolean _callPreReshape = false;

    public ReshapeSelectionInteractor() {
        this.setOpaqueMode(true);
    }

    public final boolean isPivotAllowed() {
        return this._isPivotAllowed;
    }

    public final void setPivotAllowed(boolean allowed) {
        this._isPivotAllowed = allowed;
    }

    protected boolean handleButtonDown(IlvDrawSelection sel, MouseEvent event, IlvObjectInteractorContext context) {
        if (super.handleButtonDown(sel, event, context)) {
            this._handle = sel.getHandle(new IlvPoint((float)event.getX(), (float)event.getY()), context.getTransformer());
            return true;
        }
        return false;
    }

    protected void getAllAffectedGraphics(IlvGraphic reshapeGraphic, Set<IlvGraphic> allGraphics) {
        allGraphics.add(reshapeGraphic);
    }

    protected void reshapeInitiated(IlvDrawSelection ds, IlvObjectInteractorContext context) {
        DiagramContext dc;
        ReshapeSelectionPlugin plugin;
        super.reshapeInitiated(ds, context);
        IlvGraphic graphic = ds.getObject();
        this._originalRect = new IlvRect(graphic.boundingBox(null));
        HashSet<IlvGraphic> allGraphics = new HashSet<IlvGraphic>();
        this.getAllAffectedGraphics(graphic, allGraphics);
        this._undoStep = this.createUndoableStep(allGraphics);
        if (this._undoStep != null) {
            this._undoStep.storeUndoState();
        }
        if ((plugin = (dc = ReshapeSelectionInteractor.getDiagramContext(this.getLastContext())).getPlugin(ReshapeSelectionPlugin.class)) != null) {
            this._helpers = plugin.getReshapeSelectionHelpers();
            CompositeUndoableStep compositeStep = new CompositeUndoableStep();
            for (ReshapeSelectionHelper helper : this._helpers) {
                helper.reshapeInitiated(graphic);
                UndoableStep step = helper.createUndoableStep(graphic);
                if (step == null) continue;
                compositeStep.addUndoableStep(step);
            }
            if (compositeStep.hasSteps()) {
                compositeStep.storeUndoState();
                compositeStep.addUndoableStep(this._undoStep);
                this._undoStep = compositeStep;
            }
        }
    }

    protected void reshapeComplete(IlvDrawSelection ds, IlvObjectInteractorContext context) {
        IlvGraphic graphic = ds.getObject();
        if (this._undoStep != null) {
            this._undoStep.storeRedoState();
            UndoableStepManager usm = this.getUndoableStepManager(graphic);
            if (usm != null) {
                usm.addUndoableStep(this._undoStep, this.getUndoDescription(graphic));
            }
        }
        for (ReshapeSelectionHelper helper : this._helpers) {
            helper.reshapeComplete(graphic);
        }
        this._helpers = null;
        super.reshapeComplete(ds, context);
    }

    protected final int getHandle() {
        return this._handle;
    }

    protected final IlvRect getOriginalRect() {
        return this._originalRect;
    }

    protected String getUndoDescription(IlvGraphic graphic) {
        return null;
    }

    protected UndoableStepManager getUndoableStepManager(IlvGraphic graphic) {
        return null;
    }

    protected UndoableStep createUndoableStep(Set<IlvGraphic> allGraphics) {
        return null;
    }

    protected void reshapeObject(IlvGraphic graphic, IlvRect rect) {
        for (ReshapeSelectionHelper helper : this._helpers) {
            helper.constrainReshapeRect(graphic, this._handle, this._isPivotAllowed, this._originalRect, rect);
        }
        if (this._callPreReshape) {
            this.preReshapeObject(graphic, this._handle, this._isPivotAllowed, this._originalRect, rect);
            this._callPreReshape = false;
        }
        IlvRect newOriginalRect = new IlvRect(this._originalRect);
        this.getLastContext().getTransformer().apply(newOriginalRect);
        this.setOriginalBoundingBox(newOriginalRect);
        super.reshapeObject(graphic, rect);
        switch (this._handle) {
            case 0: 
            case 3: 
            case 5: {
                IlvRect newRect = new IlvRect(graphic.boundingBox(null));
                if (!(newRect.x + newRect.width > this._originalRect.x + this._originalRect.width)) break;
                rect.x = this._originalRect.x + this._originalRect.width - newRect.width;
                super.reshapeObject(graphic, rect);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reshape(IlvGraphic graphic, IlvObjectInteractorContext context, IlvPoint trackPoint) {
        DiagramContext dc = ReshapeSelectionInteractor.getDiagramContext(this.getLastContext());
        IlvManagerView view = dc.getManagerView();
        IlvManager topManager = view.getManager();
        topManager.setContentsAdjusting(true);
        topManager.initReDraws();
        int redrawMode = view.getRedrawMode();
        view.setRedrawMode(1);
        try {
            IlvRect oldRect = new IlvRect(graphic.boundingBox(null));
            this._callPreReshape = true;
            super.reshape(graphic, context, trackPoint);
            this.postReshapeObject(graphic, this._handle, this._isPivotAllowed, this._originalRect, oldRect);
        }
        finally {
            topManager.setContentsAdjusting(false);
            try {
                view.setRedrawMode(1);
                topManager.reDrawViews();
            }
            finally {
                view.setRedrawMode(redrawMode);
            }
        }
    }

    protected void preReshapeObject(IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect newRect) {
        for (ReshapeSelectionHelper helper : this._helpers) {
            helper.preReshapeObject(graphic, handle, isPivotAllowed, originalRect, newRect);
        }
    }

    protected void postReshapeObject(IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect oldRect) {
        for (ReshapeSelectionHelper helper : this._helpers) {
            helper.postReshapeObject(graphic, handle, isPivotAllowed, originalRect, oldRect);
        }
    }
}

