/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.undo;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.undo.AbstractUndoableStep;

public class GenericLayoutUndoableStep
extends AbstractUndoableStep {
    private final IlvCompositeGraphic _owner;
    private IlvRect _oldBounds = null;
    private IlvRect _newBounds = null;

    public GenericLayoutUndoableStep(IlvCompositeGraphic owner) {
        this._owner = owner;
    }

    protected void update() {
        IlvManager mgr = ManagerUtil.getTopManager((IlvGraphic)this._owner);
        try {
            mgr.initReDraws();
            mgr.invalidateRegion(this._oldBounds);
            mgr.invalidateRegion(this._newBounds);
            this._owner.invalidate();
            this._owner.doLayout();
        }
        finally {
            mgr.reDrawViews();
        }
    }

    @Override
    public void undo() {
        this.update();
    }

    @Override
    public void redo() {
        this.update();
    }

    @Override
    public void storeUndoState() {
        IlvManager mgr = ManagerUtil.getTransformingManager((IlvGraphic)this._owner);
        IlvTransformer tx = mgr.getTopLevelTransformer();
        this._oldBounds = new IlvRect(this._owner.boundingBox(tx));
    }

    @Override
    public void storeRedoState() {
        IlvManager mgr = ManagerUtil.getTransformingManager((IlvGraphic)this._owner);
        IlvTransformer tx = mgr.getTopLevelTransformer();
        this._newBounds = new IlvRect(this._owner.boundingBox(tx));
    }
}

