/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.undo;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.undo.AbstractUndoableStep;
import oracle.javatools.util.Holder;

public abstract class AbstractApplyObjectUndoableStep
extends AbstractUndoableStep {
    private final IlvGraphic _graphic;
    private final IlvManager _applyManager;
    private final IlvGraphic _applyGraphic;

    public AbstractApplyObjectUndoableStep(IlvGraphic graphic) {
        this(graphic, (IlvManager)ManagerUtil.getManagedAncestor(graphic).getGraphicBag(), ManagerUtil.getManagedAncestor(graphic));
    }

    public AbstractApplyObjectUndoableStep(IlvGraphic graphic, IlvManager applyManager, IlvGraphic applyGraphic) {
        this._graphic = graphic;
        this._applyManager = applyManager;
        this._applyGraphic = applyGraphic;
    }

    @Override
    public void redo() throws Exception {
        this.undoRedo(false);
    }

    @Override
    public void undo() throws Exception {
        this.undoRedo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoRedo(final boolean undo) throws Exception {
        IlvGraphic g;
        IlvManager mgr = this._applyManager != null ? this._applyManager : (this.getGraphic().getGraphicBag() instanceof IlvManager ? (IlvManager)this.getGraphic().getGraphicBag() : null);
        IlvGraphic ilvGraphic = g = this._applyGraphic != null ? this._applyGraphic : this.getGraphic();
        if (mgr != null && mgr.isManaged(g)) {
            Holder h = new Holder();
            mgr.applyToObject(g, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    try {
                        if (undo) {
                            AbstractApplyObjectUndoableStep.this.undoImpl();
                        } else {
                            AbstractApplyObjectUndoableStep.this.redoImpl();
                        }
                    }
                    catch (Exception ex) {
                        ((Holder)object).set((Object)ex);
                    }
                }
            }, (Object)h, true);
            if (h.get() != null) {
                throw (Exception)h.get();
            }
        } else {
            IlvManager topMgr = ManagerUtil.getTopManager(this.getGraphic());
            boolean redrawViews = !topMgr.isInvalidating();
            try {
                if (redrawViews) {
                    topMgr.initReDraws();
                }
                ManagerUtil.invalidateRegion(this.getGraphic());
                if (undo) {
                    this.undoImpl();
                } else {
                    this.redoImpl();
                }
                ManagerUtil.invalidateRegion(this.getGraphic());
            }
            finally {
                if (redrawViews) {
                    topMgr.reDrawViews();
                }
            }
        }
    }

    protected final IlvGraphic getGraphic() {
        return this._graphic;
    }

    protected abstract void undoImpl() throws Exception;

    protected abstract void redoImpl() throws Exception;
}

