/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.port;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.DefaultSubNodeGrapherPin;
import oracle.diagram.framework.graphic.DefaultSubNodePinLinkConnectorFactory;
import oracle.diagram.framework.graphic.SubNodePinLinkConnectorFactory;
import oracle.diagram.framework.graphic.port.PinPosition;
import oracle.diagram.framework.graphic.port.PinSubShape;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.transformer.TransformerUtil;

public class RectanglePinGraphic
extends IlvRectangle
implements PinSubShape {
    private static final DefaultSubNodePinLinkConnectorFactory WEST_PIN_FACTORY = new DefaultSubNodePinLinkConnectorFactory(){

        @Override
        protected void createAndAddGrapherPins(IlvPinLinkConnector plc, IlvLinkImage link, IlvGraphic subshape, boolean origin) {
            plc.addPin((IlvGrapherPin)new DefaultSubNodeGrapherPin(plc, subshape, false));
        }
    };
    private static final DefaultSubNodePinLinkConnectorFactory EAST_PIN_FACTORY = new DefaultSubNodePinLinkConnectorFactory(){

        @Override
        protected void createAndAddGrapherPins(IlvPinLinkConnector plc, IlvLinkImage link, IlvGraphic subshape, boolean origin) {
            plc.addPin((IlvGrapherPin)new DefaultSubNodeGrapherPin(plc, subshape, true));
        }
    };
    private float _width;
    private float _height;
    private PinPosition _pinPosition;

    public RectanglePinGraphic() {
        this(10.0f, 10.0f);
    }

    public RectanglePinGraphic(float width, float height) {
        this(null, width, height);
    }

    public RectanglePinGraphic(PinPosition pinPosition, float width, float height) {
        this.setPinPosition(pinPosition);
        this._width = width;
        this._height = height;
        this.setProperty("__MovableShapeKey", false);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setFillOn(true);
        this.setStrokeOn(true);
        SubSelectionManager.setSelectable((IlvGraphic)this, true);
        this.moveResize(new IlvRect(0.0f, 0.0f, this._width, this._height));
    }

    public void setPinPosition(PinPosition pinPosition) {
        this._pinPosition = pinPosition;
        if (PinPosition.WEST.equals((Object)pinPosition)) {
            SubNodePinLinkConnectorFactory.Util.setFactory((IlvGraphic)this, WEST_PIN_FACTORY);
        } else if (PinPosition.EAST.equals((Object)pinPosition)) {
            SubNodePinLinkConnectorFactory.Util.setFactory((IlvGraphic)this, EAST_PIN_FACTORY);
        }
    }

    public PinPosition getPinPosition() {
        return this._pinPosition;
    }

    @Override
    public IlvPoint getConnectionPoint() {
        IlvPoint endPt = new IlvPoint(this.getCenter(null));
        IlvRect bbox = this.boundingBox(null);
        if (PinPosition.WEST.equals((Object)this._pinPosition)) {
            endPt.x = bbox.x;
        } else if (PinPosition.EAST.equals((Object)this._pinPosition)) {
            endPt.x = bbox.x + bbox.width;
        } else if (PinPosition.NORTH.equals((Object)this._pinPosition)) {
            endPt.y = bbox.y;
        } else if (PinPosition.SOUTH.equals((Object)this._pinPosition)) {
            endPt.y = bbox.y + bbox.height;
        }
        return endPt;
    }

    @Override
    public Color getShapeFillColor() {
        return this.getBackground();
    }

    @Override
    public void setShapeFillColor(Color color) {
        this.setBackground(color);
    }

    @Override
    public Font getShapeFont() {
        return null;
    }

    @Override
    public void setShapeFont(Font font) {
    }

    @Override
    public Color getShapeLineColor() {
        return this.getForeground();
    }

    @Override
    public void setShapeLineColor(Color color) {
        this.setForeground(color);
    }

    @Override
    public Color getShapeFontColor() {
        return null;
    }

    @Override
    public void setShapeFontColor(Color color) {
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        minimum.width = this._width;
        minimum.height = this._height;
        return minimum;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        prefered.width = this._width;
        prefered.height = this._height;
        return prefered;
    }

    @Override
    public void doLayout() {
    }

    public PathIterator getShapePath(IlvTransformer t) {
        AffineTransform at = TransformerUtil.getAffineTransform(t);
        return this.boundingBox(null).getPathIterator(at);
    }
}

