/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout.row;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.graphic.undo.AbstractApplyObjectUndoableStep;
import oracle.diagram.framework.manager.ManagerUtil;

public class ResizeRowUndoableStep
extends AbstractApplyObjectUndoableStep {
    private RowContainer m_container;
    private int m_rowIndex;
    private float m_undoHeight;
    private float m_redoHeight;

    public ResizeRowUndoableStep(RowContainer container, int rowIndex) {
        super(ManagerUtil.getManagedAncestor((IlvGraphic)container));
        this.m_container = container;
        this.m_rowIndex = rowIndex;
    }

    @Override
    protected void undoImpl() {
        this.m_container.resizeRow(this.m_rowIndex, this.m_undoHeight);
    }

    @Override
    protected void redoImpl() {
        this.m_container.resizeRow(this.m_rowIndex, this.m_redoHeight);
    }

    @Override
    public void storeUndoState() {
        this.m_undoHeight = this.getRowHeight();
    }

    @Override
    public void storeRedoState() {
        this.m_redoHeight = this.getRowHeight();
    }

    private float getRowHeight() {
        ExtendedGraphic row = this.m_container.getRowGraphic(this.m_rowIndex);
        IlvRect bbox = ((IlvGraphic)row).boundingBox(null);
        return bbox.height;
    }
}

