/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.graphic.DerivedShapeOutline;
import oracle.diagram.framework.transformer.TransformerUtil;

public class RectangleOutline
extends DerivedShapeOutline {
    boolean _isFillOn = true;
    boolean _isBorderOn = true;

    public RectangleOutline(IlvRect rect) {
        super(rect);
    }

    public RectangleOutline(RectangleOutline source) {
        super(source);
        this.setFillOn(source.isFillOn());
        this.setBorderOn(source.isBorderOn());
    }

    public void setFillOn(boolean value) {
        this._isFillOn = value;
    }

    public boolean isFillOn() {
        return this._isFillOn;
    }

    public void setBorderOn(boolean value) {
        this._isBorderOn = value;
    }

    public boolean isBorderOn() {
        return this._isBorderOn;
    }

    @Override
    public void draw(Graphics dst, IlvTransformer t) {
        IlvRect drawRect = new IlvRect(this._bounds);
        float penThickness = this.getThickness();
        if (t != null) {
            penThickness = TransformerUtil.getApplied(t, penThickness);
            TransformerUtil.apply(t, (Rectangle2D)drawRect);
        }
        Graphics2D g2d = (Graphics2D)dst;
        if (this._isFillOn) {
            g2d.setColor(this.getBackground());
            g2d.fill((Shape)drawRect);
        }
        g2d.setStroke(new BasicStroke(penThickness));
        if (this._isBorderOn) {
            g2d.setColor(this.getForeground());
            drawRect.width -= 1.0f;
            drawRect.height -= 1.0f;
            g2d.draw((Shape)drawRect);
        }
    }

    public void drawBorder(Graphics dst, IlvTransformer t) {
        if (this._isBorderOn) {
            Graphics2D g2d = (Graphics2D)dst;
            g2d.setColor(this.getForeground());
            IlvRect drawRect = new IlvRect(this._bounds);
            if (t != null) {
                TransformerUtil.apply(t, (Rectangle2D)drawRect);
            }
            drawRect.width -= 1.0f;
            drawRect.height -= 1.0f;
            g2d.draw((Shape)drawRect);
        }
    }

    @Override
    public Shape getShape() {
        return this._bounds;
    }

    @Override
    public IlvGraphic copy() {
        return new RectangleOutline(this);
    }
}

