/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import oracle.diagram.framework.graphic.DerivedShapeOutline;
import oracle.diagram.framework.transformer.TransformerUtil;

public class NoteShapeOutline
extends DerivedShapeOutline {
    static final float CORNER_SIZE = 4.0f;

    public NoteShapeOutline(IlvRect rect) {
        super(rect);
    }

    public NoteShapeOutline(NoteShapeOutline source) {
        super(source);
    }

    public NoteShapeOutline(IlvInputStream stream) throws IlvReadFileException {
        super(stream);
    }

    @Override
    public IlvGraphic copy() {
        return new NoteShapeOutline(this);
    }

    @Override
    public GeneralPath getShape() {
        IlvRect r = this._bounds;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(r.x + 4.0f, r.y);
        gp.lineTo(r.x + r.width - 15.0f, r.y);
        gp.lineTo(r.x + r.width, r.y + 15.0f);
        gp.lineTo(r.x + r.width, r.y + r.height - 4.0f);
        gp.quadTo(r.x + r.width, r.y + r.height, r.x + r.width - 4.0f, r.y + r.height);
        gp.lineTo(r.x + 4.0f, r.y + r.height);
        gp.quadTo(r.x, r.y + r.height, r.x, r.y + r.height - 4.0f);
        gp.lineTo(r.x, r.y + 4.0f);
        gp.quadTo(r.x, r.y, r.x + 4.0f, r.y);
        return gp;
    }

    @Override
    public void draw(Graphics dst, IlvTransformer t) {
        super.draw(dst, t);
        GeneralPath foldPath = this.createFoldPath();
        float penThickness = this.getThickness();
        if (t != null) {
            foldPath.transform(TransformerUtil.getAffineTransform(t));
            penThickness = TransformerUtil.getApplied(t, penThickness);
        }
        Graphics2D g2d = (Graphics2D)dst;
        g2d.setStroke(new BasicStroke(penThickness, 1, 1));
        g2d.setPaint(Color.white);
        g2d.fill(foldPath);
        g2d.setColor(this.getForeground());
        g2d.draw(foldPath);
    }

    private GeneralPath createFoldPath() {
        IlvRect r = this._bounds;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(r.x + r.width - 15.0f, r.y);
        gp.lineTo(r.x + r.width, r.y + 15.0f);
        gp.lineTo(r.x + r.width - 15.0f + 4.0f, r.y + 15.0f);
        gp.quadTo(r.x + r.width - 15.0f, r.y + 15.0f, r.x + r.width - 15.0f, r.y + 15.0f - 4.0f);
        gp.closePath();
        return gp;
    }
}

