/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import oracle.diagram.framework.graphic.Constants;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.diagram.framework.graphic.ShapeUtil;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.ide.thumbnail.ThumbnailConstants;

public abstract class DerivedShapeOutline
extends IlvGraphic
implements IlvShapePath {
    protected final IlvRect _bounds = new IlvRect();
    private Color _foreground = Color.BLACK;
    private Color _background = Color.WHITE;
    private float _thickness = 1.0f;
    private boolean _gradientFillOn = false;

    public DerivedShapeOutline() {
    }

    public DerivedShapeOutline(IlvRect bounds) {
        this.setBounds(bounds);
    }

    public DerivedShapeOutline(DerivedShapeOutline source) {
        super((IlvGraphic)source);
        this.setForeground(source.getForeground());
        this.setThickness(source.getThickness());
        this.setBounds(source._bounds);
    }

    public DerivedShapeOutline(IlvInputStream stream) throws IlvReadFileException {
        super(stream);
        this.setForeground(stream.readColor("foreground"));
        this.setBackground(stream.readColor("background"));
        this.setThickness(stream.readInt("thickness"));
        IlvRect rect = stream.readRect("rectangle");
        this.setBounds(rect);
    }

    private void setBounds(IlvRect bounds) {
        this._bounds.reshape(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void applyTransform(IlvTransformer t) {
        t.apply(this._bounds);
    }

    public abstract Shape getShape();

    public void setBackground(Color color) {
        this._background = color;
    }

    public void setGradientFillOn(boolean on) {
        this._gradientFillOn = on;
    }

    public IlvRect boundingBox(IlvTransformer t) {
        IlvRect rect = new IlvRect(this._bounds);
        if (t != null) {
            t.apply(rect);
        }
        return rect;
    }

    public boolean contains(IlvPoint p, IlvPoint tp, IlvTransformer t) {
        Shape rounded = this.getShape();
        return rounded.contains(p.x, p.y);
    }

    public void draw(Graphics dst, IlvTransformer t) {
        Shape shape = this.getShape();
        float shadowStep = 1.0f;
        float penThickness = this._thickness;
        if (t != null) {
            penThickness = TransformerUtil.getApplied(t, penThickness);
            shape = TransformerUtil.getApplied(t, shape);
            shadowStep = TransformerUtil.getApplied(t, shadowStep);
        }
        Graphics2D g2d = (Graphics2D)dst;
        boolean isThumbnail = Boolean.TRUE.equals(g2d.getRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT));
        Object shadowHint = g2d.getRenderingHint(DiagramRenderingHints.KEY_SHAPE_SHADOW);
        if (shadowHint == null || shadowHint == DiagramRenderingHints.VALUE_SHAPE_SHADOW_ON) {
            g2d.setColor(Constants.DROP_SHADOW_COLOR);
            AffineTransform transform = new AffineTransform();
            for (int step = 0; step < 4; ++step) {
                transform.setToTranslation(shadowStep * (float)(step + 1), shadowStep * (float)(step + 1));
                g2d.fill(transform.createTransformedShape(shape));
            }
        }
        g2d.setStroke(new BasicStroke(penThickness));
        if (this._gradientFillOn && !isThumbnail) {
            Paint shapeFill = ShapeUtil.getGradientForShape(shape.getBounds2D(), this._background, true);
            g2d.setPaint(shapeFill);
        } else {
            g2d.setColor(this._background);
        }
        g2d.fill(shape);
        g2d.setColor(this._foreground);
        g2d.draw(shape);
    }

    public float getThickness() {
        return this._thickness;
    }

    public void setForeground(Color foreground) {
        this._foreground = foreground;
    }

    public void setThickness(float thickness) {
        this._thickness = thickness;
    }

    public abstract IlvGraphic copy();

    public IlvSelection makeSelection() {
        return null;
    }

    public Color getBackground() {
        return this._background;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void write(IlvOutputStream stream) throws IOException {
        super.write(stream);
        stream.write("foreground", this.getForeground());
        stream.write("background", this.getBackground());
        stream.write("thickness", this.getThickness());
        stream.write("rectangle", this._bounds);
    }

    public PathIterator getShapePath(IlvTransformer t) {
        Shape shape = this.getShape();
        AffineTransform at = TransformerUtil.getAffineTransform(t);
        return shape.getPathIterator(at);
    }

    public boolean zoomable() {
        return true;
    }
}

