/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.awt.Graphics;

public class DefaultSubNodeGrapherPin
extends IlvGrapherPin {
    private final boolean _side;
    private final IlvGraphic _graphic;

    public DefaultSubNodeGrapherPin(IlvPinLinkConnector plc, IlvGraphic g, boolean side) {
        super(plc);
        this._graphic = g;
        this._side = side;
    }

    public IlvPoint getPosition(IlvTransformer tx) {
        IlvGraphic g = this.getGraphic();
        IlvRect bbox = g.boundingBox(tx);
        IlvPoint loc = new IlvPoint((float)bbox.getX() + (this.getSide() ? (float)bbox.getWidth() : 0.0f), (float)bbox.getCenterY());
        this.constrainToParentExtent(loc, tx);
        return loc;
    }

    protected void constrainToParentExtent(IlvPoint loc, IlvTransformer tx) {
        IlvGraphicBag bag = this.getGraphic().getGraphicBag();
        if (bag != null && bag instanceof IlvGraphic) {
            IlvRect r = ((IlvGraphic)bag).boundingBox(tx);
            if (loc.x > r.x + r.width - 1.0f || loc.x < r.x + 1.0f) {
                float f = loc.x = this._side ? r.x + r.width - 1.0f : r.x + 1.0f;
            }
            if (loc.y < r.y || loc.y > r.y + r.height) {
                loc.y = r.y;
            }
        }
    }

    public boolean allowsMove() {
        return false;
    }

    protected final IlvGraphic getGraphic() {
        return this._graphic;
    }

    protected final boolean getSide() {
        return this._side;
    }

    public int getSize() {
        return 1;
    }

    protected boolean zoomable() {
        return true;
    }

    protected void drawGhost(Graphics graphics, IlvTransformer ilvTransformer) {
    }
}

