/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.util;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.util.collections.IlvBreadthFirstIterator;
import ilog.views.util.collections.IlvCollections;
import ilog.views.util.collections.IlvPreorderIterator;
import ilog.views.util.collections.IlvSelectiveIterator;
import ilog.views.util.collections.IlvUnaryPredicate;
import java.awt.Point;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bm.util.DebugUtils;
import oracle.diagram.framework.dragdrop.IDropTargetValidator;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.IMultipresentationContainer;
import oracle.diagram.framework.manager.ManagerUtil;

public class CoreGraphicUtils {
    private static final String testNameProperty = "_oracle_testname_";
    private static volatile long id = 1L;

    protected CoreGraphicUtils() {
    }

    public static boolean setTestName(IlvGraphic graphic, String name) {
        List<IlvGraphic> objects;
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        if (graphic.getGraphicBag() != null && !(objects = CoreGraphicUtils.getObjectWithTestName(graphic.getGraphicBag(), name)).isEmpty()) {
            return false;
        }
        graphic.setProperty(testNameProperty, (Object)name);
        return true;
    }

    public static String getTestName(IlvGraphic graphic) {
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        return (String)graphic.getProperty(testNameProperty);
    }

    public static List<IlvGraphic> getObjectWithTestName(IlvGraphicBag bag, String testName) {
        if (bag == null) {
            throw new IllegalArgumentException("Argument bag must not be null");
        }
        if (bag.getObjects() == null) {
            return Collections.emptyList();
        }
        ArrayList<IlvGraphic> objects = new ArrayList<IlvGraphic>();
        IlvGraphicEnumeration ge = bag.getObjects();
        while (ge.hasMoreElements()) {
            IlvGraphic graphic = ge.nextElement();
            String name = CoreGraphicUtils.getTestName(graphic);
            if (!CoreGraphicUtils.equals(name, testName)) continue;
            objects.add(graphic);
        }
        return objects;
    }

    public static long nextTestId() {
        long v = id++;
        return v;
    }

    public static void resetTestId() {
        id = 1L;
    }

    private static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static IlvGraphic getManagedParent(IlvGraphic g) {
        IlvGraphic child = g;
        for (IlvGraphicBag parent = g.getGraphicBag(); parent != null; parent = parent.getGraphicBag()) {
            if (child instanceof IlvGraphic && parent instanceof IlvManager && ((IlvManager)parent).isManaged(child)) {
                return child;
            }
            child = parent;
        }
        return null;
    }

    public static IlvGraphic getManagedParentNode(IlvGraphic g) {
        IlvGraphic child = g;
        for (IlvGraphicBag parent = g.getGraphicBag(); parent != null; parent = parent.getGraphicBag()) {
            if (child instanceof IlvGraphic && parent instanceof IlvGrapher && ((IlvGrapher)parent).isManaged(child) && ((IlvGrapher)parent).isNode(child)) {
                return child;
            }
            child = parent;
        }
        return null;
    }

    public static IlvGraphic getVisibleManagedParentNode(IlvGraphic g) {
        IlvGraphic child = g;
        for (IlvGraphicBag parent = g.getGraphicBag(); parent != null; parent = parent.getGraphicBag()) {
            if (child instanceof IlvGraphic && parent instanceof IlvGrapher && ((IlvGrapher)parent).isManaged(child) && ((IlvGrapher)parent).isNode(child)) {
                return child;
            }
            child = parent;
        }
        return null;
    }

    public static boolean isReallyVisible(IlvGraphic graphic) {
        if (graphic == null) {
            return false;
        }
        if (!graphic.isVisible()) {
            return false;
        }
        for (IlvGraphicBag bag = graphic.getGraphicBag(); bag != null; bag = bag.getGraphicBag()) {
            if (bag instanceof IlvGraphic && !((IlvGraphic)bag).isVisible()) {
                return false;
            }
            if (!(bag instanceof IlvManager) || !((IlvManager)bag).isCollapsed()) continue;
            return false;
        }
        return true;
    }

    public static boolean originAndDestinationVisible(IlvLinkImage link) {
        if (link == null) {
            throw new IllegalArgumentException("Argument link must not be null");
        }
        if (link.getFrom() != link.getVisibleFrom() || link.getTo() != link.getVisibleTo()) {
            return false;
        }
        return CoreGraphicUtils.isReallyVisible(link.getFrom()) && CoreGraphicUtils.isReallyVisible(link.getTo());
    }

    public static boolean originAndDestinationVisible(IlvLinkImage link, IlvGraphic from, IlvGraphic to) {
        if (link == null) {
            throw new IllegalArgumentException("Argument link must not be null");
        }
        if (link.getFrom() instanceof FakeNode || link.getTo() instanceof FakeNode) {
            if (link.getFrom() instanceof FakeNode && link.getTo() instanceof FakeNode) {
                return CoreGraphicUtils.isReallyVisible(from) && CoreGraphicUtils.isReallyVisible(to);
            }
            if (link.getFrom() instanceof FakeNode) {
                if (link.getTo() != link.getVisibleTo()) {
                    return false;
                }
                return CoreGraphicUtils.isReallyVisible(from) && CoreGraphicUtils.isReallyVisible(link.getTo());
            }
            if (link.getTo() instanceof FakeNode) {
                if (link.getFrom() != link.getVisibleFrom()) {
                    return false;
                }
                return CoreGraphicUtils.isReallyVisible(link.getFrom()) && CoreGraphicUtils.isReallyVisible(to);
            }
        } else {
            return CoreGraphicUtils.originAndDestinationVisible(link);
        }
        return true;
    }

    public static boolean isValidDropTarget(IlvGraphic graphic) {
        if (graphic instanceof IDropTargetValidator) {
            return ((IDropTargetValidator)graphic).isValidDropTarget();
        }
        return !(graphic instanceof IlvManager) || !((IlvManager)graphic).isCollapsed();
    }

    public static Iterable<IlvGraphicBag> getBreadthFirstGraphicBagIterator(final IlvGraphicBag root) {
        return new Iterable<IlvGraphicBag>(){

            @Override
            public Iterator<IlvGraphicBag> iterator() {
                if (root != null) {
                    return new GraphicBagIterator(root);
                }
                return IlvCollections.emptyIterator();
            }
        };
    }

    public static Iterable<IlvGraphicBag> getDFSPreorderGraphicBagIterator(final IlvGraphicBag root) {
        return new Iterable<IlvGraphicBag>(){

            @Override
            public Iterator<IlvGraphicBag> iterator() {
                if (root == null) {
                    return IlvCollections.emptyIterator();
                }
                return new DFSPreorderGraphicBagIterator(root);
            }
        };
    }

    public static Iterable<IlvGraphic> getDFSPreorderIlvGraphicIterator(final IlvGraphic root, final boolean excludeInvisibleGraphic, final IlvUnaryPredicate<IlvGraphic> filter) {
        return new Iterable<IlvGraphic>(){

            @Override
            public Iterator<IlvGraphic> iterator() {
                if (root == null) {
                    return IlvCollections.emptyIterator();
                }
                DFSPreorderIlvGraphicIterator iterator = new DFSPreorderIlvGraphicIterator(root, excludeInvisibleGraphic);
                if (filter == null) {
                    return iterator;
                }
                return new IlvSelectiveIterator((Iterator)((Object)iterator), filter);
            }
        };
    }

    public static Iterable<IlvGraphic> getBreadthFirstIlvGraphicIterator(final IlvGraphic root) {
        return new Iterable<IlvGraphic>(){

            @Override
            public Iterator<IlvGraphic> iterator() {
                if (root == null) {
                    return IlvCollections.emptyIterator();
                }
                return new IlvGraphicIterator(root);
            }
        };
    }

    public static final boolean containsNode(IlvGrapher thisGrapher, IlvGraphic graphic, boolean traverse) {
        if (thisGrapher == null || graphic == null) {
            return false;
        }
        Iterable<IlvGraphicBag> bagIterable = CoreGraphicUtils.getBreadthFirstGraphicBagIterator((IlvGraphicBag)thisGrapher);
        for (IlvGraphicBag bag : bagIterable) {
            if (!(bag instanceof IlvGrapher)) continue;
            IlvGrapher grapher = (IlvGrapher)bag;
            IlvGraphicEnumeration ge = bag.getObjects();
            while (ge.hasMoreElements()) {
                IlvGraphic g = ge.nextElement();
                if (g != graphic || !grapher.isNode(g)) continue;
                return true;
            }
            if (traverse) continue;
            break;
        }
        return false;
    }

    public static Iterable<IlvGraphicBag> getReverseGraphicBagIterator(final IlvGraphicBag root) {
        return new Iterable<IlvGraphicBag>(){

            @Override
            public Iterator<IlvGraphicBag> iterator() {
                if (root != null) {
                    return new ReverseGraphicBagIterator(root);
                }
                return IlvCollections.emptyIterator();
            }
        };
    }

    public static void addNode(IlvGrapher grapher, IlvGraphic node, boolean redraw) {
        if (grapher == null) {
            throw new IllegalArgumentException("Argument grapher must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument node must not be null");
        }
        if (grapher instanceof IMultipresentationContainer) {
            IMultipresentationContainer mg = (IMultipresentationContainer)grapher;
            IlvGraphic currentPresentation = mg.getCurrentPresentation();
            if (!(currentPresentation instanceof IlvGrapher)) {
                String msg = "Cannot add a node because current presentation is not an IlvGrapher: " + mg.getClass().getName() + ",  " + mg.getCurrentPresentationTag();
                throw new RuntimeException(msg);
            }
            ((IlvGrapher)currentPresentation).addNode(node, redraw);
        } else {
            grapher.addNode(node, redraw);
        }
    }

    public static void addObject(IlvManager manager, IlvGraphic object, boolean redraw) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument manager must not be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument object must not be null");
        }
        if (manager instanceof IMultipresentationContainer) {
            IMultipresentationContainer mg = (IMultipresentationContainer)manager;
            IlvGraphic currentPresentation = mg.getCurrentPresentation();
            if (!(currentPresentation instanceof IlvManager)) {
                String msg = "Cannot add an object because current presentation is not an IlvManager: " + mg.getClass().getName() + ",  " + mg.getCurrentPresentationTag();
                throw new RuntimeException(msg);
            }
            ((IlvManager)currentPresentation).addObject(object, redraw);
        } else {
            manager.addObject(object, redraw);
        }
    }

    public static IlvPoint toLocalPoint(Point screenPoint, IlvGraphic graphic, IlvManagerView view) {
        IlvTransformer transformer;
        if (screenPoint == null) {
            throw new IllegalArgumentException("Argument screenPoint must not be null");
        }
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvManager owningManager = ManagerUtil.getManager(graphic);
        if (owningManager != null && owningManager.isCollapsed()) {
            return null;
        }
        IlvTransformer ilvTransformer = transformer = owningManager != null ? owningManager.getDrawingTransformer(view) : view.getTransformer();
        assert (transformer != null);
        if (transformer.isBad()) {
            assert (DebugUtils.warning((String)"Transformation is not inversible"));
            return null;
        }
        if (owningManager != null) {
            DebugUtils.trace((Object[])new Object[]{owningManager.boundingBox(), owningManager.boundingBox(transformer)});
        }
        IlvPoint p = new IlvPoint((float)screenPoint.x, (float)screenPoint.y);
        transformer.inverse(p);
        return p;
    }

    public static IlvPoint toNormalizedLocalPoint(Point screenPoint, IlvGraphic graphic, IlvManagerView view) {
        if (screenPoint == null) {
            throw new IllegalArgumentException("Argument screenPoint must not be null");
        }
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvPoint localPoint = CoreGraphicUtils.toLocalPoint(screenPoint, graphic, view);
        if (localPoint == null) {
            return null;
        }
        IlvManager owningManager = ManagerUtil.getManager(graphic);
        if (owningManager != null && owningManager.isCollapsed()) {
            return null;
        }
        if (graphic == view.getManager()) {
            owningManager = view.getManager();
        }
        IlvRect bounds = owningManager.boundingBox();
        assert (bounds != null);
        if (bounds.isEmpty()) {
            assert (DebugUtils.warning((String)("Cannot normalize because bounds are empty: " + bounds)));
            return null;
        }
        IlvPoint p = new IlvPoint();
        p.setLocation(localPoint.getX() / bounds.getWidth(), localPoint.getY() / bounds.getHeight());
        return p;
    }

    public static Point toScreenPointFromNormalizedLocalPoint(IlvPoint normalizedLocalPoint, IlvGraphic graphic, IlvManagerView view) {
        if (normalizedLocalPoint == null) {
            throw new IllegalArgumentException("Argument localPoint must not be null");
        }
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        if (Math.abs(normalizedLocalPoint.getX()) < 0.0 || Math.abs(normalizedLocalPoint.getX()) > 1.0 || Math.abs(normalizedLocalPoint.getY()) < 0.0 || Math.abs(normalizedLocalPoint.getY()) > 1.0) {
            throw new IllegalArgumentException("Argument normalizedLocalPoint does not represent a normalized point: " + normalizedLocalPoint);
        }
        IlvManager owningManager = ManagerUtil.getManager(graphic);
        if (owningManager != null && owningManager.isCollapsed()) {
            return null;
        }
        if (graphic == view.getManager()) {
            owningManager = view.getManager();
        }
        IlvRect bounds = owningManager.boundingBox();
        assert (bounds != null);
        IlvPoint localPoint = new IlvPoint();
        localPoint.setLocation(CoreGraphicUtils.round(normalizedLocalPoint.getX() * bounds.getWidth(), 3), CoreGraphicUtils.round(normalizedLocalPoint.getY() * bounds.getHeight(), 3));
        Point screenPoint = CoreGraphicUtils.toScreenPoint(localPoint, graphic, view);
        return screenPoint;
    }

    public static Point toScreenPoint(IlvPoint localPoint, IlvGraphic graphic, IlvManagerView view) {
        IlvTransformer transformer;
        if (localPoint == null) {
            throw new IllegalArgumentException("Argument localPoint must not be null");
        }
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvManager owningManager = ManagerUtil.getManager(graphic);
        if (owningManager != null && owningManager.isCollapsed()) {
            return null;
        }
        IlvTransformer ilvTransformer = transformer = owningManager != null ? owningManager.getDrawingTransformer(view) : view.getTransformer();
        assert (transformer != null);
        IlvPoint p = new IlvPoint(localPoint);
        transformer.apply(p);
        Point screenPoint = new Point();
        screenPoint.setLocation(p.getX(), p.getY());
        return screenPoint;
    }

    private static double round(double num, int numberOfSignificantDigits) {
        return new BigDecimal(num).round(new MathContext(numberOfSignificantDigits, RoundingMode.HALF_EVEN)).doubleValue();
    }

    private static class ReverseGraphicBagIterator
    extends IlvBreadthFirstIterator<IlvGraphicBag> {
        private ReverseGraphicBagIterator(IlvGraphicBag root) {
            super((Object)root);
        }

        protected Iterator<IlvGraphicBag> getChildren(IlvGraphicBag parent) {
            assert (parent != null);
            IlvGraphicBag bag = parent.getGraphicBag();
            if (bag != null) {
                return IlvCollections.oneElementListIterator((Object)bag);
            }
            return IlvCollections.emptyIterator();
        }
    }

    private static class IlvGraphicIterator
    extends IlvBreadthFirstIterator<IlvGraphic> {
        private IlvGraphicIterator(IlvGraphic root) {
            super((Object)root);
        }

        protected Iterator<IlvGraphic> getChildren(IlvGraphic parent) {
            if (!(parent instanceof IlvGraphicBag)) {
                return IlvCollections.emptyIterator();
            }
            final IlvGraphicEnumeration ge = ((IlvGraphicBag)parent).getObjects();
            if (ge == null) {
                return IlvCollections.emptyIterator();
            }
            Iterator<IlvGraphic> iterator = new Iterator<IlvGraphic>(){

                @Override
                public boolean hasNext() {
                    return ge.hasMoreElements();
                }

                @Override
                public IlvGraphic next() {
                    return ge.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove() is not supported in this iterator");
                }
            };
            return iterator;
        }
    }

    private static class DFSPreorderIlvGraphicIterator
    extends IlvPreorderIterator<IlvGraphic> {
        private final boolean excludeInvisibleGraphic;

        private DFSPreorderIlvGraphicIterator(IlvGraphic root, boolean excludeInvisibleGraphic) {
            super((Object)root);
            this.excludeInvisibleGraphic = excludeInvisibleGraphic;
        }

        protected Iterator<IlvGraphic> getChildren(IlvGraphic parent) {
            assert (parent != null);
            if (!(parent instanceof IlvGraphicBag)) {
                return IlvCollections.emptyIterator();
            }
            IlvGraphicBag bag = (IlvGraphicBag)parent;
            IlvGraphicEnumeration ge = bag.getObjects();
            if (ge == null) {
                return IlvCollections.emptyIterator();
            }
            ArrayList<IlvGraphic> list = new ArrayList<IlvGraphic>();
            while (ge.hasMoreElements()) {
                IlvGraphic graphic = ge.nextElement();
                boolean exclude = this.excludeInvisibleGraphic && graphic != null && !graphic.isVisible();
                if (exclude) continue;
                list.add(graphic);
            }
            return list.iterator();
        }
    }

    private static class DFSPreorderGraphicBagIterator
    extends IlvPreorderIterator<IlvGraphicBag> {
        private DFSPreorderGraphicBagIterator(IlvGraphicBag root) {
            super((Object)root);
        }

        protected Iterator<IlvGraphicBag> getChildren(IlvGraphicBag parent) {
            assert (parent != null);
            IlvGraphicEnumeration ge = parent.getObjects();
            if (ge == null) {
                return IlvCollections.emptyIterator();
            }
            ArrayList<IlvGraphicBag> list = new ArrayList<IlvGraphicBag>();
            while (ge.hasMoreElements()) {
                IlvGraphic graphic = ge.nextElement();
                if (!(graphic instanceof IlvGraphicBag)) continue;
                list.add((IlvGraphicBag)graphic);
            }
            return list.iterator();
        }
    }

    private static class GraphicBagIterator
    extends IlvBreadthFirstIterator<IlvGraphicBag> {
        private GraphicBagIterator(IlvGraphicBag root) {
            super((Object)root);
        }

        protected Iterator<IlvGraphicBag> getChildren(IlvGraphicBag parent) {
            assert (parent != null);
            IlvGraphicEnumeration ge = parent.getObjects();
            if (ge == null) {
                return IlvCollections.emptyIterator();
            }
            ArrayList<IlvGraphicBag> list = new ArrayList<IlvGraphicBag>();
            while (ge.hasMoreElements()) {
                IlvGraphic graphic = ge.nextElement();
                if (!(graphic instanceof IlvGraphicBag)) continue;
                list.add((IlvGraphicBag)graphic);
            }
            return list.iterator();
        }
    }
}

