/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.manager;

import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import oracle.diagram.core.manager.CoreManagerLayer;
import oracle.diagram.core.manager.ThumbnailViewLayerVisibilityFilter;
import oracle.diagram.core.thumbnail.ThumbnailManagerViewMarker;
import oracle.ide.thumbnail.ThumbnailConstants;

public class CoreManager
extends IlvManager {
    private int _backgroundLayer;
    private static IlvLayerVisibilityFilter THUMBNAIL_FILTER = new ThumbnailViewLayerVisibilityFilter();

    public CoreManager() {
        this.init();
    }

    public CoreManager(IlvInputStream stream) throws IOException, IlvReadFileException {
        super(stream);
        this.init();
    }

    public CoreManager(IlvManager origin) {
        super(origin);
        this.init();
    }

    public CoreManager(int numberOfLayers) {
        super(numberOfLayers);
        this.init();
    }

    public CoreManager(int numberOfLayers, int maxInList) {
        super(numberOfLayers, maxInList);
        this.init();
    }

    public void draw(Graphics graphics, IlvManagerView view) {
        if (view instanceof ThumbnailManagerViewMarker && graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT, Boolean.TRUE);
            super.draw(graphics, view);
        } else {
            super.draw(graphics, view);
        }
    }

    private void init() {
        this._backgroundLayer = -1;
        this.getManagerLayer(this.getLayersCount()).addVisibilityFilter(THUMBNAIL_FILTER);
    }

    public int getBackgroundGraphicsLayer() {
        return this._backgroundLayer;
    }

    public void enableBackgroundGraphicsLayer(boolean enable) {
        if (enable) {
            if (this._backgroundLayer == -1) {
                this._backgroundLayer = 0;
                this.addLayer(this._backgroundLayer);
                int insertionLayer = this.getInsertionLayer();
                if (insertionLayer == this._backgroundLayer) {
                    this.setInsertionLayer(this._backgroundLayer + 1);
                }
            }
        } else if (this._backgroundLayer != -1) {
            int insertionLayer = this.getInsertionLayer();
            this.removeLayer(this._backgroundLayer, true);
            if (this.getInsertionLayer() == insertionLayer && insertionLayer > this._backgroundLayer) {
                this.setInsertionLayer(insertionLayer - 1);
            }
            this._backgroundLayer = -1;
        }
    }

    protected IlvManagerLayer createManagerLayer(int i) {
        CoreManagerLayer layer = new CoreManagerLayer(30, i);
        return layer;
    }
}

