/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.context;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewDecoration;
import java.awt.Graphics;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.plugin.PluginManager;
import oracle.ide.Context;
import oracle.ide.view.View;

public class DiagramContext
extends PluginManager {
    private IlvManagerView _view = null;

    public static DiagramContext getDiagramContext(IlvManagerView view) {
        if (view != null) {
            int size = view.getViewDecorationCount();
            for (int i = 0; i < size; ++i) {
                IlvManagerViewDecoration vd = view.getViewDecoration(i);
                if (!(vd instanceof DiagramContextViewDecoration)) continue;
                return ((DiagramContextViewDecoration)vd).getDiagramContext();
            }
        }
        return null;
    }

    public static DiagramContext getDiagramContext(Context context) {
        View view = context.getView();
        if (view instanceof DiagramView) {
            return DiagramContext.getDiagramContext(((DiagramView)view).getActiveManagerView());
        }
        return null;
    }

    public DiagramContext(Object host) {
        super(host);
    }

    public final IlvManagerView getManagerView() {
        return this._view;
    }

    public final void setManagerView(IlvManagerView view) {
        if (view != null && (DiagramContext.getDiagramContext(view) != null || this.getManagerView() != null)) {
            throw new IllegalStateException("DiagramContext is already bound to a view");
        }
        if (view != null) {
            view.addViewDecoration((IlvManagerViewDecoration)new DiagramContextViewDecoration(this));
        } else {
            IlvManagerView oldView = this.getManagerView();
            if (oldView != null) {
                int size = oldView.getViewDecorationCount();
                for (int i = 0; i < size; ++i) {
                    IlvManagerViewDecoration vd = oldView.getViewDecoration(i);
                    if (!(vd instanceof DiagramContextViewDecoration)) continue;
                    oldView.removeViewDecoration(vd);
                    break;
                }
            }
        }
        this._view = view;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setManagerView(null);
    }

    private static final class DiagramContextViewDecoration
    implements IlvManagerViewDecoration {
        private final DiagramContext _context;

        public DiagramContextViewDecoration(DiagramContext context) {
            this._context = context;
        }

        public DiagramContext getDiagramContext() {
            return this._context;
        }

        public void paint(Graphics graphics, IlvManagerView ilvManagerView) {
        }
    }
}

