/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.topicDisplay.TopicDisplay;

public class DocumentStack {
    private int _currentPosition;
    private ArrayList _stack = new ArrayList();
    private TopicDisplay _topicDisplay;

    public DocumentStack(TopicDisplay topicDisplay) {
        this._topicDisplay = topicDisplay;
        this._currentPosition = 0;
    }

    public synchronized void clearStack() {
        this._stack.clear();
        this._currentPosition = 0;
    }

    private synchronized void _setURL(URL url) {
        try {
            SimpleURLTarget aTarget = new SimpleURLTarget(null, url.toString());
            SimpleTopic aTopic = new SimpleTopic(null, (Target)aTarget, null);
            this._topicDisplay.displayTopic((Topic)aTopic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addElement(URL url) {
        if (url != null && !url.equals(this.getURL())) {
            if (this._currentPosition < this._stack.size()) {
                this._stack.ensureCapacity(this._currentPosition);
            }
            this._stack.add(url);
            ++this._currentPosition;
        }
    }

    public synchronized boolean canGoBack() {
        return this._currentPosition > 1;
    }

    public synchronized void goBack() {
        if (this.canGoBack()) {
            --this._currentPosition;
            URL url = (URL)this._stack.get(this._currentPosition - 1);
            this._setURL(url);
        }
    }

    public synchronized boolean canGoForward() {
        return this._stack.size() > this._currentPosition;
    }

    public synchronized void goForward() {
        if (this.canGoForward()) {
            ++this._currentPosition;
            URL url = (URL)this._stack.get(this._currentPosition - 1);
            this._setURL(url);
        }
    }

    public synchronized URL getURL() {
        URL url = null;
        if (this._stack.size() > 0) {
            url = (URL)this._stack.get(this._currentPosition - 1);
        }
        return url;
    }
}

