/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.dTree.DTreeDeferredChild;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.util.ImageLoader;

public class TOCLeafItem
extends DTreeDeferredChild
implements TopicTreeItem {
    private ImageIcon _leafIcon = null;
    private static ImageIcon _defaultLeafIcon = null;

    @Override
    public Topic getTopic() {
        Topic aTopic = null;
        TopicTreeNode node = this.getTopicTreeNode();
        if (node != null) {
            aTopic = node.getTopic();
        }
        return aTopic;
    }

    @Override
    public TopicTreeNode getTopicTreeNode() {
        TopicTreeNode node = null;
        DTreeDeferringParent parent = this.getDeferringParent();
        if (parent != null) {
            node = (TopicTreeNode)parent.getChildData(this.getIndex());
        }
        return node;
    }

    public String getLabel() {
        String label = null;
        Topic aTopic = this.getTopic();
        if (aTopic != null) {
            label = aTopic.getLabel();
        }
        return label;
    }

    public Icon getIcon() {
        if (this._leafIcon == null) {
            Image leafImage = ImageLoader.loadImage(this.getTopic().getDefaultIcon());
            if (leafImage == null) {
                Image defaultLeafImage;
                if (_defaultLeafIcon == null && (defaultLeafImage = ImageLoader.loadImage(this.getClass(), "images/file.gif")) != null) {
                    _defaultLeafIcon = new ImageIcon(defaultLeafImage);
                }
                this._leafIcon = _defaultLeafIcon;
            } else {
                this._leafIcon = new ImageIcon(leafImage);
            }
        }
        return this._leafIcon;
    }

    public void processMouseEvent(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            TopicTreeComponent tree = (TopicTreeComponent)this.getTree();
            Point location = new Point(this.getX() + evt.getX(), this.getY() + evt.getY());
            tree.firePopupRequested(new TopicTreeEvent(this, 2002), location);
        } else {
            super.processMouseEvent(evt);
        }
    }
}

