/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.searchNavigator;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.List;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.share.sort.Comparator;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.QueryResult;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.searchNavigator.ResultsBookComparator;
import oracle.help.navigator.searchNavigator.ResultsRankComparator;
import oracle.help.navigator.searchNavigator.ResultsTitleComparator;

public class OHJSearchModelData
extends SortableTwoDModel
implements HeaderItemInputHandler,
SearchModelData {
    private final int _INCREMENT = 10;
    private Object[] _buffer = new Object[10];
    private int _lastColumnClicked = -1;
    private boolean _invertSort = false;
    private static Image _fullImage;
    private static Image _halfImage;
    private static Image _emptyImage;
    private int _maxHitNumber = 1;

    public OHJSearchModelData() {
        super(3, 0);
        this.setColumnComparator(0, new ResultsRankComparator());
        this.setColumnComparator(1, (Comparator)new ResultsTitleComparator());
        this.setColumnComparator(2, (Comparator)new ResultsBookComparator());
        _fullImage = ImageLoader.loadImage(((Object)((Object)this)).getClass(), "images/full.gif");
        _halfImage = ImageLoader.loadImage(((Object)((Object)this)).getClass(), "images/half.gif");
        _emptyImage = ImageLoader.loadImage(((Object)((Object)this)).getClass(), "images/empty.gif");
    }

    public Object getData(int column, int row) {
        return SearchModel.getData((Object)super.getData(column, row), (int)column, (int)row, (SearchModelData)this);
    }

    public Object getRealData(int column, int row) {
        return super.getData(column, row);
    }

    public void resetModel() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            this.removeRows(0, rowCount);
        }
        this._maxHitNumber = 1;
    }

    public Object getRank(QueryResult item) {
        int realScore = (int)(100.0f * ((float)item.getResultScore() / (float)this._maxHitNumber));
        if (realScore > 80) {
            return _fullImage;
        }
        if (realScore > 40) {
            return _halfImage;
        }
        return _emptyImage;
    }

    public void addResults(List someResults, View source) {
        QueryResult result;
        int i;
        int row;
        int count = 0;
        for (QueryResult item : someResults) {
            this._buffer[count++] = item;
            if (count != 10) continue;
            row = this.getRowCount();
            this.addRows(this.getRowCount(), count);
            for (i = 0; i < count; ++i) {
                result = (QueryResult)this._buffer[i];
                if (result.getResultScore() > this._maxHitNumber) {
                    this._maxHitNumber = result.getResultScore();
                }
                this.setData(0, row + i, result);
                this.setData(1, row + i, result);
                this.setData(2, row + i, source);
            }
            count = 0;
        }
        if (count != 0) {
            row = this.getRowCount();
            this.addRows(this.getRowCount(), count);
            for (i = 0; i < count; ++i) {
                result = (QueryResult)this._buffer[i];
                if (result.getResultScore() > this._maxHitNumber) {
                    this._maxHitNumber = result.getResultScore();
                }
                this.setData(0, row + i, result);
                this.setData(1, row + i, result);
                this.setData(2, row + i, source);
            }
        }
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
        this._invertSort = itemIndex == this._lastColumnClicked ? !this._invertSort : false;
        this._lastColumnClicked = itemIndex;
        this.sort(itemIndex, !this._invertSort);
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
    }

    protected void fireModelEvent(int eventID, int startIndex, int count) {
        try {
            super.fireModelEvent(eventID, startIndex, count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void fireModelEvent(int eventID, int startColumn, int columnCount, int startRow, int rowCount) {
        try {
            super.fireModelEvent(eventID, startColumn, columnCount, startRow, rowCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

