/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.event.ListenerManager;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;

public class NavigatorTabPanel
extends JTabbedPane
implements NavigatorListener,
ChangeListener {
    private ListenerManager _listeners = new ListenerManager();
    private Navigator _activeNavigator = null;
    private ArrayList _navigators = new ArrayList();

    public NavigatorTabPanel() {
        this.addChangeListener(this);
    }

    public synchronized void addNavigator(Navigator n) {
        if (n != null) {
            String label = n.getLabel();
            Image labelImage = n.getLabelImage();
            if (label == null) {
                label = n.getDefaultLabel();
            } else if (label.length() == 0) {
                label = n.getDefaultLabel();
            }
            n.addNavigatorListener(this);
            if (labelImage != null) {
                ImageIcon labelIcon = new ImageIcon(labelImage);
                this.addTab(label, labelIcon, n);
            } else {
                this.addTab(label, n);
            }
        } else {
            throw new IllegalArgumentException("Null parameter passed to addNavigator");
        }
        this._navigators.add(n);
    }

    public synchronized void removeNavigator(Navigator n) {
        int numPages = this.getTabCount();
        if (n != null) {
            for (int iter = numPages - 1; iter >= 0; --iter) {
                Component pageContent = this.getComponentAt(iter);
                if (pageContent != n) continue;
                n.removeNavigatorListener(this);
                this.removeTabAt(iter);
            }
            this._navigators.remove(n);
        }
    }

    public synchronized Navigator[] getNavigators() {
        Navigator[] navs = null;
        if (this._navigators.size() > 0) {
            navs = new Navigator[this._navigators.size()];
            this._navigators.toArray(navs);
        }
        return navs;
    }

    @Override
    public void topicSelected(NavigatorEvent e) {
        if (e != null && e.getSource() == this._activeNavigator) {
            this._fireNavigatorEvent(e);
        }
    }

    @Override
    public void topicActivated(NavigatorEvent e) {
        if (e != null && e.getSource() == this._activeNavigator) {
            this._fireNavigatorEvent(e);
        }
    }

    public void addActiveNavigatorListener(NavigatorListener listener) {
        if (listener != null) {
            this._listeners.addListener((EventListener)listener);
        }
    }

    public void removeActiveNavigatorListener(NavigatorListener listener) {
        if (listener != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    public Navigator getActiveNavigator() {
        return this._activeNavigator;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event != null) {
            Component pageContent = this.getSelectedComponent();
            try {
                this._activeNavigator = (Navigator)pageContent;
            }
            catch (Exception e) {
                this._activeNavigator = null;
            }
            if (this._activeNavigator != null) {
                this._fireNavigatorEvent(new NavigatorEvent(this._activeNavigator, 2000, this._activeNavigator.getCurrentSelection()));
            } else {
                this._fireNavigatorEvent(new NavigatorEvent(this, 2000, null));
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        this._initializeNavigators();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this._initializeNavigators();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this._initializeNavigators();
    }

    private void _initializeNavigators() {
        for (Navigator nav : this._navigators) {
            LazyNavigator lazyNav;
            if (!(nav instanceof LazyNavigator) || (lazyNav = (LazyNavigator)nav).isInitialized()) continue;
            lazyNav.initializeLazyNavigator();
        }
    }

    private void _fireNavigatorEvent(NavigatorEvent event) {
        Enumeration listenEnum = this._listeners.getListeners();
        if (listenEnum != null) {
            while (listenEnum.hasMoreElements()) {
                NavigatorListener l = (NavigatorListener)listenEnum.nextElement();
                if (event.getID() == 2000) {
                    l.topicSelected(event);
                    continue;
                }
                l.topicActivated(event);
            }
        }
    }
}

