/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.FindSupport;
import oracle.help.java.util.MnemonicUtils;

public class FindDialog
extends JDialog
implements ActionListener {
    private FindSupport _findSupport;
    private JLabel _findWhat;
    private JTextField _textField;
    private JCheckBox _caseSensitive;
    private JButton _findNext;
    private JButton _close;
    private String _prevSearch = "";
    private static final String MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";
    private static final String FIND = "find.title";
    private static final String FIND_WHAT = "find.prompt";
    private static final String FIND_FINISHED = "find.finished";
    private static final String CASE_SENSITIVE = "find.case";
    private static final String FIND_NEXT = "find.next";
    private static final String CLOSE = "find.close";
    private static final String _KEY_CLOSE = "CLOSE";

    public static FindDialog createFindDialog(Component component, FindSupport findSupport) {
        Window parentWindow = WindowUtils.getWindow((Component)component);
        if (parentWindow instanceof Dialog) {
            return new FindDialog((Dialog)parentWindow, findSupport);
        }
        if (parentWindow instanceof Frame) {
            return new FindDialog((Frame)parentWindow, findSupport);
        }
        return new FindDialog(WindowUtils.parentFrame((Component)component), findSupport);
    }

    public FindDialog(Frame frame, FindSupport findSupport) {
        super(frame, true);
        this._init(frame, findSupport);
    }

    public FindDialog(Dialog dialog, FindSupport findSupport) {
        super(dialog, true);
        this._init(dialog, findSupport);
    }

    private void _init(Window window, FindSupport findSupport) {
        ResourceBundle bundle = ResourceBundle.getBundle(MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setTitle(StringUtils.stripMnemonic((String)bundle.getString(FIND)));
        this._findSupport = findSupport;
        this._textField = new JTextField(20);
        this._textField.addActionListener(this);
        this._findWhat = MnemonicUtils.createLabel(bundle.getString(FIND_WHAT), this._textField);
        this._caseSensitive = MnemonicUtils.createCheckBox(bundle.getString(CASE_SENSITIVE));
        this._findNext = MnemonicUtils.createButton(bundle.getString(FIND_NEXT));
        this._findNext.addActionListener(this);
        this._close = MnemonicUtils.createButton(bundle.getString(CLOSE));
        this._close.addActionListener(this);
        JPanel findWhatPanel = new JPanel(new FlowLayout());
        findWhatPanel.add(this._findWhat);
        findWhatPanel.add(this._textField);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)findWhatPanel, "North");
        leftPanel.add((Component)this._caseSensitive, "South");
        leftPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this._findNext, "North");
        rightPanel.add((Component)this._close, "South");
        rightPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)leftPanel, "West");
        this.getContentPane().add((Component)rightPanel, "East");
        this.addWindowListener(WindowUtils.getWindowCloser());
        JRootPane rootPane = this.getRootPane();
        rootPane.registerKeyboardAction(this, _KEY_CLOSE, KeyStroke.getKeyStroke(27, 0), 1);
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)window);
        this.setVisible(true);
        this._textField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._close || _KEY_CLOSE.equals(e.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        } else if ((src == this._findNext || src == this._textField) && this._findSupport != null) {
            this._findSupport.setCaseSensitive(this._caseSensitive.isSelected());
            if (!this._textField.getText().equals(this._prevSearch)) {
                this._prevSearch = this._textField.getText();
                this._findSupport.setSearchString(this._prevSearch);
            }
            if (!this._findSupport.findNext()) {
                ResourceBundle bundle = ResourceBundle.getBundle(MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
                JOptionPane.showMessageDialog(this, bundle.getString(FIND_FINISHED), bundle.getString(FIND), 2);
            }
        }
    }
}

