/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.ide.db.components.ComponentWrapper;
import oracle.javatools.db.validators.ValidationException;

class DBValidationComponent
extends AbstractValidationComponent {
    private static final String CLIENT_PROP_KEY = "DBValidationComponent";
    private final ComponentWrapper m_wrapper;
    private final Collection<ValidationException> m_validationExceptions = new ArrayList<ValidationException>();

    private DBValidationComponent(Component c, ComponentWrapper wrapper) {
        super(c);
        this.m_wrapper = wrapper;
    }

    public Object getData() {
        return this.m_wrapper == null ? null : this.m_wrapper.getPropertyValue();
    }

    public Collection<ValidationException> getValidationExceptions() {
        return Collections.unmodifiableCollection(this.m_validationExceptions);
    }

    public void addValidationException(ValidationException ve) {
        this.m_validationExceptions.add(ve);
        this.getValidationMessageModel().addValidationMessage(new ValidationMessage(1, ve.getMessage()));
    }

    public void clearValidation() {
        this.m_validationExceptions.clear();
        this.getValidationMessageModel().clear();
        this.getValidationPainter().paintComponent((ValidationComponent)this);
    }

    public static DBValidationComponent findOrCreateValidationComponent(JComponent c, ComponentWrapper wrap) {
        DBValidationComponent dbvc = (DBValidationComponent)((Object)c.getClientProperty(CLIENT_PROP_KEY));
        if (dbvc == null) {
            dbvc = new DBValidationComponent(c, wrap);
            c.putClientProperty(CLIENT_PROP_KEY, (Object)dbvc);
        }
        return dbvc;
    }
}

