/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.beans.PropertyChangeEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.Property;

public class OracleTablespacePropertiesPanel
extends ChildObjectEditorPanel<OracleTablespaceProperties, Tablespace> {
    public OracleTablespacePropertiesPanel() {
        super("OracleTablespacePropertiesPanel", null, true);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"TablespaceType", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"}), Property.createPath((String[])new String[]{"OracleTablespaceProperties", "extentManagementType"})}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                String autoAlloc = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"});
                String extMgmnt = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "extentManagementType"});
                if ("TablespaceType".equals(propertyName)) {
                    OracleTablespacePropertiesPanel.this.getComponentFactory().forceProcessComponents();
                    OracleTablespacePropertiesPanel.this.initialiseComponentValues();
                    OracleTablespacePropertiesPanel.this.repaint();
                } else if (extMgmnt.equals(propertyName)) {
                    OracleTablespaceProperties otp;
                    Object newValue = pce.getNewValue();
                    if (OracleTablespaceProperties.ExtentManagementType.LOCAL.equals(newValue) && (otp = (OracleTablespaceProperties)obj.getProperty("OracleTablespaceProperties")) != null) {
                        otp.setProperty("OracleStorageProperties", null);
                    }
                    OracleTablespacePropertiesPanel.this.getComponentFactory().processComponents();
                    OracleTablespacePropertiesPanel.this.handleExtentManagementUpdate(newValue);
                } else if (autoAlloc.equals(propertyName)) {
                    OracleTablespacePropertiesPanel.this.handleAutoAllocateUpdate(pce.getNewValue());
                }
            }
        };
    }

    @Override
    protected void initialiseChildComponents() {
        ComponentWrapper cwTbspGroup = this.getOrCreateWrapper("tablespaceGroup");
        ComponentWrapper cwRetention = this.getOrCreateWrapper("retention");
        ComponentWrapper cwBlocksize = this.getOrCreateWrapper("blockSize");
        ComponentWrapper cwLogging = this.getOrCreateWrapper("logging");
        ComponentWrapper cwForcelogging = this.getOrCreateWrapper("forceLogging");
        ComponentWrapper cwOnline = this.getOrCreateWrapper("onlineStatus");
        ComponentWrapper cwSegMgmnt = this.getOrCreateWrapper("segmentManagement");
        ComponentWrapper cwExtentMgmnt = this.getOrCreateWrapper("extentManagementType");
        ComponentWrapper cwAutoAllocate = this.getOrCreateWrapper("autoAllocate");
        ComponentWrapper cwUniformSize = this.getOrCreateWrapper("uniformSize");
        DBUILayoutHelper topLayout = this.getDBUILayoutHelper();
        topLayout.add(cwOnline);
        topLayout.nextRow();
        topLayout.add(cwTbspGroup);
        topLayout.nextRow();
        topLayout.add(cwRetention);
        topLayout.nextRow();
        topLayout.add(cwBlocksize);
        topLayout.nextRow();
        topLayout.add(cwLogging);
        topLayout.add(cwForcelogging);
        topLayout.nextRow();
        topLayout.add(cwSegMgmnt);
        topLayout.nextRowWithGap();
        topLayout.add(cwExtentMgmnt);
        topLayout.nextRow();
        topLayout.add(cwAutoAllocate);
        topLayout.nextRow();
        topLayout.add(cwUniformSize);
        topLayout.pushUp();
        topLayout.layout();
    }

    @Override
    public void initialisePanel() {
        super.initialisePanel();
        this.initialiseComponentValues();
    }

    private void handleExtentManagementUpdate(Object newValue) {
        ComponentWrapper cwAutoAllocate = this.getOrCreateWrapper("autoAllocate");
        if (newValue == OracleTablespaceProperties.ExtentManagementType.LOCAL) {
            this.enableUniformSize((Boolean)cwAutoAllocate.getPropertyValue() == false);
        } else {
            this.enableUniformSize(false);
        }
    }

    private void handleAutoAllocateUpdate(Object newValue) {
        if (newValue != null && newValue instanceof Boolean) {
            this.enableUniformSize((Boolean)newValue == false);
        }
    }

    private void enableUniformSize(boolean enable) {
        ComponentWrapper cwUniformSize = this.getOrCreateWrapper("uniformSize");
        if (!enable) {
            cwUniformSize.resetPropertyValue(null);
        }
        cwUniformSize.setEnabled(enable);
    }

    private void initialiseComponentValues() {
        ComponentWrapper cwExtentMgmnt = this.getOrCreateWrapper("extentManagementType");
        OracleTablespaceProperties otp = (OracleTablespaceProperties)this.getChildObject();
        if (otp != null) {
            this.handleAutoAllocateUpdate(otp.isAutoAllocate());
            this.handleExtentManagementUpdate(otp.getExtentManagementType());
        } else {
            this.handleAutoAllocateUpdate(false);
            this.handleExtentManagementUpdate(null);
        }
        cwExtentMgmnt.setEnabled(this.isInFlatEditor() ? true : this.getOriginalObject() == null);
    }
}

