/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class TableInMemoryPanel
extends BaseEditorPanel<Table> {
    public TableInMemoryPanel() {
        super("TableInMemoryPanel");
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add(this.getOrCreateWrapper("OracleInMemoryProperties").getComponent(), 1, 1, true, false);
        layout.nextRowWithGap();
        ComponentWrapper<BaseEditorPanel> imcpWrap = new InMemoryColumnPropertiesPanel().createPanelWrapper();
        imcpWrap.initialise(this.createComponentContext(this.getComponentPath("OracleInMemoryColumnProperties")));
        this.getComponentFactory().registerComponentWrapper(imcpWrap);
        layout.add(imcpWrap.getComponent(), 1, 1, true, true);
        layout.layout();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"OracleInMemoryProperties", Property.createPath((String[])new String[]{"OracleInMemoryProperties", "inMemory"})}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                TableInMemoryPanel.this.checkComponents();
            }
        };
    }

    @Override
    protected void initialisePanel() {
        this.checkComponents();
    }

    private void checkComponents() {
        boolean colsEnabled;
        Table tab = (Table)this.getUpdatedObject();
        OracleInMemoryProperties imp = (OracleInMemoryProperties)tab.getProperty("OracleInMemoryProperties");
        if (imp == null) {
            OracleTablePartitions otp;
            boolean hasPimp = false;
            if (this.getOriginalObject() != null && Boolean.TRUE.equals(tab.getProperty("PARTITIONED TABLE")) && (otp = (OracleTablePartitions)tab.getProperty("OracleTablePartitions")) != null) {
                for (TablePartition tp : DBUtil.findChildren((DBObject)otp, TablePartition.class)) {
                    OracleInMemoryProperties pimp = (OracleInMemoryProperties)tp.getProperty("OracleInMemoryProperties");
                    if (pimp == null || !pimp.isInMemory()) continue;
                    hasPimp = true;
                    break;
                }
            }
            colsEnabled = hasPimp;
        } else {
            colsEnabled = imp.isInMemory();
        }
        ComponentWrapper wrap = this.getOrCreateWrapper("OracleInMemoryColumnProperties");
        if (!colsEnabled) {
            wrap.resetPropertyValue(null);
        }
        wrap.setEnabled(colsEnabled);
    }

    private class InMemoryColumnPropertiesEditorPanel
    extends ChildObjectEditorPanel<OracleInMemoryColumnProperties, Table> {
        public InMemoryColumnPropertiesEditorPanel() {
            super("InMemoryColumnPropertiesEditorPanel", "OracleInMemoryColumnProperties");
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper layout = this.getDBUILayoutHelper();
            ComponentWrapper colsWrap = this.getOrCreateWrapper("columnIDs");
            layout.add(colsWrap.getLabel(), 2, 1);
            layout.nextRow();
            Component shuttle = colsWrap.getComponent();
            if (this.isInFlatEditor()) {
                shuttle.setPreferredSize(new Dimension(200, 200));
            }
            layout.add(shuttle, 2, 1, true, true);
            layout.nextRow();
            ComponentWrapper imWrapper = this.getOrCreateWrapper("inMemory");
            layout.add(imWrapper);
            layout.nextRow();
            layout.add(this.getOrCreateWrapper("inMemoryCompression"));
            layout.layout();
            imWrapper.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    InMemoryColumnPropertiesEditorPanel.this.checkComponents();
                }
            });
        }

        @Override
        protected void initialisePanel() {
            super.initialisePanel();
            this.checkComponents();
        }

        private void checkComponents() {
            OracleInMemoryColumnProperties child = (OracleInMemoryColumnProperties)this.getChildObject();
            if (this.isEnabled() && child != null) {
                this.getOrCreateWrapper("inMemoryCompression").setEnabled(child.isInMemory());
            }
        }
    }

    private class InMemoryColumnPropertiesPanel
    extends ChildListEditorPanel<OracleInMemoryColumnProperties, Table> {
        public InMemoryColumnPropertiesPanel() {
            super("InMemoryColumnPropertiesPanel");
        }

        @Override
        protected String getListLabel() {
            return UIBundle.get("INMEM_COL_CLAUSES");
        }

        @Override
        protected ListButtons.Controller createButtonsHelper() {
            return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

                @Override
                public boolean canRemove(Object val) {
                    return val instanceof OracleInMemoryColumnProperties && (!(InMemoryColumnPropertiesPanel.this.getProvider() instanceof Database) || TemporaryObjectID.getOriginalObject((DBObject)((DBObject)val)) == null);
                }
            };
        }

        @Override
        protected ChildObjectEditorPanel<OracleInMemoryColumnProperties, Table> createChildPanel() {
            return new InMemoryColumnPropertiesEditorPanel();
        }

        @Override
        protected Class<OracleInMemoryColumnProperties> getChildClass() {
            return OracleInMemoryColumnProperties.class;
        }

        @Override
        protected String getChildProperty() {
            return "OracleInMemoryColumnProperties";
        }

        @Override
        protected ListCellRenderer createItemRenderer() {
            return new DBObjectRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel retval = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (!ModelUtil.hasLength((String)retval.getText())) {
                        retval.setText(UIBundle.get("LOB_PARAM_NO_COLUMNS"));
                    }
                    return retval;
                }
            };
        }
    }
}

