/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.ValuesPropertyPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.ui.TitledSeparator;

public class IndexEditorPanel
extends BaseEditorPanel<Index> {
    private DBObjectChooser m_tableSchema;
    private DBObjectChooser m_table;
    private TitledSeparator m_domainIndexSeparator;
    private final boolean m_isStandaloneIndexEditor;
    private final boolean m_isShowAdvancedButton;

    public IndexEditorPanel() {
        this(true, false);
    }

    public IndexEditorPanel(boolean isIndexEditor, boolean isShowAdvancedButton) {
        super("IndexEditorPanel");
        this.m_isStandaloneIndexEditor = isIndexEditor;
        this.m_isShowAdvancedButton = isShowAdvancedButton;
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper cwIndexType = this.getOrCreateWrapper("indexType");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        DBUIResourceHelper resHelp = this.getComponentFactory().getResourceHelper();
        DBUILayoutHelper topLayout = layout.newChildHelper(2, 1, true, false);
        if (this.m_isStandaloneIndexEditor) {
            this.m_tableSchema = new DBObjectChooser("SCHEMA");
            this.m_table = new DBObjectChooser(this.m_tableSchema, "TABLE", "MATERIALIZED VIEW");
            String tableStr = PropertyDisplayRegistry.getDisplayName("table", this.getProvider(), this.getUpdatedObject());
            JLabel schemaLabel = new JLabel();
            resHelp.resLabel(schemaLabel, this.m_tableSchema, UIBundle.format("LABEL_IDPROP_SCHEMA", tableStr), "m_tableSchema");
            topLayout.add(schemaLabel);
            topLayout.add(this.m_tableSchema);
            topLayout.nextRow();
            JLabel tableLabel = new JLabel();
            resHelp.resLabel(tableLabel, this.m_table, tableStr + ":", "m_table");
            topLayout.add(tableLabel);
            topLayout.add(this.m_table);
            topLayout.nextRow();
            this.m_tableSchema.setProvider(this.getProvider());
            this.m_table.setProvider(this.getProvider());
            if (!this.getEditorConfig().isCommitToProvider() || this.getOriginalObject() != null && ((Index)this.getOriginalObject()).getTable() != null) {
                this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable().getSchema());
                this.m_table.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable());
                this.m_tableSchema.setEnabled(false);
                this.m_table.setEnabled(false);
            } else {
                Index index = (Index)this.getUpdatedObject();
                if (index != null) {
                    Table t = index.getTable();
                    if (t != null) {
                        this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable().getSchema());
                        this.m_table.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable());
                    } else {
                        this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getSchema());
                        this.m_table.setDBObject(null);
                    }
                }
            }
            this.m_table.addChangeListener(new DBObjectChooser.ChangeListener(){

                @Override
                public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                    ((Index)IndexEditorPanel.this.getUpdatedObject()).setTable((Table)chooser.getDBObject());
                    ((Index)IndexEditorPanel.this.getUpdatedObject()).setColumnExpressions(new IndexObject[0]);
                    ComponentWrapper cwColExprs = IndexEditorPanel.this.getOrCreateWrapper("columnExpressions");
                    cwColExprs.setPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getColumnExpressions());
                    IndexEditorPanel.this.initialisePanel();
                }
            });
        }
        topLayout.add(cwIndexType);
        layout.nextRow();
        ComponentWrapper cwColExprs = this.getOrCreateWrapper("columnExpressions");
        layout.add(cwColExprs.getComponent(), 2, 1, true, true);
        layout.nextRow();
        String title = PropertyDisplayRegistry.getDisplayName("domainIndextype", this.getProvider(), this.getUpdatedObject());
        this.m_domainIndexSeparator = new TitledSeparator(title);
        layout.add((Component)this.m_domainIndexSeparator, 2, 1, true, false);
        ComponentWrapper cwDomainIndextype = this.getOrCreateWrapper("domainIndextype");
        ComponentWrapper cwDomainIndextypeParameters = this.getOrCreateWrapper("domainIndextypeParameters");
        layout.addChildren(cwDomainIndextype, new Integer[0]);
        layout.nextRow();
        layout.add(cwDomainIndextypeParameters);
        if (this.m_isShowAdvancedButton) {
            JButton button = new JButton();
            resHelp.resButton(button, UIBundle.get("INDEX_PANEL_LABEL_ADVANCED"), "indexAdvancedButton");
            button.addActionListener(e -> this.launchAdvancedDialog());
            layout.nextRow();
            layout.nextColumn();
            layout.add(button);
            GridBagConstraints gbc = layout.getConstraints(button);
            gbc.anchor = 13;
            layout.setMarginBottom(0);
        }
        layout.layout();
    }

    private void launchAdvancedDialog() {
        DBEditorFactory factory = DBEditorFactoryRegistry.getCreateFactory(this.getProvider(), "INDEX");
        DBEditorConfig indexConfig = DBEditorConfig.newEditConfig(this.getProvider(), this.getUpdatedObject());
        indexConfig.setCommitToProvider(false);
        if (!this.isEditing()) {
            indexConfig.setReplaceAlwaysAllowed(true);
        }
        factory.launchDialog(indexConfig);
        if (indexConfig.getResult() == DBEditorConfig.Result.SUCCESS) {
            this.refreshComponents();
        }
    }

    @Override
    protected void initialisePanel() {
        this.handleIndexType();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"indexType", "columnExpressions", Property.createPath((String[])new String[]{"columnExpressions", "expressionSource"})}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent indexTypeChangeEvent) {
                String prop = indexTypeChangeEvent.getPropertyName();
                Object newValue = indexTypeChangeEvent.getNewValue();
                if (prop.equals("indexType") && (Index.IndexType.DOMAIN.equals(indexTypeChangeEvent.getOldValue()) || Index.IndexType.DOMAIN.equals(indexTypeChangeEvent.getNewValue()))) {
                    IndexEditorPanel.this.handleIndexType();
                    IndexEditorPanel.this.getComponentFactory().processComponents();
                    if (Index.IndexType.DOMAIN.equals(newValue)) {
                        ComponentWrapper cwDomainIndextype = IndexEditorPanel.this.getOrCreateWrapper("domainIndextype");
                        ComponentWrapper cwDomainIndextypeParameters = IndexEditorPanel.this.getOrCreateWrapper("domainIndextypeParameters");
                        cwDomainIndextypeParameters.resetPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getDomainIndextypeParameters());
                        cwDomainIndextype.resetPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getDomainIndextype());
                    }
                } else if (propertyName.startsWith("columnExpressions")) {
                    Index index = (Index)obj;
                    IndexEditorPanel.this.cascadeGlobalIndexColumns(index.getColumnExpressions());
                }
            }
        };
    }

    private void handleIndexType() {
        if (this.m_domainIndexSeparator != null) {
            this.m_domainIndexSeparator.setVisible(Index.IndexType.DOMAIN.equals((Object)((Index)this.getUpdatedObject()).getIndexType()));
        }
    }

    private void cascadeGlobalIndexColumns(IndexObject[] columnExpressions) {
        DBObjectID[] partCols;
        Index index = (Index)this.getUpdatedObject();
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip != null && (oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE || oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH) && (partCols = oip.getGlobalPartitionColumns()).length > 0) {
            boolean colFound = false;
            ArrayList<DBObjectID> newPartCols = new ArrayList<DBObjectID>();
            DBObjectID lastCol = partCols[partCols.length - 1];
            if (columnExpressions != null && columnExpressions.length > 0) {
                IndexObject colExpr;
                SQLFragment expression;
                IndexObject[] indexObjectArray = columnExpressions;
                int n = indexObjectArray.length;
                for (int i = 0; i < n && (expression = (colExpr = indexObjectArray[i]).getExpression()) instanceof ColumnUsage; ++i) {
                    ColumnUsage colUsage = (ColumnUsage)expression;
                    DBObjectID colId = colUsage.getObjectID();
                    newPartCols.add(colId);
                    if (!colId.equals(lastCol)) continue;
                    colFound = true;
                    break;
                }
                if (!colFound) {
                    newPartCols.clear();
                }
            }
            oip.setGlobalPartitionColumns(newPartCols.toArray(new DBObjectID[newPartCols.size()]));
            ValuesPropertyPanel.updateIndexPartitionMaxValues(newPartCols.size(), index);
        }
    }
}

