/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.TableWithTabbedChildSplitPane;
import oracle.ideimpl.db.panels.table.ColumnsTabsPanel;
import oracle.ideimpl.db.panels.table.CopyColumnPanel;
import oracle.ideimpl.db.panels.table.SimpleCreateTablePanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.icons.OracleIcons;

public class ColumnsTableEditorPanel
extends SimpleCreateTablePanel {
    private static final int NO_TAB = -1;
    private static final int DEFAULT_TAB = 0;
    private Table.TableType m_tableType;

    public ColumnsTableEditorPanel() {
        super("ColumnsTableEditorPanel");
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.addToolBarButton(this.createCopyButton());
    }

    @Override
    protected boolean stopCellEditingWhenChildPanelFocused() {
        return true;
    }

    @Override
    protected void initialisePanel() {
        Table.TableType currentTableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
        if (this.m_tableType != null && this.m_tableType != currentTableType) {
            this.initialiseTableColumns(true);
        }
        this.m_tableType = currentTableType;
        super.initialisePanel();
    }

    @Override
    protected boolean useSplitter() {
        return true;
    }

    @Override
    protected JComponent createSplitPane(Component topComponent, Component bottomComponent) {
        TableWithTabbedChildSplitPane splitter = new TableWithTabbedChildSplitPane(topComponent, (ColumnsTabsPanel)((Object)bottomComponent));
        return splitter;
    }

    @Override
    protected ChildObjectEditorPanel<Column, Table> createChildPanel() {
        return new ColumnsTabsPanel(this.isInFlatEditor() ? 0 : -1);
    }

    protected JButton createCopyButton() {
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnsTableEditorPanel.this.showCopyDialog();
            }
        };
        copyAction.putValue("SmallIcon", OracleIcons.getIcon((String)"copy.png"));
        copyAction.putValue("ShortDescription", UIBundle.get("COLUMN_INFO_TOOLTIP_COPY_COLS"));
        JButton retval = new JButton();
        retval.setAction(copyAction);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCopyDialog() {
        if (this.exitChildPanel()) {
            int buttonMask = 7;
            JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIBundle.format("COPY_COLUMN_TITLE", ((Table)this.getUpdatedObject()).getName()), (int)7);
            DBObjectProvider pro = this.getProvider();
            Table tab = (Table)this.getUpdatedObject();
            CopyColumnPanel panel = new CopyColumnPanel(pro, (Relation)tab, this.isEditing());
            dialog.setContent((Component)panel);
            try {
                List<Column> cols;
                if (dialog.runDialog() && (cols = panel.getSelectedColumns()) != null && !cols.isEmpty()) {
                    Collection<String> existing = this.getChildNames();
                    for (Column col : cols) {
                        OracleNestedTableProperties ntp;
                        LOBDescriptor va;
                        String name = DBUtil.getUniqueName(existing, (String)col.getName());
                        col.setName(name);
                        existing.add(name);
                        OracleColumnProperties ocp = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
                        if (ocp == null) continue;
                        LOBDescriptor lob = ocp.getLOBProperties();
                        if (lob != null) {
                            lob.setLOBSegName(null);
                        }
                        if ((va = ocp.getVAProperties()) != null) {
                            va.setLOBSegName(null);
                        }
                        if ((ntp = ocp.getNestedTableProperties()) == null) continue;
                        ntp.setTableName(null);
                    }
                    this.addChildRow((ChildDBObject[])cols.toArray(new Column[cols.size()]));
                }
            }
            finally {
                dialog.dispose();
            }
        }
    }
}

