/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.ModelUtil;

public class SelectObjectsPanel
extends BaseSQLQueryBuilderPanel
implements ExpressionPanel.FragmentProvider,
DocumentListener,
ActionListener {
    public static final String FUNCTIONS_CAT = UIBundle.get("EXP_FUNCTIONS");
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc = new JWrappedLabel(UIBundle.get("SELECT_DESC"));
    private ExpressionPanel m_expPanel;
    private JLabel m_lblSelectType = new JLabel();
    private JComboBox m_cmbSelectType = new JComboBox();
    private DefaultComboBoxModel m_mdlSelectType = new NonNullableComboBoxModel();
    private JPanel m_editor;
    private JTextField m_expression = new JTextField();
    private CompletionSupport m_completionSupport;
    private JTextField m_alias = new JTextField();
    private JLabel m_expLabel = new JLabel();
    private JLabel m_aliasLabel = new JLabel();
    private JButton m_validate = new JButton();
    private JButton m_editQuery = new JButton(new EditQueryAction());
    private JButton m_btnSubQuery = new JButton(new AddQueryAction());
    private JTextArea m_subQueryText = new JTextArea();
    private JLabel m_subQueryLabel = new JLabel(UIBundle.get("EXP_SUBQUERY"));
    private JScrollPane m_scrollPane = new JScrollPane(this.m_subQueryText);
    private ControlBar m_toolbar = new ControlBar();
    ComponentWithTitlebar m_compTitleBar = new ComponentWithTitlebar((JComponent)this.m_scrollPane, this.m_subQueryLabel, this.m_toolbar);
    private boolean m_commitPending;
    private SelectObject m_current;
    private boolean m_new;
    private boolean m_showSelectType;
    private DBUIResourceHelper m_reshelp;

    @Override
    protected String getLayoutOnlyMessage(SQLQuery query, SQLQueryBuilder builder) {
        String retval = super.getLayoutOnlyMessage(query, builder);
        if (retval == null && query.getSetOperator() != null) {
            retval = UIBundle.get("SELECT_AND_SET_CANT_SET");
        }
        return retval;
    }

    @Override
    protected void layoutComponents() {
        if (this.m_mdlSelectType.getSize() == 0) {
            this.m_mdlSelectType.addElement(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"));
            this.m_mdlSelectType.addElement(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"));
        }
        this.m_mdlSelectType.setSelectedItem(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"));
        this.removeAll();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        this.m_expPanel = new ExpressionPanel(this);
        this.add(this.m_expPanel, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.m_builder = builder;
        List funcs = this.getProvider().getDescriptor().listBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.getProvider());
            this.m_expPanel.addFunctions(funcs);
            this.m_init = true;
        }
        this.m_expPanel.clearTemplates();
        HashSet<Object> objs = new HashSet<Object>();
        FromObject[] froms = this.m_builder.listAllFromObjects();
        for (int i = 0; i < froms.length; ++i) {
            this.m_expPanel.addTemplate((SQLFragment)froms[i], true);
            objs.add(froms[i]);
        }
        objs.addAll(Arrays.asList(funcs));
        if (this.m_completionSupport == null) {
            this.m_completionSupport = this.getCompletionSupport(this.m_expression);
        }
        SelectObject select = defaultObject instanceof SelectObject ? (SelectObject)defaultObject : null;
        SQLQuery query = this.m_builder.getSQLQuery();
        this.m_expPanel.entered((SQLFragment[])query.getSelectObjects(), (SQLFragment)select);
    }

    @Override
    public void commitPanel() throws TraversalException {
        if (this.m_expPanel != null) {
            this.m_expPanel.exited();
        }
    }

    private SelectObject newSelectObject() {
        SelectObject result = new SelectObject();
        result.setID(TemporaryObjectID.createID((DBObject)result));
        return result;
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String existingAlias = null;
        SQLFragment existingExp = null;
        if (this.m_current != null) {
            existingAlias = this.m_current.getAlias();
            existingExp = this.m_current.getExpression();
        }
        try {
            String expression = this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY")) ? "(" + this.m_subQueryText.getText().trim() + ")" : this.m_expression.getText().trim();
            String alias = this.m_alias.getText().trim();
            if ("".equals(alias)) {
                alias = null;
            }
            this.validateAlias((AliasFragment)this.m_current, alias);
            if (this.m_current != null) {
                SQLFragment exp = this.m_builder.parseSelectExpression(expression);
                if (this.m_new) {
                    this.m_current.setExpression(exp);
                    if (this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"))) {
                        this.m_current.setAlias("<ALIAS>");
                    } else {
                        this.m_current.setAlias(alias);
                    }
                    this.m_builder.addSelectObject(this.m_current);
                    this.m_new = false;
                } else {
                    SelectObject newObj = (SelectObject)this.m_current.copyTo(null);
                    newObj.setExpression(exp);
                    newObj.setAlias(alias);
                    this.m_builder.replaceSelectObject(this.m_current, newObj);
                }
                this.m_expPanel.repaint();
                if ("<ALIAS>".equals(this.m_current.getAlias())) {
                    this.m_current.setAlias(null);
                }
            }
        }
        catch (SQLQueryException sqe) {
            if (this.m_new) {
                this.m_current.setAlias(existingAlias);
                this.m_current.setExpression(existingExp);
            }
            throw sqe;
        }
    }

    private void enableComponents(boolean en) {
        this.m_aliasLabel.setEnabled(en);
        this.m_alias.setEnabled(en);
        this.m_expLabel.setEnabled(en);
        this.m_expression.setEnabled(en);
        this.m_validate.setEnabled(en);
        this.m_cmbSelectType.setEnabled(en);
        if (!en) {
            this.m_alias.setText(null);
            this.m_expression.setText(null);
            this.m_subQueryText.setText(null);
            this.m_commitPending = false;
        }
    }

    @Override
    public String getComponentNamePrefix() {
        return "SelectObjectsPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_reshelp == null) {
            this.m_reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
        }
        this.m_editor = new JPanel();
        this.m_editor.setName(this.getComponentNamePrefix());
        this.m_cmbSelectType.removeActionListener(this);
        this.m_cmbSelectType.addActionListener(this);
        this.m_cmbSelectType.setModel(this.m_mdlSelectType);
        this.layoutSelectPanel(false);
        this.enableComponents(false);
        return this.m_editor;
    }

    private void layoutSelectPanel(boolean showSelectType) {
        this.m_editor.removeAll();
        DBUILayoutHelper topLayout = new DBUILayoutHelper(this.m_editor);
        topLayout.setMargins(5);
        this.m_reshelp.resLabel(this.m_lblSelectType, this.m_cmbSelectType, UIBundle.get("SELECT_INFO_LABEL_TYPE"), "SelectType");
        topLayout.add(this.m_lblSelectType);
        topLayout.add(this.m_cmbSelectType, 2, 1, false, false);
        topLayout.nextRow();
        if (this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"))) {
            this.m_toolbar.removeAll();
            this.m_toolbar.add((Component)this.m_editQuery);
            if (!this.m_cmbSelectType.isEnabled()) {
                this.m_reshelp.resLabel(this.m_expLabel, this.m_subQueryText, UIBundle.get("EXP_EXPRESSION"), "Expression");
                this.m_subQueryText.getDocument().addDocumentListener(this);
                topLayout.add((Component)this.m_compTitleBar, 2, 4, true, true);
                topLayout.nextRow();
                topLayout.nextRow();
                topLayout.nextRow();
                topLayout.nextRow();
                topLayout.nextRow();
                this.m_reshelp.resLabel(this.m_aliasLabel, this.m_alias, UIBundle.get("EXP_ALIAS"), "Alias");
                this.m_alias.getDocument().addDocumentListener(this);
                topLayout.add(this.m_aliasLabel);
                topLayout.add(this.m_alias);
            } else {
                this.m_reshelp.resButton(this.m_btnSubQuery, UIBundle.get("EXP_EDIT_SUBQUERY"), "SubQuery");
                topLayout.add(this.m_btnSubQuery);
                topLayout.pushLeft();
                topLayout.pushUp();
            }
        } else {
            this.m_reshelp.resLabel(this.m_expLabel, this.m_expression, UIBundle.get("EXP_EXPRESSION"), "Expression");
            ToolTipManager.sharedInstance().registerComponent(this.m_expression);
            this.m_expression.getDocument().addDocumentListener(this);
            topLayout.add(this.m_expLabel);
            topLayout.add(this.m_expression);
            topLayout.nextRow();
            this.m_reshelp.resLabel(this.m_aliasLabel, this.m_alias, UIBundle.get("EXP_ALIAS"), "Alias");
            this.m_alias.getDocument().addDocumentListener(this);
            topLayout.add(this.m_aliasLabel);
            topLayout.add(this.m_alias);
            topLayout.nextRow();
            this.m_reshelp.resButton(this.m_validate, UIBundle.get("EXP_VALIDATE"), "Validate");
            this.m_validate.removeActionListener(this);
            this.m_validate.addActionListener(this);
            topLayout.add(this.m_validate);
            topLayout.pushUp();
        }
        topLayout.layout();
        this.m_editor.revalidate();
        this.m_editor.repaint();
    }

    @Override
    public String getEditorName() {
        return UIBundle.get("SELECT_EDITOR");
    }

    @Override
    public String getListTitle() {
        return UIBundle.get("SELECT_LIST_TITLE");
    }

    @Override
    public String getTemplateTitle() {
        return UIBundle.get("EXP_PALETTE");
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = this.newSelectObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        this.m_cmbSelectType.setEnabled(true);
        this.showSelectCombo(true);
        this.m_showSelectType = true;
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment frag) {
        boolean retval = false;
        if (this.m_new) {
            this.m_new = false;
            retval = true;
        } else {
            SQLFragment[] deps = this.m_builder.getDependentObjects((SelectObject)frag);
            retval = deps != null && deps.length > 0 && !MessageDialog.confirm((Component)((Object)this), (Object)UIBundle.get("SELECT_DEPS"), (String)UIBundle.get("SELECT_DEPS_TITLE"), null) ? false : this.m_builder.removeSelectObject((SelectObject)frag);
        }
        return retval;
    }

    @Override
    public void moveFragment(SQLFragment frag, int newIndex) {
        this.m_builder.getSQLQuery().moveSelectObject((SelectObject)frag, newIndex);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment exp = this.m_current == null ? null : this.m_current.getExpression();
            String existing = exp == null ? null : exp.getSQLText();
            String expression = this.m_expression.getText().trim();
            String existingAlias = this.m_current.getAlias();
            String alias = this.m_alias.getText().trim();
            try {
                this.validateAlias((AliasFragment)this.m_current, alias);
            }
            catch (InvalidAliasException e) {
                this.m_commitPending = false;
                throw new TraversalException(e.getMessage());
            }
            if (ModelUtil.areDifferent((Object)alias, (Object)existingAlias) || ModelUtil.areDifferent((Object)expression, (Object)existing)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException e) {
                    throw new TraversalException(e.getMessage());
                }
            }
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment frag) {
        SelectObject selectObject = this.m_current = frag instanceof SelectObject ? (SelectObject)frag : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            SQLFragment exp;
            this.m_alias.setText(this.m_current == null ? "" : this.m_current.getAlias());
            SQLFragment sQLFragment = exp = this.m_current == null ? null : this.m_current.getExpression();
            if (exp instanceof SQLQuery) {
                this.m_mdlSelectType.setSelectedItem(UIBundle.get("SELECT_INFO_LABEL_SUBQUERY"));
                this.m_expPanel.hideTemplatePanel(true);
                this.m_subQueryText.setText(exp == null ? "" : exp.getSQLText());
                this.m_subQueryText.setEditable(false);
            } else {
                this.m_mdlSelectType.setSelectedItem(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"));
                this.m_expPanel.hideTemplatePanel(false);
                this.m_expression.setText(exp == null ? "" : exp.getSQLText());
                this.m_subQueryText.setText("");
                this.m_expression.requestFocusInWindow();
                this.m_expression.selectAll();
            }
            this.m_cmbSelectType.setEnabled(false);
            this.layoutSelectPanel(this.m_showSelectType);
            this.enableComponents(true);
            this.showSelectCombo(false);
            this.m_showSelectType = false;
            this.m_commitPending = false;
        }
    }

    public void addQuery() {
        SQLQueryEditDialog editor = new SQLQueryEditDialog();
        editor.setBindVariables((Collection)this.getDataContext().get("bindVariables"));
        String queryText = this.m_subQueryText.getText();
        DBEditorConfig config = this.getEditorConfig();
        Schema schema = config.getSchema();
        try {
            String defaultQuery;
            String trimmedQuery;
            DBObjectProvider pro = this.getProvider();
            if (schema == null) {
                schema = pro.getDefaultSchema();
            }
            SQLQuery query = new SQLQuery();
            if (queryText.toUpperCase().indexOf("SELECT") != -1) {
                query.setQueryString(queryText);
            }
            String string = queryText = (query = editor.editQuery(query, pro, schema)) == null ? null : query.getSQLText();
            if (queryText != null && !(trimmedQuery = queryText.replaceAll(" ", "").replaceAll("\n", "")).equals(defaultQuery = "SELECT \n    \nFROM \n    \n".replaceAll(" ", "").replaceAll("\n", ""))) {
                this.m_subQueryText.setText(queryText);
                this.updateCurrentFrag();
                this.m_cmbSelectType.setEnabled(false);
                this.showSelectCombo(false);
                this.layoutSelectPanel(true);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void showSelectCombo(boolean show) {
        this.m_cmbSelectType.setVisible(show);
        this.m_lblSelectType.setVisible(show);
    }

    @Override
    public void addToExpression(String text) {
        SelectObjectsPanel.addText(this.m_expression, text);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_cmbSelectType) {
                if (this.m_mdlSelectType.getSelectedItem().equals(UIBundle.get("SELECT_INFO_LABEL_EXPRESSION"))) {
                    this.layoutSelectPanel(true);
                    this.m_expression.requestFocusInWindow();
                    this.m_expression.selectAll();
                    this.m_expPanel.hideTemplatePanel(false);
                } else {
                    this.layoutSelectPanel(true);
                    this.m_subQueryText.setEditable(false);
                    this.m_expPanel.hideTemplatePanel(true);
                }
            } else {
                this.updateCurrentFrag();
                String oldAlias = this.m_current == null ? null : this.m_current.getAlias();
                String newAlias = this.m_alias.getText().trim();
                this.validateAlias((AliasFragment)this.m_current, newAlias);
                if (oldAlias != null && ModelUtil.areDifferent((Object)oldAlias, (Object)newAlias)) {
                    this.m_alias.setText(oldAlias);
                }
                DBObjectRenderer.setToolTipText(this.m_expression, null);
            }
        }
        catch (SQLQueryException sqe) {
            String message = sqe.getMessage();
            this.m_expPanel.showInvalidExpressionDialog(new TraversalException(message));
            DBObjectRenderer.setToolTipText(this.m_expression, message);
        }
    }

    private void validateAlias(AliasFragment frag, String alias) throws InvalidAliasException {
        DBObjectProvider pro;
        if (ModelUtil.hasLength((String)alias) && (pro = this.getProvider()) != null) {
            try {
                pro.validateName("COLUMN", alias);
            }
            catch (InvalidNameException e) {
                throw new InvalidAliasException(frag, e.getMessage());
            }
        }
    }

    class AddQueryAction
    extends AbstractAction {
        AddQueryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectObjectsPanel.this.addQuery();
        }
    }

    class EditQueryAction
    extends AbstractAction {
        public EditQueryAction() {
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"edit.png"));
            this.putValue("ShortDescription", UIBundle.get("EXP_EDIT_SUBQUERY"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectObjectsPanel.this.addQuery();
        }
    }
}

