/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.plsql.PlSqlPanel;
import oracle.ideimpl.db.panels.plsql.TriggerBaseObjectIdPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;

public class TriggerPanel
extends PlSqlPanel<Trigger> {
    public TriggerPanel() {
        super("TriggerPanel");
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper cwEnabled = this.getOrCreateWrapper("enabled");
        ComponentWrapper cwBaseType = this.getOrCreateWrapper("baseType");
        ComponentWrapper cwBaseObjectID = this.getOrCreateWrapper("baseObjectID");
        ComponentWrapper cwTimimg = this.getOrCreateWrapper("timing");
        ComponentWrapper cwEvents = this.getOrCreateWrapper("events");
        ComponentWrapper cwStatementLevel = this.getOrCreateWrapper("statementLevel");
        ComponentWrapper cwReferencingNewAs = this.getOrCreateWrapper("referencingNewAs");
        ComponentWrapper cwReferencingOldAs = this.getOrCreateWrapper("referencingOldAs");
        ComponentWrapper cwWhenClause = this.getOrCreateWrapper("whenClause");
        ComponentWrapper cwColumnIDs = this.getOrCreateWrapper("columnIDs");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        if (this.isInFlatEditor()) {
            layout.add(cwEnabled.getComponent());
            layout.nextRow();
        }
        layout.add(cwBaseType.getLabel());
        layout.add(cwBaseType.getComponent(), 3, 1);
        layout.nextRow();
        layout.addChildren(cwBaseObjectID, 1, 3);
        layout.nextRow();
        layout.add(cwTimimg.getLabel());
        layout.add(cwTimimg.getComponent(), 3, 1);
        layout.nextRow();
        layout.add(cwEvents.getLabel());
        layout.add(cwEvents.getComponent(), 3, 1, true, true);
        layout.nextRow();
        layout.add(cwColumnIDs.getLabel());
        layout.add(cwColumnIDs.getComponent(), 3, 1, true, true);
        layout.nextRow();
        layout.add(cwReferencingOldAs.getLabel());
        layout.add(cwReferencingOldAs.getComponent());
        layout.add(cwStatementLevel.getComponent(), 2, 1);
        layout.nextRow();
        layout.add(cwReferencingNewAs.getLabel());
        layout.add(cwReferencingNewAs.getComponent());
        layout.add(cwWhenClause.getLabel());
        layout.add(cwWhenClause.getComponent());
        layout.pushUp();
        layout.layout();
        if (!this.isEditing()) {
            cwBaseType.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent baseTypeChangeEvent) {
                    TriggerPanel.this.baseTypeChanged(baseTypeChangeEvent);
                }
            });
        }
    }

    @Override
    protected DBObjectListener createObjectListener() {
        DBObjectListener retval = null;
        if (!this.isInFlatEditor()) {
            retval = new DBObjectListener(){

                public void objectUpdated(DBObjectChange change) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TriggerPanel.this.initialisePanel();
                        }
                    });
                }
            };
        }
        return retval;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        ComponentWrapper cwBaseType = this.getOrCreateWrapper("baseType");
        ComponentWrapper cwBaseObjectID = this.getOrCreateWrapper("baseObjectID");
        Trigger trigger = (Trigger)this.getUpdatedObject();
        Trigger.BaseType baseType = trigger.getBaseType();
        cwBaseType.setEnabled(!this.isEditing());
        ((TriggerBaseObjectIdPanel)cwBaseObjectID.getActiveComponent()).setBaseType(baseType);
        PropertyManager pm = this.getProvider().getPropertyManager();
        PropertyHelper ph = this.getPropertyHelper();
        if (pm != null) {
            for (ComponentWrapper comp : this.getComponentFactory().getComponentWrappers()) {
                if (comp == cwBaseType) continue;
                comp.processComponent(this.isEditable(), true);
                comp.setPropertyValue(ph.getPropertyValue((Object)trigger, comp.getPropertyName()));
            }
        }
        if (baseType == Trigger.BaseType.TABLE) {
            ComponentWrapper cwColumnIDs = this.getOrCreateWrapper("columnIDs");
            List<String> list = Arrays.asList(trigger.getEvents());
            boolean update = list.contains("UPDATE");
            cwColumnIDs.setEnabled(update);
            if (!update) {
                cwColumnIDs.setPropertyValue(null);
            }
            ComponentWrapper cwWhenClause = this.getOrCreateWrapper("whenClause");
            cwWhenClause.setEnabled(!trigger.isStatementLevel());
        }
    }

    private void eventsChanged(PropertyChangeEvent baseTypeChangeEvent) {
        this.getComponentFactory().forceProcessComponents();
    }

    private void baseTypeChanged(PropertyChangeEvent baseTypeChangeEvent) {
        Schema schema;
        this.resetPropertyValue("columnIDs", new DBObjectID[0]);
        this.resetPropertyValue("events", new String[0]);
        if (baseTypeChangeEvent.getNewValue() == Trigger.BaseType.VIEW) {
            this.resetPropertyValue("timing", Trigger.Timing.INSTEAD_OF);
        } else if (baseTypeChangeEvent.getOldValue() == Trigger.BaseType.VIEW) {
            this.resetPropertyValue("timing", Trigger.Timing.BEFORE);
        }
        DBObjectID baseObjectID = null;
        if (baseTypeChangeEvent.getNewValue() == Trigger.BaseType.SCHEMA && (baseObjectID = (schema = ((Trigger)this.getUpdatedObject()).getSchema()).getID()) == null) {
            try {
                schema = this.getProvider().getSchema(schema.getName());
                baseObjectID = schema.getID();
            }
            catch (DBException e) {
                this.getLogger().warning(e.getMessage());
            }
        }
        this.resetPropertyValue("baseObjectID", baseObjectID);
        this.getComponentFactory().forceProcessComponents();
    }

    private void resetPropertyValue(String propName, Object value) {
        this.getComponentFactory().findComponentWrapper(propName).resetPropertyValue(value);
    }
}

