/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class TriggerBaseObjectIdPanel
extends JPanel {
    private PropertyInfo m_propertyInfo;
    private DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    private JLabel m_schemaLabel;
    private DBObjectChooser m_cmbSchema;
    private JLabel m_lblRelation;
    private DBObjectChooser m_cmbRelation;
    private Trigger.BaseType m_baseType;
    private boolean m_flat;
    private Collection<DBObjectChooser.ChangeListener> m_listeners = new HashSet<DBObjectChooser.ChangeListener>();

    public void initialisePanel(ComponentContext context, Schema defaultSchema, String displayName) {
        this.m_propertyInfo = context.getPropertyInfo();
        this.m_prov = context.getProvider();
        this.m_flat = context.isInFlatEditor();
        this.m_defaultSchema = defaultSchema;
        String propname = this.m_propertyInfo.getPropertyName();
        DBUIResourceHelper resHelp = new DBUIResourceHelper("");
        this.m_cmbSchema = new DBObjectChooser("SCHEMA");
        this.m_schemaLabel = new JLabel();
        resHelp.resLabel(this.m_schemaLabel, this.m_cmbSchema, UIBundle.format("LABEL_IDPROP_SCHEMA", displayName), propname + "_schema");
        this.m_cmbRelation = new DBObjectChooser(this.m_cmbSchema, "TABLE", "VIEW");
        this.m_cmbRelation.setShowIcon(false);
        this.m_lblRelation = new JLabel();
        String labelText = displayName;
        resHelp.resLabel(this.m_lblRelation, this.m_cmbRelation, labelText + ":", propname + "_object");
        this.m_cmbSchema.setProvider(this.m_prov);
        this.m_cmbSchema.setDBObject(null);
        this.setName(propname);
        DBUILayoutHelper layout = new DBUILayoutHelper(this, context.isInFlatEditor());
        layout.setMarginTop(0);
        layout.add(this.m_schemaLabel);
        layout.add(this.m_cmbSchema);
        layout.nextRow();
        layout.add(this.m_lblRelation);
        layout.add(this.m_cmbRelation);
        layout.layout();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_cmbSchema.setEnabled(enabled && (this.m_baseType == Trigger.BaseType.SCHEMA || !this.m_flat));
        this.m_schemaLabel.setEnabled(enabled && (this.m_baseType == Trigger.BaseType.SCHEMA || !this.m_flat));
        this.m_cmbRelation.setEnabled(enabled && (this.m_baseType == Trigger.BaseType.TABLE || this.m_baseType == Trigger.BaseType.VIEW));
        this.m_lblRelation.setEnabled(enabled && (this.m_baseType == Trigger.BaseType.TABLE || this.m_baseType == Trigger.BaseType.VIEW));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_cmbSchema.setVisible(visible);
        this.m_schemaLabel.setVisible(visible);
        boolean shown = this.m_baseType == null || this.m_baseType == Trigger.BaseType.TABLE || this.m_baseType == Trigger.BaseType.VIEW;
        this.m_cmbRelation.setVisible(visible && shown);
        this.m_lblRelation.setVisible(visible && shown);
    }

    private void setSelectedSchema(DBObjectID schemaObjectID) {
        if (this.m_cmbSchema != null) {
            String dbName;
            String schemaName;
            if (schemaObjectID instanceof BaseObjectID) {
                schemaName = ((BaseObjectID)schemaObjectID).getSchemaName();
                dbName = ((BaseObjectID)schemaObjectID).getDatabaseName();
            } else {
                schemaName = DBUtil.getSchemaName((DBObjectID)schemaObjectID);
                dbName = null;
            }
            if (ModelUtil.hasLength(dbName) || ModelUtil.hasLength((String)schemaName)) {
                NameBasedID schemaID = null;
                try {
                    DBObjectCriteria crit = new DBObjectCriteria(Schema.class, new String[0]);
                    crit.setDatabaseName(dbName);
                    crit.setName(schemaName);
                    Schema schema = (Schema)this.m_prov.getObject(crit);
                    if (schema != null) {
                        schemaID = schema.getID();
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(dbe.getMessage());
                }
                if (schemaID == null) {
                    schemaID = new NameBasedID("SCHEMA", null, schemaName);
                    schemaID.setDatabaseName(dbName);
                }
                this.m_cmbSchema.setDBObjectID((DBObjectID)schemaID);
            } else if (this.m_defaultSchema != null && ModelUtil.areDifferent((Object)this.m_defaultSchema.getName(), (Object)this.m_prov.getDescriptor().getPublicSchemaName())) {
                this.m_cmbSchema.setDBObject((DBObject)this.m_defaultSchema);
            } else {
                try {
                    this.m_cmbSchema.setDBObject((DBObject)this.m_prov.getDefaultSchema());
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(dbe.getMessage());
                }
            }
        }
    }

    public void setDBObjectID(DBObjectID objId) {
        DBObjectID curr = this.getDBObjectID();
        if (ModelUtil.areDifferent((Object)curr, (Object)objId)) {
            if (this.m_baseType == Trigger.BaseType.SCHEMA) {
                DBObjectID parId = DBUtil.getUppermostParent((DBObjectID)objId);
                this.setSelectedSchema(parId);
            } else if (this.m_baseType != Trigger.BaseType.DATABASE) {
                DBObjectID parId = DBUtil.getUppermostParent((DBObjectID)objId);
                this.setSelectedSchema(parId);
                this.m_cmbRelation.setDBObjectID(objId);
            }
        }
        if (this.m_defaultSchema != null && objId == null && ModelUtil.areDifferent((Object)this.m_defaultSchema.getName(), (Object)this.m_prov.getDescriptor().getPublicSchemaName())) {
            this.m_cmbSchema.setDBObject((DBObject)this.m_defaultSchema);
        }
    }

    public DBObjectID getDBObjectID() {
        DBObjectID id = null;
        if (this.m_baseType == Trigger.BaseType.SCHEMA) {
            id = this.m_cmbSchema.getDBObjectID();
        } else if (this.m_baseType != Trigger.BaseType.DATABASE) {
            id = this.m_cmbRelation.getDBObjectID();
        }
        return id;
    }

    public void reset() {
        this.m_cmbRelation.resetCaches();
        this.m_cmbRelation.setDBObjectID(null);
    }

    public void setActiveImpl(boolean active, boolean inFlatEditor) {
        this.m_cmbSchema.setActive(active, inFlatEditor, inFlatEditor);
        this.m_cmbRelation.setActive(active, inFlatEditor, inFlatEditor);
    }

    public final void addChangeListener(DBObjectChooser.ChangeListener l) {
        this.setListenersOnactiveComponent(false);
        this.m_listeners.add(l);
        this.setListenersOnactiveComponent(true);
    }

    public final void removeChangeListener(DBObjectChooser.ChangeListener l) {
        this.setListenersOnactiveComponent(false);
        this.m_listeners.remove(l);
        this.setListenersOnactiveComponent(true);
    }

    private void setListenersOnactiveComponent(boolean set) {
        DBObjectChooser activeComp = this.m_baseType == Trigger.BaseType.SCHEMA ? this.m_cmbSchema : this.m_cmbRelation;
        for (DBObjectChooser.ChangeListener l : this.m_listeners) {
            if (set) {
                activeComp.addChangeListener(l);
                continue;
            }
            activeComp.removeChangeListener(l);
        }
    }

    public String getSchemaComponentName() {
        return this.m_cmbSchema == null ? null : this.m_cmbSchema.getDelegateName();
    }

    public String getDBObjectComponentName() {
        return this.m_cmbRelation == null ? null : this.m_cmbRelation.getDelegateName();
    }

    public void setBaseType(Trigger.BaseType baseType) {
        if (this.m_baseType != baseType) {
            this.setListenersOnactiveComponent(false);
            this.m_baseType = baseType;
            this.m_schemaLabel.setVisible(baseType != Trigger.BaseType.DATABASE);
            this.m_cmbSchema.setVisible(baseType != Trigger.BaseType.DATABASE);
            this.m_lblRelation.setVisible(baseType == Trigger.BaseType.TABLE || baseType == Trigger.BaseType.VIEW);
            this.m_cmbRelation.setVisible(baseType == Trigger.BaseType.TABLE || baseType == Trigger.BaseType.VIEW);
            this.m_cmbRelation.resetCaches();
            this.m_cmbRelation.setDBObjectID(null);
            if (baseType == Trigger.BaseType.TABLE) {
                this.m_cmbRelation.setFilter(obj -> "TABLE".equals(obj.getType()));
            } else if (baseType == Trigger.BaseType.VIEW) {
                this.m_cmbRelation.setFilter(obj -> "VIEW".equals(obj.getType()));
            }
            this.setListenersOnactiveComponent(true);
        }
    }
}

