/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.javatools.db.Column;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;

class PartitionDetailsPanel
extends ChildObjectEditorPanel<TablePartition, Table> {
    PartitionDetailsPanel(String basePath) {
        super("PartitionDetailsPanel", basePath);
    }

    @Override
    protected void initialiseChildComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        this.initialiseChildComponentsImpl(layout);
        layout.pushUp();
        layout.layout();
    }

    protected final void initialiseChildComponentsImpl(DBUILayoutHelper layout) {
        ComponentWrapper cwName = this.getOrCreateWrapper("name");
        layout.add(cwName.getLabel(), 1, 1, false, false);
        layout.add(cwName.getComponent(), 2, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwValues = this.getOrCreateWrapper("values");
        layout.addChildren(cwValues, 1, 1);
        layout.nextRow();
        ComponentWrapper cwComp = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}));
        layout.add(cwComp.getLabel(), 1, 1, false, false);
        layout.add(cwComp.getComponent(), 2, 1, true, false);
        layout.nextRow();
        this.addButton(this.getOrCreateButtonWrapper("LOBDescriptors").getComponent(), layout);
        this.addButton(this.getOrCreateButtonWrapper("OracleInMemoryProperties").getComponent(), layout);
        this.addButton(this.getOrCreateButtonWrapper("segmentAttributes").getComponent(), layout);
    }

    private void addButton(Component button, DBUILayoutHelper layout) {
        layout.add(button, 3, 1, false, false);
        layout.getConstraints((Component)button).anchor = 13;
        layout.nextRow();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        ExtendedPartitionType type = ExtendedPartitionType.getType(this.getChildObject());
        ComponentWrapper valuesWrapper = this.getComponentFactory().findComponentWrapper("values");
        if (valuesWrapper != null) {
            valuesWrapper.setVisible(!type.isHash() && !type.isReference());
            this.enableValuesWrapper(true);
        }
        this.enableLobWrapper(true);
    }

    protected final void enableValuesWrapper(boolean enable) {
        ComponentWrapper valuesWrapper = this.getComponentFactory().findComponentWrapper("values");
        if (valuesWrapper != null) {
            ExtendedPartitionType type = ExtendedPartitionType.getType(this.getChildObject());
            if (this.getProvider() instanceof Database && type.isRange() && this.getOriginalChildObject() != null) {
                enable = false;
            }
            valuesWrapper.setEnabled(enable);
        }
    }

    protected final void enableLobWrapper(boolean enable) {
        ComponentWrapper lobWrapper = this.getComponentFactory().findComponentWrapper("LOBDescriptors");
        if (lobWrapper != null) {
            if (!enable) {
                lobWrapper.setEnabled(false);
            } else {
                Column[] cols;
                boolean hasLobCols = false;
                Table table = OraclePartitionsHandler.getOwningTable(this.getUpdatedObject());
                for (Column col : cols = table.getColumns()) {
                    if (!LOBDescriptor.isLOBColumn((Column)col) && !LOBDescriptor.isVARRAYColumn((Column)col)) continue;
                    hasLobCols = true;
                    break;
                }
                lobWrapper.setEnabled(hasLobCols);
            }
        }
    }
}

