/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.controls.ValuesPropertyPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.TablePartitionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;

class PartitionByPanel
extends BaseEditorPanel<Table> {
    private final TablePartitionPanel m_parent;
    private final Component m_glue = Box.createHorizontalGlue();

    PartitionByPanel(TablePartitionPanel parent) {
        this.m_parent = parent;
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_BY");
    }

    @Override
    public void initialiseComponents() {
        super.initialiseComponents();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwType = this.getOrCreateWrapper(PartitionProperty.PARTITION_TYPE);
        layout.add(cwType.getLabel(), 1, 1, false, false);
        layout.add(cwType.getComponent(), 1, 1, false, false);
        layout.nextRow();
        ComponentWrapper cwCols = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        layout.add(cwCols.getLabel(), 1, 1, false, false);
        layout.add(cwCols.getComponent(), 1, 1, true, true);
        layout.nextRow();
        ComponentWrapper cwRefConstraint = this.getOrCreateWrapper(PartitionProperty.REFERENCE_CONSTRAINT);
        layout.addChildren((Component)cwRefConstraint.getActiveComponent(), new Integer[0]);
        layout.nextRow();
        ComponentWrapper cwSubType = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        cwSubType.getLabel().setText(UIBundle.get("SUBPARTITION_TYPE_LABEL"));
        layout.add(cwSubType.getLabel(), 1, 1, false, false);
        layout.add(cwSubType.getComponent(), 1, 1, false, false);
        layout.nextRow();
        ComponentWrapper cwSubCols = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        layout.add(cwSubCols.getLabel(), 1, 1, false, false);
        layout.add(cwSubCols.getComponent(), 1, 1, true, true);
        layout.nextRow();
        layout.add(this.m_glue, 2, 1, true, true);
        layout.layout();
        cwType.addListener(evt -> this.processPartitionTypeChange());
        cwCols.addListener(evt -> this.processPartitionColsChange(evt, PartitionProperty.PARTITION_COLS));
        cwRefConstraint.addListener(evt -> this.processPropertyChange(PartitionProperty.REFERENCE_CONSTRAINT));
        cwSubType.addListener(evt -> this.processPropertyChange(PartitionProperty.SUBPARTITION_TYPE));
        cwSubCols.addListener(evt -> this.processPartitionColsChange(evt, PartitionProperty.SUBPARTITION_COLS));
    }

    @Override
    public void initialisePanel() {
        this.enableControls();
    }

    private void processPropertyChange(String propPath) {
        if (propPath.equals(PartitionProperty.SUBPARTITION_TYPE)) {
            ComponentWrapper cwSubCols = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
            cwSubCols.setPropertyValue(new String[0]);
        }
        this.enableControls();
    }

    private void processPartitionColsChange(PropertyChangeEvent evt, String propPath) {
        Object[] columns = (Object[])evt.getNewValue();
        ValuesPropertyPanel.updateTablePartitionMaxValues(columns.length, (Table)this.getUpdatedObject(), propPath.equals(PartitionProperty.SUBPARTITION_COLS));
        this.enableControls();
    }

    private void processPartitionTypeChange() {
        ComponentWrapper cwSubType = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        ComponentWrapper cwSubCols = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        ComponentWrapper cwCols = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        ComponentWrapper cwRefConstraint = this.getOrCreateWrapper(PartitionProperty.REFERENCE_CONSTRAINT);
        cwSubType.refreshObject(cwSubType.getComponentContext().getUpdatedObject());
        cwSubCols.setPropertyValue(new String[0]);
        cwSubType.setPropertyValue(null);
        cwCols.setPropertyValue(new String[0]);
        cwRefConstraint.setPropertyValue(null);
        this.getComponentFactory().processComponents();
        this.enableControls();
    }

    private void enableControls() {
        boolean hasSubType;
        boolean hasFK;
        boolean hasCols;
        ComponentWrapper cwCols = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        ComponentWrapper cwSubType = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        ComponentWrapper cwSubCols = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        OracleTablePartitions partitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        boolean hasType = this.hasPartitionTypeSet(partitions);
        boolean bl = hasCols = hasType && this.hasPartitionColumns(partitions);
        boolean bl2 = hasType && partitions.getReferenceConstraintID() != null && ReferencePartitionHelper.isValidReferenceConstraintID((OracleTablePartitions)partitions, (!(this.getProvider() instanceof Database) ? 1 : 0) != 0) ? true : (hasFK = false);
        boolean bl3 = hasType && this.hasPartitionTypeSet(partitions == null ? null : partitions.getSubpartitionModel()) ? true : (hasSubType = false);
        boolean hasSubCols = hasSubType && this.hasPartitionColumns(partitions == null ? null : partitions.getSubpartitionModel());
        Object combo = cwSubType.getActiveComponent();
        boolean hasPossibleSubTypes = combo instanceof JComboBox ? ((JComboBox)combo).getItemCount() > 1 : true;
        cwCols.setEnabled(hasType);
        cwSubType.setEnabled(hasType && hasPossibleSubTypes);
        cwSubCols.setEnabled(hasSubType && hasPossibleSubTypes);
        this.m_parent.enablePartitionDefintionTab(hasCols || hasFK);
        this.m_parent.enableSubpartitionTemplateTab(hasSubCols);
        if (!hasType || partitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            this.m_glue.setVisible(true);
        } else {
            this.m_glue.setVisible(false);
        }
    }

    private boolean hasPartitionTypeSet(OracleTablePartitions partitions) {
        boolean hasTypeSet = false;
        if (partitions != null && partitions.getProperty("partitionType") != null) {
            hasTypeSet = true;
        }
        return hasTypeSet;
    }

    private boolean hasPartitionColumns(OracleTablePartitions partitions) {
        boolean hasCols = false;
        if (partitions != null) {
            DBObjectID[] cols = (DBObjectID[])partitions.getProperty("partitionColumns");
            hasCols = cols != null && cols.length > 0;
        }
        return hasCols;
    }
}

