/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.GlobalIndexPartitionListEditorPanel;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBox;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBoxListener;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionTreeEditorPanel;
import oracle.ideimpl.db.panels.partition.SubpartitionsListEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

abstract class HashPartitionPanel<T extends DBObject>
extends BaseEditorPanel<T> {
    private final HashPartitionComboBox m_combo;
    private final ChildSelectableComponentEditorPanel m_panel;
    private final HashPartitionComboBoxListener m_listener;
    private final Component m_glue = Box.createHorizontalGlue();

    HashPartitionPanel(ChildSelectableComponentEditorPanel panel) {
        super("HashPartitionPanel");
        DBUIResourceHelper rh = new DBUIResourceHelper(this.getName());
        this.m_combo = new HashPartitionComboBox(rh, "HashPartitionType");
        this.m_panel = panel;
        this.m_listener = new HashPartitionComboBoxListenerImpl();
    }

    @Override
    protected void initialisePanel() {
        this.m_combo.getComboBox().removeActionListener(this.m_listener);
        this.m_combo.getComboBox().setSelectedItem((Object)this.getHashType());
        this.m_combo.getComboBox().addActionListener(this.m_listener);
        this.showAndHideControls();
        this.m_panel.onEntry((TraversableContext)this.getDataContext());
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        HashPartitionComboBox.Item item = this.m_combo.getSelectedItem();
        if (item == HashPartitionComboBox.Item.Individual) {
            this.m_panel.onEntry((TraversableContext)this.getDataContext());
        }
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper lh = this.getDBUILayoutHelper();
        lh.add(this.m_combo.getLabel(), 1, 1, false, false);
        lh.add(this.m_combo.getComboBox(), 1, 1, true, false);
        lh.nextRow();
        ComponentWrapper cwQuantity = this.getOrCreateWrapper(this.getHashQuantityProperty());
        lh.add(cwQuantity.getLabel(), 1, 1, false, false);
        lh.add(cwQuantity.getComponent(), 1, 1, true, false);
        lh.nextRow();
        ComponentWrapper cwTablespaces = this.getOrCreateWrapper(this.getHashTablespacesProperty());
        lh.add(cwTablespaces.getLabel(), 1, 1, false, false);
        lh.add(cwTablespaces.getComponent(), 1, 1, true, true);
        lh.nextRow();
        lh.add((Component)((Object)this.m_panel), 2, 1, true, true);
        lh.add(this.m_glue, 2, 1, true, true);
        lh.layout();
    }

    protected OraclePartitionsHandler getPartitionsHandler() {
        return OraclePartitionsHandler.create(this.getUpdatedObject());
    }

    protected abstract String getHashQuantityProperty();

    protected abstract String getHashTablespacesProperty();

    protected abstract HashPartitionComboBox.Item getHashType();

    private void showAndHideControls() {
        ComponentWrapper quantity = this.getOrCreateWrapper(this.getHashQuantityProperty());
        ComponentWrapper tablespaces = this.getOrCreateWrapper(this.getHashTablespacesProperty());
        switch (this.m_combo.getSelectedItem()) {
            case Default: {
                quantity.setVisible(false);
                tablespaces.setVisible(false);
                this.m_glue.setVisible(true);
                this.m_panel.setVisible(false);
                break;
            }
            case Individual: {
                quantity.setVisible(false);
                tablespaces.setVisible(false);
                this.m_glue.setVisible(false);
                this.m_panel.setVisible(true);
                this.m_panel.onEntry((TraversableContext)this.getDataContext());
                break;
            }
            case Quantity: {
                quantity.setVisible(true);
                tablespaces.setVisible(true);
                this.m_glue.setVisible(false);
                this.m_panel.setVisible(false);
            }
        }
    }

    private final class HashPartitionComboBoxListenerImpl
    extends HashPartitionComboBoxListener {
        private HashPartitionComboBoxListenerImpl() {
        }

        @Override
        final OraclePartitionsHandler getPartitionsHandler() {
            return HashPartitionPanel.this.getPartitionsHandler();
        }

        @Override
        final void actionPerformedImpl(ActionEvent e) {
            HashPartitionPanel.this.showAndHideControls();
        }
    }

    static class IndexPartition
    extends HashPartitionPanel<Index> {
        IndexPartition() {
            super(new GlobalIndexPartitionListEditorPanel());
        }

        @Override
        protected String getHashQuantityProperty() {
            return PartitionProperty.INDEX_HASH_QUANTITY;
        }

        @Override
        protected String getHashTablespacesProperty() {
            return PartitionProperty.INDEX_HASH_TABLESPACES;
        }

        @Override
        protected HashPartitionComboBox.Item getHashType() {
            HashPartitionComboBox.Item ret = HashPartitionComboBox.Item.Default;
            OracleIndexPartitions oip = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
            if (oip != null && oip.getGlobalHashQuantity() != null) {
                ret = HashPartitionComboBox.Item.Quantity;
            } else if (oip != null && oip.getPartitions() != null && oip.getPartitions().length > 0) {
                ret = HashPartitionComboBox.Item.Individual;
            }
            return ret;
        }
    }

    static class TableSubpartition
    extends HashPartitionPanel<Table> {
        TableSubpartition() {
            super(new SubpartitionsListEditorPanel());
        }

        @Override
        protected OraclePartitionsHandler getPartitionsHandler() {
            OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
            OracleTablePartitions template = otp.getSubpartitionModel();
            return OraclePartitionsHandler.create((DBObject)template);
        }

        @Override
        protected String getHashQuantityProperty() {
            return PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY;
        }

        @Override
        protected String getHashTablespacesProperty() {
            return PartitionProperty.SUBPARTITION_TEMPLATE_HASH_TABLESPACES;
        }

        @Override
        protected HashPartitionComboBox.Item getHashType() {
            OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
            HashPartitionComboBox.Item ret = HashPartitionComboBox.Item.Default;
            if (otp != null) {
                OracleTablePartitions subs = otp.getSubpartitionModel();
                if (subs != null && subs.getHashQuantity() != null) {
                    ret = HashPartitionComboBox.Item.Quantity;
                } else if (subs != null && subs.getPartitions() != null && subs.getPartitions().length > 0) {
                    ret = HashPartitionComboBox.Item.Individual;
                }
            }
            return ret;
        }
    }

    static class TablePartition
    extends HashPartitionPanel<Table> {
        TablePartition() {
            super(new PartitionTreeEditorPanel());
        }

        @Override
        protected String getHashQuantityProperty() {
            return PartitionProperty.HASH_QUANTITY;
        }

        @Override
        protected String getHashTablespacesProperty() {
            return PartitionProperty.HASH_TABLESPACES;
        }

        @Override
        protected HashPartitionComboBox.Item getHashType() {
            OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
            HashPartitionComboBox.Item ret = HashPartitionComboBox.Item.Default;
            if (otp != null && otp.getHashQuantity() != null) {
                ret = HashPartitionComboBox.Item.Quantity;
            } else if (otp != null && otp.getPartitions() != null && otp.getPartitions().length > 0) {
                ret = HashPartitionComboBox.Item.Individual;
            }
            return ret;
        }
    }
}

