/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.GlobalIndexPartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;

class GlobalIndexPartitionListEditorPanel
extends ChildListEditorPanel<IndexPartition, Index> {
    GlobalIndexPartitionListEditorPanel() {
        super("GlobalIndexPartitionListEditorPanel");
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("PARTITIONS_LIST_TITLE");
    }

    @Override
    protected ChildObjectEditorPanel<IndexPartition, Index> createChildPanel() {
        return new GlobalIndexPartitionDetailsPanel();
    }

    @Override
    protected Class<IndexPartition> getChildClass() {
        return IndexPartition.class;
    }

    @Override
    protected String getChildProperty() {
        return PartitionProperty.INDEX_PARTITIONS;
    }

    @Override
    protected void removeFromParent(IndexPartition partition) {
        DBObject parent = partition.getParent();
        if (parent instanceof OracleIndexPartitions) {
            OracleIndexPartitions oip = (OracleIndexPartitions)parent;
            oip.removePartition(partition);
        }
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new DBObjectRenderer(false){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel retval = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                IndexPartition child = (IndexPartition)value;
                if (child != null) {
                    StringBuilder sb = new StringBuilder(child.getName());
                    Object[] values = child.getValuesLessThan();
                    sb.append(" (");
                    if (values != null && values.length > 0) {
                        for (Object thisValue : values) {
                            sb.append(thisValue);
                            sb.append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(")");
                    retval.setText(sb.toString());
                }
                return retval;
            }
        };
    }
}

