/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.mviewlog;

import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.icons.OracleIcons;

public class MViewLogHeader
extends BaseEditorPanel<MaterializedViewLog> {
    @Override
    protected void initialisePanel() {
        ComponentWrapper cwMasterTable = this.getOrCreateWrapper("masterTableID");
        if (this.getProvider() instanceof Database && this.getEditorConfig().isEdit()) {
            cwMasterTable.setEnabled(false);
        }
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwMasterTable = this.getOrCreateWrapper("masterTableID");
        layout.addChildren(cwMasterTable, new Integer[0]);
        layout.nextRow();
        String templateName = TemplateExpander.getTemplateObjectName(this.getUpdatedObject());
        if (templateName != null) {
            JLabel templateHint = new JLabel();
            templateHint.setText(templateName);
            templateHint.setIcon(OracleIcons.getIcon((String)"copy.png"));
            templateHint.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_GENERAL", templateName));
            layout.add(templateHint, 2, 1);
        }
        layout.pushUp();
        layout.layout();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new DBObjectListener(){

            public void objectUpdated(DBObjectChange change) {
                super.objectUpdated(change);
                PropertyChangeEvent pce = change.getPropertyChange("masterTableID");
                if (pce != null) {
                    MaterializedViewLog mvl = (MaterializedViewLog)MViewLogHeader.this.getUpdatedObject();
                    DBObjectID id = (DBObjectID)pce.getNewValue();
                    String name = id == null ? null : DBUtil.getDBObjectName((DBObjectID)id);
                    mvl.setName(name);
                    if (id != null) {
                        try {
                            Schema tableSchema = MViewLogHeader.this.getProvider().getSchema(DBUtil.getSchemaName((DBObjectID)id));
                            mvl.setSchema(tableSchema);
                        }
                        catch (DBException e) {
                            MViewLogHeader.this.getLogger().warning(e.getMessage());
                        }
                    } else {
                        mvl.setSchema(null);
                    }
                }
            }
        };
    }
}

