/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBLog;
import oracle.javatools.ui.Header;

public class GeneralPanel
implements Traversable {
    private List<Traversable> m_travs = new ArrayList<Traversable>();
    private final JPanel m_panel;
    private final DBUILayoutHelper m_layout;
    private JScrollPane m_scrollPane;
    private boolean m_layoutDone;

    public GeneralPanel(Traversable header, List<Navigable> navs) {
        if (header != null) {
            this.m_travs.add(header);
        }
        if (navs != null) {
            for (Navigable nav : navs) {
                Traversable t = nav.newTraversable(null);
                if (t == null) continue;
                this.m_travs.add(t);
            }
        }
        this.m_panel = new JPanel();
        this.m_panel.setName("GeneralPanel");
        this.m_layout = new DBUILayoutHelper(this.m_panel, true);
        this.m_scrollPane = DBUILayoutHelper.createFlatScrollPane(this.m_panel);
    }

    public void onEntry(TraversableContext dataContext) {
        if (this.m_travs != null) {
            for (Traversable nav : this.m_travs) {
                try {
                    nav.onEntry(dataContext);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error entering sub-panel", e);
                }
            }
        }
        if (!this.m_layoutDone) {
            this.m_layoutDone = true;
            String type = ((DBEditorConfig)dataContext.find(DBEditorConfig.class)).getObjectType();
            Header pageHeader = new Header();
            pageHeader.setLevel(Header.Level.PAGE);
            pageHeader.setText(DBTypeDisplayRegistry.getSingularDisplayName(type));
            pageHeader.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
            this.m_layout.add((Component)pageHeader, 2, 1, false, false);
            this.m_layout.nextRow();
            for (Traversable t : this.m_travs) {
                if (t instanceof ChildTableEditorPanel) {
                    this.m_layout.add(t.getComponent(), 2, 1, true, true);
                } else {
                    this.m_layout.addChildren(t.getComponent(), new Integer[0]);
                }
                this.m_layout.nextRowWithGap();
            }
            this.m_layout.pushUp();
            this.m_layout.layout();
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        TraversalException toThrow = null;
        if (this.m_travs != null) {
            for (Traversable t : this.m_travs) {
                try {
                    t.onExit(dataContext);
                }
                catch (TraversalException te) {
                    toThrow = te;
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error exiting sub-panel", e);
                }
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public Component getComponent() {
        return this.m_scrollPane;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return null;
    }
}

