/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.Header;

public class DBNavigable
extends Navigable {
    private WeakReference<Traversable> m_traversable;
    private boolean m_incHeader;
    private Namespace m_dataContext;
    private Collection<String> m_properties;

    private DBNavigable() {
    }

    public DBNavigable(String shortLabel, Class<? extends Traversable> traversableClass) {
        super(shortLabel, traversableClass);
    }

    public DBNavigable(String shortLabel, Class<? extends Traversable> traversableClass, Class[] constructorSig, Object[] constructorArgs) {
        super(shortLabel, traversableClass, constructorSig, constructorArgs, null);
    }

    public DBNavigable(Navigable base, boolean incHeader) {
        base.copyTo((Object)this);
        this.setIncludeHeader(incHeader);
    }

    public void setIncludeHeader(boolean incHeader) {
        this.m_incHeader = incHeader;
    }

    public void setProperties(Collection<String> properties) {
        this.m_properties = properties;
    }

    public Collection<String> getProperties() {
        Traversable t;
        if (this.m_properties == null && this.m_traversable != null && this.m_dataContext != null && (t = (Traversable)this.m_traversable.get()) instanceof BaseEditorPanel) {
            this.m_properties = ((BaseEditorPanel)t).getComponentFactory().getPaths();
        }
        return this.m_properties;
    }

    public boolean isPanelProperty(String property) {
        boolean retval = false;
        if (this.m_properties != null) {
            for (String panelProp : this.m_properties) {
                if (panelProp == null || !panelProp.equals(property) && !Property.startsWith((String)panelProp, (String[])new String[]{property})) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    protected void setDataScope(Namespace dataScope) {
        super.setDataScope(dataScope);
        this.m_dataContext = dataScope;
    }

    protected Traversable newTraversable() {
        Traversable retval = null;
        if (this.m_traversable != null) {
            retval = (Traversable)this.m_traversable.get();
        }
        if (retval == null) {
            retval = super.newTraversable();
            if (this.m_incHeader) {
                retval = new FlatTraversable(this, retval);
            }
            this.m_traversable = new WeakReference<Traversable>(retval);
        }
        return retval;
    }

    public Object copyTo(Object target) {
        if (target == null) {
            target = new DBNavigable();
        }
        super.copyTo(target);
        if (target instanceof DBNavigable) {
            ((DBNavigable)((Object)target)).m_properties = this.m_properties;
            ((DBNavigable)((Object)target)).m_incHeader = this.m_incHeader;
        }
        return target;
    }

    private static class FlatTraversable
    implements Traversable {
        private final Navigable m_navigable;
        private final Traversable m_delegate;
        private JScrollPane m_scrollPane;

        FlatTraversable(Navigable nav, Traversable delegate) {
            this.m_navigable = nav;
            this.m_delegate = delegate;
        }

        public Component getComponent() {
            if (this.m_scrollPane == null) {
                JPanel panel = new JPanel();
                panel.setMinimumSize(new Dimension(400, 400));
                Header pageHeader = new Header();
                pageHeader.setLevel(Header.Level.PAGE);
                pageHeader.setText(this.m_navigable.getShortLabel());
                pageHeader.setIcon(this.m_navigable.getIcon());
                DBUILayoutHelper layout = new DBUILayoutHelper(panel, true);
                layout.add((Component)pageHeader, 1, 1, false, false);
                layout.nextRow();
                Component mainContent = this.m_delegate.getComponent();
                layout.add(mainContent, 1, 1, true, true);
                panel.setName(mainContent.getName() + "FlatWrapper");
                layout.layout();
                this.m_scrollPane = DBUILayoutHelper.createFlatScrollPane(panel);
            }
            return this.m_scrollPane;
        }

        public Object getExitTransition() {
            return null;
        }

        public String getHelpID() {
            return this.m_delegate.getHelpID();
        }

        public void onEntry(TraversableContext dataContext) {
            try {
                this.m_delegate.onEntry(dataContext);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error entering panel", e);
            }
        }

        public void onExit(TraversableContext dataContext) throws TraversalException {
            try {
                this.m_delegate.onExit(dataContext);
            }
            catch (TraversalException te) {
                throw te;
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error exiting panel", e);
            }
        }
    }
}

