/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.lang.reflect.Array;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.MissingPropertyException;

public abstract class ChildTreeEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildSelectableComponentEditorPanel<C, P> {
    private JTree m_tree;

    public ChildTreeEditorPanel(String panelName) {
        super(panelName);
    }

    protected abstract String[] getChildProperties();

    @Override
    protected final String getChildProperty() {
        return this.getChildProperties()[0];
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(this.getUpdatedObject()));
        this.m_tree = new JTree(model);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(DBValidationManager.wrapTreeCellRenderer(this.createItemRenderer(), this.getDataContext()));
        this.m_tree.setShowsRootHandles(true);
        return SelectableComponent.createSelectableComponent(this.m_tree);
    }

    protected TreeCellRenderer createItemRenderer() {
        return new DBObjectRenderer();
    }

    @Override
    protected void populateComponent() {
        this.addNode((DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), (DBObject)this.getUpdatedObject(), 0);
    }

    @Override
    protected C[] getChildren() {
        SelectableComponent sc = this.getSelectableComponent();
        int sel = sc.getSelectedIndex();
        Object parent = sel < 0 ? this.getUpdatedObject() : (DBObject)sc.getParent(sc.get(sel));
        Object[] kids = sc.getChildren(parent);
        ChildDBObject[] realKids = (ChildDBObject[])Array.newInstance(this.getChildClass(), kids.length);
        for (int i = 0; i < realKids.length; ++i) {
            realKids[i] = (ChildDBObject)kids[i];
        }
        return realKids;
    }

    private void addNode(DefaultMutableTreeNode parent, DBObject contextObject, int level) {
        DefaultMutableTreeNode thisNode;
        if (level > 0) {
            thisNode = new DefaultMutableTreeNode(contextObject);
            parent.insert(thisNode, parent.getChildCount());
        } else {
            thisNode = parent;
        }
        String[] props = this.getChildProperties();
        if (level < props.length) {
            Object obj;
            String propPath = props[level];
            try {
                obj = this.getPropertyHelper().getPropertyValueOrFail((Object)contextObject, props[level]);
            }
            catch (MissingPropertyException mpe) {
                throw new IllegalStateException("No such property: " + propPath);
            }
            if (obj instanceof DBObject[]) {
                DBObject[] childList;
                for (DBObject kid : childList = (DBObject[])obj) {
                    this.addNode(thisNode, kid, level + 1);
                }
            } else if (obj != null) {
                throw new IllegalStateException("Property must be a list of child objects");
            }
        }
    }
}

