/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.PropertyDisplayListCellRenderer;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.components.ComponentFactoryImpl;
import oracle.ideimpl.db.panels.BaseChildrenEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ReorderableBar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.ReorderableTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public abstract class ChildTableEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseChildrenEditorPanel<C, P> {
    private ComponentWrapperTableModel m_wrapperTableModel;
    private final GenericTable m_wrapperTable;
    private final ComponentFactory m_tableComponentFactory = new ComponentFactoryImpl(null, this.getComponentFactory());
    private ReorderableTableWithTitleBar m_reorderTable;
    private AbstractButton m_btnAddColumn;
    private AbstractButton m_btnRemoveColumn;
    private SearchField m_searchField;
    private TableToolbar m_toolBar;
    private boolean m_showSearch;
    private boolean m_searchInitiated;
    private DBObjectListener m_childListener;
    private Boolean m_canChangeProperty;
    private PropertyChangeListener m_pcl;
    private NavigableSet<Integer> m_deleting;

    public ChildTableEditorPanel(String panelName) {
        super(panelName);
        this.m_wrapperTable = new ComponentWrapperTable();
        this.m_childListener = this.createChildObjectListener();
        this.m_pcl = e -> this.processChildPanelFocusUpdate(e);
    }

    @Override
    protected void initialisePanel() {
        RowInfo info;
        this.stopCellEditing(true);
        Object wasSelected = null;
        int oldRow = this.m_wrapperTableModel.getCurrentRowIndx();
        if (oldRow >= 0 && oldRow < this.m_wrapperTableModel.getRowCount() && (info = this.m_wrapperTableModel.getRow(oldRow)) != null) {
            wasSelected = info.getRowObject();
        }
        this.getWrapperTableModel().resetColumns();
        List kids = this.getChildList();
        if (kids != null) {
            for (int i = 0; i < kids.size(); ++i) {
                this.addRow(i, (ChildDBObject)kids.get(i));
            }
        }
        if (this.m_searchInitiated) {
            this.getWrapperTableModel().filterRows(this.m_searchField.getText());
        }
        this.setCurrentChild(null);
        int size = this.m_wrapperTableModel.getRowCount();
        if (size > 0) {
            C child = this.getInitialChild(wasSelected);
            int currRow = this.m_wrapperTableModel.getRowIndex(child);
            this.m_wrapperTable.changeSelection(currRow, currRow, false, false);
            this.selectChild(child);
        } else {
            this.selectChild(null);
        }
        this.m_canChangeProperty = null;
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (!this.stopCellEditing() || !this.exitChildPanel()) {
            throw new TraversalException(null);
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_wrapperTable;
    }

    protected boolean stopCellEditingWhenChildPanelFocused() {
        return false;
    }

    protected boolean useSplitter() {
        return false;
    }

    protected JComponent createSplitPane(Component tableComponent, Component childComponent) {
        JSplitPane splitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, tableComponent, childComponent);
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return splitPane;
    }

    protected DBObjectListener createChildObjectListener() {
        return null;
    }

    private void setChildDBObjectListener(C currentChild, C selectedChild) {
        if (this.m_childListener != null) {
            if (currentChild != null) {
                currentChild.removeObjectListener(this.m_childListener);
            }
            if (selectedChild != null) {
                selectedChild.addObjectListener(this.m_childListener);
            }
        }
    }

    protected boolean shouldRequstFocusOnInitialisePanel() {
        return this.m_wrapperTableModel.getRowCount() > 0;
    }

    protected final boolean isSearchInProgress() {
        return this.m_searchInitiated;
    }

    protected NewChildInsertPolicy getNewChildInsertPolicy() {
        return NewChildInsertPolicy.AFTER_SELECTED_ROW;
    }

    public boolean canMoveRowDown() {
        return this.canChangeProperty();
    }

    public boolean canMoveRowToTop() {
        return this.canChangeProperty();
    }

    public boolean canMoveRowToBottom() {
        return this.canChangeProperty();
    }

    public boolean canMoveRowUp() {
        return this.canChangeProperty();
    }

    public boolean canAddRow() {
        return this.canChangeProperty();
    }

    public boolean canRemoveRow(int rowIndx) {
        return this.canChangeProperty() && this.m_wrapperTable.getSelectedRowCount() > 0;
    }

    protected boolean confirmRowCanBeDeleted(int rowIndx) {
        RowInfo rowInfo = this.getWrapperTableModel().getRow(rowIndx);
        Object child = rowInfo.getRowObject();
        return this.confirmCascadeDelete(child);
    }

    @Override
    protected void cascadeChildDelete(DBObject child, DBObject parent, Collection<DBObject> toDelete) throws DBException {
        super.cascadeChildDelete(child, parent, toDelete);
        if (this.m_deleting != null) {
            Class childClass = this.getChildClass();
            for (DBObject deleted : toDelete) {
                int row;
                ChildDBObject deletedFromJTable = (ChildDBObject)DBUtil.findParentOfType((DBObject)deleted, childClass);
                if (deletedFromJTable == null || (row = this.getWrapperTableModel().getRowIndex(deletedFromJTable)) < 0) continue;
                this.m_deleting.add(row);
            }
        }
    }

    @Override
    protected void initialiseComponents() {
        this.configureTable();
        this.initialiseTableColumns(false);
        JScrollPane tablePane = new JScrollPane((Component)this.m_wrapperTable);
        if (this.isInFlatEditor()) {
            tablePane = new ResizeComponent((JComponent)tablePane);
            tablePane.setPreferredSize(new Dimension(250, 190));
        }
        this.m_reorderTable = new ReorderableTableWithTitleBar((JTable)this.m_wrapperTable, (JComponent)tablePane, this.preserveListOrder(), true);
        this.m_toolBar = new TableToolbar((JTable)this.m_wrapperTable, null);
        this.m_reorderTable.setTableToolbar(this.m_toolBar);
        this.m_reorderTable.setReorderableTable(new ReorderableTable((JTable)this.m_wrapperTable){

            public boolean isSelectionDownwardlyMobile() {
                return super.isSelectionDownwardlyMobile() && ChildTableEditorPanel.this.canMoveRowDown();
            }

            public boolean isSelectionTopMobile() {
                return super.isSelectionTopMobile() && ChildTableEditorPanel.this.canMoveRowToTop();
            }

            public boolean isSelectionUpwardlyMobile() {
                return super.isSelectionUpwardlyMobile() && ChildTableEditorPanel.this.canMoveRowUp();
            }

            public boolean isSelectionBottomMobile() {
                return super.isSelectionBottomMobile() && ChildTableEditorPanel.this.canMoveRowToBottom();
            }
        });
        this.configureToolBar(this.m_toolBar);
        ComponentWrapper<GenericTable> cw = new ComponentWrapper<GenericTable>(this.m_wrapperTable){

            @Override
            public Object getPropertyValue() {
                return null;
            }

            @Override
            public void setPropertyValue(Object val) {
            }

            @Override
            protected void initialiseComponentListener() {
            }

            @Override
            protected Component getDefaultValidationComponent() {
                return ChildTableEditorPanel.this.m_toolBar;
            }
        };
        cw.initialise(this.createComponentContext(this.getChildProperty()));
        this.getComponentFactory().registerComponentWrapper(cw);
        DBUIResourceHelper reshelp = this.getComponentFactory().getResourceHelper();
        reshelp.setName((Component)this.m_wrapperTable, "ColumnTable");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ChildObjectEditorPanel childPanel = this.getChildPanel();
        if (!this.isInFlatEditor() && this.useSplitter()) {
            JComponent splitPane = this.createSplitPane((Component)this.m_reorderTable, (Component)((Object)this.getChildPanel()));
            reshelp.setName(splitPane, "SplitPane");
            layout.add(splitPane);
        } else {
            boolean expandVertically = childPanel == null || !this.isInFlatEditor();
            boolean leftRight = this.isHorizontalSplit();
            layout.add((Component)this.m_reorderTable, 1, 1, true, expandVertically);
            if (childPanel != null) {
                Component childComponent = layout.wrapForInvisibility(childPanel.getComponent());
                if (leftRight) {
                    layout.add(childComponent, 1, 1, true, true);
                    layout.nextRow();
                } else {
                    layout.nextRow();
                    layout.add(childComponent, 1, 1, true, true);
                }
            }
        }
        layout.layout();
    }

    @Override
    protected ChildObjectEditorPanel<C, P> createChildPanel() {
        return null;
    }

    @Override
    protected final void selectChild(C child) {
        if (this.stopCellEditing()) {
            Object currentChild = this.getCurrentChild();
            if (currentChild != child) {
                if (currentChild == null || this.exitChildPanel()) {
                    this.enterChildPanel(child);
                } else {
                    child = currentChild;
                }
            } else {
                ChildObjectEditorPanel childPanel = this.getChildPanel();
                if (childPanel != null && !childPanel.isEntered()) {
                    this.enterChildPanel(child);
                }
            }
            this.setChildDBObjectListener(currentChild, child);
            this.setCurrentChild(child);
            this.enableButtons();
            int idx = this.m_wrapperTableModel.getRowIndex(child);
            this.m_wrapperTableModel.setCurrentRowIndx(idx);
            this.m_wrapperTable.getSelectionModel().setSelectionInterval(idx, idx);
            Rectangle r = this.m_wrapperTable.getCellRect(idx >= 0 ? idx - 1 : -1, 0, true);
            this.m_wrapperTable.scrollRectToVisible(r);
        }
    }

    protected void enableButtons() {
        boolean isEnabled = this.isEnabled();
        this.m_btnAddColumn.setEnabled(isEnabled && this.canAddRow());
        boolean canDelete = false;
        if (isEnabled && this.m_wrapperTable.getSelectedRowCount() > 0) {
            canDelete = true;
            for (int idx : this.m_wrapperTable.getSelectedRowsInModel()) {
                if (this.canRemoveRow(idx)) continue;
                canDelete = false;
                break;
            }
        }
        this.m_btnRemoveColumn.setEnabled(canDelete);
    }

    @Override
    protected C[] getChildren() {
        ChildDBObject[] retval = (ChildDBObject[])Array.newInstance(this.getChildClass(), this.m_wrapperTableModel.getRowCount());
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = this.m_wrapperTableModel.getRow(i).getRowObject();
        }
        return retval;
    }

    protected abstract String[] getPropertiesForRow();

    protected final void addDefaultChildRow() {
        if (this.exitChildPanel()) {
            Object child = this.newChild();
            this.addChildRow(new ChildDBObject[]{child});
        }
    }

    protected final void addChildRow(C ... children) {
        if (this.stopCellEditing()) {
            int lastRow = -1;
            if (this.m_wrapperTableModel.getRowCount() > 0) {
                int[] sel = this.m_wrapperTable.getSelectedRows();
                lastRow = this.getNewChildInsertPolicy() == NewChildInsertPolicy.AT_END || this.isSearchInProgress() || sel.length == 0 ? this.m_wrapperTableModel.getRowCount() - 1 : sel[sel.length - 1];
            }
            int row = lastRow;
            for (C child : children) {
                this.m_wrapperTableModel.addRow(++row, child, false);
            }
            this.m_wrapperTable.setRowSelectionInterval(lastRow + 1, row);
            this.m_wrapperTable.requestFocusInWindow();
            this.commitChildProperty();
        }
    }

    protected void initialiseTableComponents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedRows() {
        int[] selection = this.m_wrapperTable.getSelectedRows();
        if (selection.length > 0) {
            Arrays.sort(selection);
            try {
                this.m_deleting = new TreeSet<Integer>();
                TableCellEditor ed = this.m_wrapperTable.getCellEditor();
                if (ed != null) {
                    ed.cancelCellEditing();
                }
                this.setCurrentChild(null);
                this.m_wrapperTable.clearSelection();
                for (int i = selection.length - 1; i >= 0; --i) {
                    if (selection[i] < 0 || !this.confirmRowCanBeDeleted(selection[i])) continue;
                    this.m_deleting.add(selection[i]);
                }
                Iterator<Integer> rowsIter = this.m_deleting.descendingIterator();
                while (rowsIter.hasNext()) {
                    Integer rowToRemove = rowsIter.next();
                    this.m_wrapperTableModel.deleteRow(rowToRemove);
                }
                int rowCount = this.m_wrapperTableModel.getRowCount();
                if (rowCount == 0) {
                    this.enterChildPanel(null);
                    this.m_btnAddColumn.requestFocusInWindow();
                } else {
                    int last = selection[selection.length - 1];
                    if (last >= rowCount) {
                        last = rowCount - 1;
                    }
                    this.m_wrapperTable.getSelectionModel().setSelectionInterval(last, last);
                    this.m_wrapperTable.requestFocusInWindow();
                }
            }
            finally {
                this.m_deleting = null;
            }
        }
    }

    public void addRow(int rowIndx, C rowObject) {
        this.m_wrapperTableModel.addRow(rowIndx, rowObject, true);
    }

    public final void addColumn(int position, String header, Class columnClass, NonPropertyColumnLogic<C> columnLogic) {
        this.addColumn(position, header, columnClass, columnLogic, null);
    }

    public final void addColumn(int position, String header, Class columnClass, NonPropertyColumnLogic<C> columnLogic, TableCellRenderer cellRenderer) {
        this.m_wrapperTableModel.addColumn(header, position, columnClass, columnLogic, cellRenderer);
    }

    protected void initialiseTableColumns(boolean refreshing) {
        this.m_wrapperTableModel = new ComponentWrapperTableModel();
        this.m_wrapperTable.setModel((TableModel)this.m_wrapperTableModel);
        if (refreshing) {
            TableColumnModel tabCols = this.m_wrapperTable.getColumnModel();
            while (tabCols.getColumnCount() > 0) {
                TableColumn tabCol = tabCols.getColumn(tabCols.getColumnCount() - 1);
                this.m_wrapperTable.removeColumn(tabCol);
            }
        }
        this.initialiseTableHeaders();
        this.initialiseTableComponents();
        this.initialiseCellEditors();
    }

    private void initialiseTableHeaders() {
        this.m_tableComponentFactory.setBasePath(this.getChildProperty());
        this.m_tableComponentFactory.setDataContext(this.getDataContext());
        ArrayList<PropertyInfo> columnProps = new ArrayList<PropertyInfo>();
        String[] propertyPaths = this.getPropertiesForRow();
        PropertyManager mgr = this.getProvider().getPropertyManager();
        for (String childProp : propertyPaths) {
            PropertyInfo propInfo;
            String fullPath = Property.createPath((String[])new String[]{this.getComponentFactory().getBasePath(), this.getChildProperty(), childProp});
            if (!mgr.canCreateProperty(this.getEditorConfig().getUpdatedObject(), fullPath) || (propInfo = mgr.findPropertyInfo(this.getChildClass(), childProp)) == null) continue;
            if (childProp.equals("name")) {
                this.m_showSearch = true;
            }
            columnProps.add(propInfo);
        }
        this.m_wrapperTableModel.initialiseColumnHeaders(columnProps);
    }

    private void configureToolBar(TableToolbar toolbar) {
        DBUIResourceHelper reshelp = this.getComponentFactory().getResourceHelper();
        this.m_btnAddColumn = this.createAddButton();
        reshelp.setName(this.m_btnAddColumn, "Add");
        this.m_btnRemoveColumn = this.createRemoveButton();
        reshelp.setName(this.m_btnRemoveColumn, "Remove");
        this.setLayout(new BorderLayout(10, 0));
        JLabel titleLabel = new JLabel();
        reshelp.resLabel(titleLabel, (Component)this.m_wrapperTable, UIBundle.get("COLUMN_INFO_LABEL_COLUMNS"), "ColumnTable");
        toolbar.setBackground(Color.white);
        toolbar.setOpaque(false);
        if (this.m_showSearch) {
            this.addSearchField(toolbar);
        }
        toolbar.addActionControl((Component)this.m_btnAddColumn);
        toolbar.addActionControl((Component)this.m_btnRemoveColumn);
        String tableTitle = PropertyDisplayRegistry.getDisplayName(this.getChildProperty()) + ":";
        toolbar.setLabel(tableTitle);
    }

    private void addSearchField(TableToolbar toolbar) {
        this.m_searchField = new SearchField(SearchField.Style.FILTER);
        this.m_searchField.setEnabled(true);
        this.m_searchField.setTypingDelay(SearchField.TypingDelay.FAST);
        this.m_searchField.setAllowEmptySearch(true);
        this.m_searchField.setPrompt(UIBundle.get("TABLE_SEARCH_NAME"));
        Dimension size = this.m_searchField.getPreferredSize();
        size.width = 100;
        this.m_searchField.setPreferredSize(size);
        this.m_searchField.setMaximumSize(size);
        this.m_searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                ChildTableEditorPanel.this.stopCellEditing(true);
                String matchText = se.getSearchText();
                if (se.isFromClear()) {
                    matchText = "";
                    ChildTableEditorPanel.this.m_searchInitiated = false;
                } else {
                    ChildTableEditorPanel.this.m_searchInitiated = true;
                }
                ChildTableEditorPanel.this.m_reorderTable.getReorderableBar().setEnabled(!ChildTableEditorPanel.this.m_searchInitiated);
                ChildTableEditorPanel.this.m_wrapperTableModel.filterRows(matchText);
                int rowIndx = ChildTableEditorPanel.this.m_wrapperTable.getSelectedRowInModel();
                if (rowIndx == -1 && ChildTableEditorPanel.this.m_wrapperTableModel.getRowCount() > 0) {
                    ChildTableEditorPanel.this.m_wrapperTable.setRowSelectionInterval(0, 0);
                }
                ChildTableEditorPanel.this.initialiseCellEditors();
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        toolbar.addActionControl((Component)this.m_searchField, false);
        toolbar.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
    }

    protected AbstractButton createAddButton() {
        AbstractAction addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChildTableEditorPanel.this.stopCellEditing()) {
                    if (ChildTableEditorPanel.this.isSearchInProgress()) {
                        ChildTableEditorPanel.this.m_searchField.clear();
                        int row = ChildTableEditorPanel.this.m_wrapperTableModel.getRowCount();
                        ChildTableEditorPanel.this.m_wrapperTable.getSelectionModel().setSelectionInterval(row, row);
                        ChildTableEditorPanel.this.m_wrapperTable.scrollToSelection();
                    }
                    ChildTableEditorPanel.this.addDefaultChildRow();
                }
            }
        };
        String childType = DBTypeDisplayRegistry.getSingularDisplayName(this.getChildType());
        addAction.putValue("SmallIcon", OracleIcons.getIcon((String)"add.png"));
        addAction.putValue("ShortDescription", UIBundle.format("LIST_BUTTONS_ADD_TYPE", childType));
        JButton retval = new JButton();
        retval.setAction(addAction);
        return retval;
    }

    protected AbstractButton createRemoveButton() {
        AbstractAction removeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChildTableEditorPanel.this.removeSelectedRows();
            }
        };
        String childType = DBTypeDisplayRegistry.getSingularDisplayName(this.getChildType());
        removeAction.putValue("SmallIcon", OracleIcons.getIcon((String)"delete.png"));
        removeAction.putValue("ShortDescription", UIBundle.format("LIST_BUTTONS_REMOVE_TYPE", childType));
        JButton retval = new JButton();
        retval.setAction(removeAction);
        AsynchronousComponentWrapper.registerCancellingComponent(retval, (Component)this.m_wrapperTable);
        return retval;
    }

    protected void addToolBarButton(JButton button) {
        this.m_toolBar.addActionControl((Component)button);
    }

    private void configureTable() {
        this.m_wrapperTable.setAutoCreateColumnsFromModel(false);
        this.m_wrapperTable.setResizeColumnOnDoubleClick(true);
        this.m_wrapperTable.setColumnSelectionAllowed(false);
        this.m_wrapperTable.setColumnSelectorAvailable(false);
        this.m_wrapperTable.setColumnHeaderSelectionEnabled(false);
        this.m_wrapperTable.setPreferredVisibleRowCount(5);
        this.m_wrapperTable.setRolloverHighlightingEnabled(true);
        this.m_wrapperTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ChildTableEditorPanel.this.isEntered() && !e.getValueIsAdjusting()) {
                    ChildTableEditorPanel.this.tableSelectionChanged();
                }
            }
        });
        if (!Modifier.isAbstract(this.getChildClass().getModifiers())) {
            this.m_wrapperTable.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int rowNum;
                    if (e.getKeyCode() == 40 && (rowNum = ChildTableEditorPanel.this.m_wrapperTable.getSelectedRow()) == ChildTableEditorPanel.this.m_wrapperTable.getRowCount() - 1) {
                        ChildTableEditorPanel.this.addDefaultChildRow();
                    }
                }
            });
        }
        this.m_wrapperTable.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, false), "cancelEdit");
        this.m_wrapperTable.getActionMap().put("cancelEdit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChildTableEditorPanel.this.m_wrapperTable.isEditing()) {
                    int row = ChildTableEditorPanel.this.m_wrapperTable.getEditingRow();
                    int col = ChildTableEditorPanel.this.m_wrapperTable.getEditingColumn();
                    ChildTableEditorPanel.this.m_wrapperTable.getCellEditor(row, col).cancelCellEditing();
                }
            }
        });
    }

    private void tableSelectionChanged() {
        int selSize = this.m_wrapperTable.getSelectedRowCount();
        C selectedChild = null;
        int rowIndx = -1;
        if (selSize == 1) {
            RowInfo rowInfo;
            rowIndx = this.m_wrapperTable.getSelectedRowInModel();
            if (rowIndx > this.m_wrapperTableModel.getRowCount() - 1) {
                rowIndx = this.m_wrapperTableModel.getRowCount() - 1;
            }
            if ((rowInfo = this.m_wrapperTableModel.getRow(rowIndx)) != null) {
                selectedChild = rowInfo.getRowObject();
            }
        }
        this.selectChild(selectedChild);
    }

    private void initialiseCellEditors() {
        int columnCount = this.m_wrapperTableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumnModel tcm = this.m_wrapperTable.getColumnModel();
            TableColumn tabCol = tcm.getColumn(i);
            Class columnClz = this.m_wrapperTableModel.getColumnClass(i);
            if (this.m_wrapperTableModel.isComponentWrapperCell(i)) {
                tabCol.setCellEditor(new ComponentWrapperCellEditor());
                continue;
            }
            if (columnClz.equals(String.class)) {
                tabCol.setCellEditor(new StringCellEditor());
                continue;
            }
            if (!columnClz.equals(Boolean.class)) continue;
            Font font = this.m_wrapperTable.getTableHeader().getFont();
            String columnName = this.m_wrapperTableModel.getColumnName(i);
            int size = SwingUtilities.computeStringWidth(this.getFontMetrics(font), columnName) + 16;
            if (size < 30) {
                size = 30;
            }
            tabCol.setMinWidth(size);
            tabCol.setMaxWidth(size);
        }
    }

    private ComponentWrapper getOrCreateTableComponentWrapper(C child, String propPath) {
        ComponentWrapper retval = this.m_tableComponentFactory.findComponentWrapper(propPath);
        if (retval == null) {
            retval = this.m_tableComponentFactory.createWrapper(this.createTableComponentContext(child, propPath));
            if (this.isEntered()) {
                retval.setActive(true);
            }
            this.m_tableComponentFactory.registerComponentWrapper(retval);
            if (propPath.equals("name")) {
                retval.addVetoListener(evt -> this.vetoInvalidNameChange(evt));
                if (!this.isInFlatEditor()) {
                    retval.addListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            Object oldName = evt.getOldValue();
                            Object newName = evt.getNewValue();
                            Object child = ChildTableEditorPanel.this.getCurrentChild();
                            Object sysObj = ChildTableEditorPanel.this.getUpdatedObject();
                            if (child != null && sysObj instanceof SystemObject && ModelUtil.areDifferent((Object)oldName, (Object)newName) && ModelUtil.areEqual((Object)child.getName(), (Object)newName)) {
                                try {
                                    DBUtil.cascadeInternalRename((SystemObject)((SystemObject)sysObj), child, (String)((String)oldName), (String)((String)newName), (DBObjectProvider)ChildTableEditorPanel.this.getProvider());
                                }
                                catch (DBException dbe) {
                                    DBExceptionDialog.showErrorDialog((Component)((Object)ChildTableEditorPanel.this), ProviderOperator.getErrorTitle(ChildTableEditorPanel.this.getEditorConfig()), dbe);
                                }
                            }
                        }
                    });
                }
            }
        }
        return retval;
    }

    private void vetoInvalidNameChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object newVal;
        Object oldVal;
        if (this.isEntered() && ModelUtil.areDifferent((Object)(oldVal = evt.getOldValue()), (Object)(newVal = evt.getNewValue()))) {
            String newName;
            String error = null;
            String string = newName = newVal == null ? null : newVal.toString();
            if (!ModelUtil.hasLength((String)newName)) {
                error = UIBundle.get("MISSING_NAME_ERROR");
            } else {
                try {
                    DBObject obj = this.getParentUpdatedObject();
                    String extName = this.getProvider().getExternalName(newName);
                    this.getProvider().validateUniqueName(this.getChildType(), obj, extName);
                }
                catch (NameInUseException ine) {
                    error = ine.getMessage();
                }
            }
            if (error != null) {
                throw new PropertyVetoException(error, evt);
            }
        }
    }

    private ComponentContext createTableComponentContext(C child, String propertyPath) {
        if (child == null) {
            throw new IllegalStateException("Cannot create a child component context without a child.");
        }
        ChildDBObject original = null;
        DBObjectID childID = child.getID();
        if (childID instanceof TemporaryObjectID) {
            original = (ChildDBObject)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)childID));
        }
        ComponentContext cc = this.m_tableComponentFactory.createComponentContext(propertyPath, (DBObject)original, (DBObject)child);
        cc.setInTable(true);
        return cc;
    }

    public final void setDefaultRenderer(Class columnClz, TableCellRenderer renderer) {
        this.m_wrapperTable.setDefaultRenderer(columnClz, renderer);
    }

    public final void setColumnCellRenderer(String propName, TableCellRenderer renderer) {
        block2: {
            TableColumnModel colModel = this.m_wrapperTable.getColumnModel();
            try {
                colModel.getColumn(colModel.getColumnIndex(propName)).setCellRenderer(new ValidationCellRenderer(renderer));
            }
            catch (IllegalArgumentException iae) {
                String[] props = this.getPropertiesForRow();
                if (props != null && Arrays.asList(props).contains(propName)) break block2;
                this.getLogger().warning("No column found for property " + propName);
            }
        }
    }

    protected final GenericTable getWrapperTable() {
        return this.m_wrapperTable;
    }

    public final ComponentWrapperTableModel getWrapperTableModel() {
        return this.m_wrapperTableModel;
    }

    protected final boolean stopCellEditing() {
        return this.stopCellEditing(null);
    }

    private boolean stopCellEditing(Boolean force) {
        TableCellEditor ed;
        boolean retval = true;
        if (Boolean.TRUE.equals(force)) {
            this.commitOrCancelCurrentWrapper();
        }
        if ((ed = this.m_wrapperTable.getCellEditor()) != null && !(retval = ed.stopCellEditing()) && force != null) {
            ed.cancelCellEditing();
        }
        return retval;
    }

    protected List<String> getHeaderPanelProperties() {
        return Collections.emptyList();
    }

    public boolean isTableCellEditable(int row, int col) {
        return true;
    }

    private boolean canChangeProperty() {
        if (this.m_canChangeProperty == null) {
            Object obj = this.getUpdatedObject();
            if (obj instanceof SystemObject && this.disableButtonsIfPropertyCannotChange()) {
                SystemObject upd = (SystemObject)obj;
                SystemObject orig = (SystemObject)this.getOriginalObject();
                this.m_canChangeProperty = this.getProvider().getPropertyManager().canChangeProperty(orig, upd, this.getChildProperty()) != null;
            } else {
                this.m_canChangeProperty = true;
            }
        }
        return this.m_canChangeProperty;
    }

    protected boolean disableButtonsIfPropertyCannotChange() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_reorderTable != null) {
            ReorderableBar bar = this.m_reorderTable.getReorderableBar();
            if (bar != null) {
                bar.setEnabled(!this.m_searchInitiated && enabled);
            }
            this.enableButtons();
        }
    }

    private void processChildPanelFocusUpdate(PropertyChangeEvent pce) {
        Object o;
        if ("permanentFocusOwner".equals(pce.getPropertyName()) && (o = pce.getNewValue()) instanceof Component && SwingUtilities.isDescendingFrom((Component)o, (Component)((Object)this.getChildPanel()))) {
            this.stopCellEditing();
        }
    }

    private void addFocusManagerPropertyChangeListener() {
        if (this.stopCellEditingWhenChildPanelFocused()) {
            this.removeFocusManagerPropertyChangeListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.m_pcl);
        }
    }

    private void removeFocusManagerPropertyChangeListener() {
        if (this.stopCellEditingWhenChildPanelFocused()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.m_pcl);
        }
    }

    private void cancelCurrentWrapper() {
        AsynchronousComponentWrapper.cancelCurrentWrapper(this.getDataContext());
    }

    private class ValidationCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer m_delegate;

        ValidationCellRenderer(TableCellRenderer delegate) {
            this.m_delegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component retval = this.m_delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            DBValidationManager mgr = (DBValidationManager)ChildTableEditorPanel.this.getDataContext().find(DBValidationManager.class);
            if (mgr != null) {
                int realColumn = table.convertColumnIndexToModel(column);
                RowInfo rowInfo = ChildTableEditorPanel.this.m_wrapperTableModel.getRow(row);
                if (rowInfo != null) {
                    Object rowObject = rowInfo.getRowObject();
                    String prop = null;
                    ComponentWrapper wrapper = (ComponentWrapper)ChildTableEditorPanel.this.m_wrapperTableModel.m_componentWrappers.get(realColumn);
                    if (wrapper != null) {
                        prop = wrapper.getPropertyName();
                    } else {
                        NonPropertyColumnLogic logic = (NonPropertyColumnLogic)ChildTableEditorPanel.this.m_wrapperTableModel.m_nonPropColumnLogics.get(realColumn);
                        if (logic != null) {
                            prop = logic.getPropertyPath(rowObject);
                        }
                    }
                    if (prop != null) {
                        retval = mgr.processRendererComponent(retval, (DBObject)rowObject, prop);
                    }
                }
            }
            return retval;
        }
    }

    protected class PropertyValueCellRenderer
    extends GenericTableCellRenderer {
        protected PropertyValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            column = table.convertColumnIndexToModel(column);
            ComponentWrapper wrapper = (ComponentWrapper)ChildTableEditorPanel.this.m_wrapperTableModel.m_componentWrappers.get(column);
            if (wrapper != null) {
                String propName = wrapper.getPropertyName();
                value = PropertyDisplayListCellRenderer.normalizeValue(propName, value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    public static class RowInfo {
        private C m_rowObject;
        private List<Object> m_data;
        final /* synthetic */ ChildTableEditorPanel this$0;

        public RowInfo(C rowObject, List<Object> rowData) {
            this.this$0 = this$0;
            this.m_rowObject = rowObject;
            this.m_data = rowData;
        }

        public void refreshRow(List<ComponentWrapper> wrappers) {
            for (ComponentWrapper wrapper : wrappers) {
                if (wrapper == null) continue;
                wrapper.refreshObject((DBObject)this.m_rowObject);
            }
        }

        public List<Object> getRowColumns() {
            return this.m_data;
        }

        public C getRowObject() {
            return this.m_rowObject;
        }
    }

    public abstract class NonPropertyColumnLogic<C> {
        public abstract Object getCellValue(C var1);

        public void setValueAt(Object value, int row, int column) {
        }

        public Object getValueAt(Object defaultValue, int rowIndex, int columnIndex) {
            RowInfo rowInfo = ChildTableEditorPanel.this.getWrapperTableModel().getRow(rowIndex);
            Object rowObject = rowInfo.getRowObject();
            return this.getCellValue(rowObject);
        }

        public boolean isCellEditable(C rowObject) {
            return false;
        }

        public String getPropertyPath(C rowObject) {
            return null;
        }
    }

    private class StringCellEditor
    extends DefaultCellEditor {
        StringCellEditor() {
            super(new JTextField());
            ChildTableEditorPanel.this.getComponentFactory().getResourceHelper().setName(this.getComponent(), "StringCellEditor");
            this.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ChildTableEditorPanel.this.addFocusManagerPropertyChangeListener();
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean stopCellEditing() {
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
            super.cancelCellEditing();
        }
    }

    private class ComponentWrapperCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComponentWrapper m_componentWrapper = null;
        private Object m_startingValue = null;

        private ComponentWrapperCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_componentWrapper.getPropertyValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editorComp = null;
            column = table.convertColumnIndexToModel(column);
            ChildTableEditorPanel.this.addFocusManagerPropertyChangeListener();
            this.m_componentWrapper = ChildTableEditorPanel.this.m_wrapperTableModel.getComponentWrapperForColumn(row, column);
            this.m_startingValue = this.m_componentWrapper.getPropertyValue();
            if (this.m_componentWrapper != null) {
                editorComp = this.m_componentWrapper.getCellEditorComponent();
            }
            if (editorComp instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)editorComp;
                cb.setHorizontalAlignment(0);
                cb.setText(null);
                cb.setOpaque(false);
            }
            return editorComp;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent e = (MouseEvent)anEvent;
                return e.getID() != 506;
            }
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
            return ChildTableEditorPanel.this.commitCurrentWrapper() && super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.m_componentWrapper instanceof AsynchronousComponentWrapper) {
                ChildTableEditorPanel.this.cancelCurrentWrapper();
                super.cancelCellEditing();
            }
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
        }
    }

    public class ComponentWrapperTableModel
    extends DefaultTableModel {
        private final List<RowInfo> m_rowData = new ArrayList<RowInfo>();
        private final List<RowInfo> m_unfilteredRowData = new ArrayList<RowInfo>();
        private final List<String> m_columnProps = new ArrayList<String>();
        private final List<String> m_columnNames = new ArrayList<String>();
        private final List<Class> m_columnTypes = new ArrayList<Class>();
        private final List<ComponentWrapper> m_componentWrappers = new ArrayList<ComponentWrapper>();
        private final List<String> m_rowNames = new ArrayList<String>();
        private final Map<Integer, NonPropertyColumnLogic> m_nonPropColumnLogics = new TreeMap<Integer, NonPropertyColumnLogic>();
        private int m_currentRowIndx = -1;

        @Override
        public int getRowCount() {
            return this.m_rowData != null ? this.m_rowData.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.m_columnNames.get(col);
        }

        public Class getColumnClass(int c) {
            Class<Enum> retval = this.m_columnTypes.get(c);
            if (this.isComponentWrapperCell(c) && Enum.class.isAssignableFrom(retval)) {
                retval = Enum.class;
            }
            return retval;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ComponentWrapper cw;
            if (row >= this.m_rowData.size()) {
                return;
            }
            RowInfo rowInfo = this.m_rowData.get(row);
            if (this.m_currentRowIndx != row) {
                this.setCurrentRowIndx(row);
                rowInfo.refreshRow(this.m_componentWrappers);
            }
            if ((cw = this.m_componentWrappers.get(col)) != null && cw.getPropertyName().equals("name")) {
                this.m_rowNames.set(row, String.valueOf(value));
            } else {
                NonPropertyColumnLogic logic = this.m_nonPropColumnLogics.get(col);
                if (logic != null) {
                    logic.setValueAt(value, row, col);
                }
            }
            List<Object> colList = rowInfo.getRowColumns();
            if (col >= colList.size()) {
                return;
            }
            colList.set(col, value);
            this.fireTableCellUpdated(row, col);
        }

        public void resetColumns() {
            int count = this.getRowCount();
            for (int i = count - 1; i >= 0; --i) {
                this.deleteRow(i, false);
            }
            this.clearRowsCache();
        }

        private void clearRowsCache() {
            this.m_rowNames.clear();
            this.m_unfilteredRowData.clear();
            this.m_componentWrappers.clear();
        }

        public void setValueForProperty(C rowObject, String property, Object value, int rowIndx) {
            String columnName = PropertyDisplayRegistry.getDisplayName(property, ChildTableEditorPanel.this.getProvider(), rowObject);
            int colIndx = this.m_columnNames.indexOf(columnName);
            this.setValueAt(value, rowIndx, colIndx);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object retVal = null;
            if (rowIndex < this.m_rowData.size()) {
                NonPropertyColumnLogic logic;
                RowInfo row = this.m_rowData.get(rowIndex);
                List<Object> rowColumns = row.getRowColumns();
                if (columnIndex < rowColumns.size()) {
                    retVal = rowColumns.get(columnIndex);
                }
                if ((logic = this.m_nonPropColumnLogics.get(columnIndex)) != null) {
                    retVal = logic.getValueAt(retVal, rowIndex, columnIndex);
                }
            }
            return retVal;
        }

        @Override
        public void moveRow(int start, int end, int to) {
            int extras = end - start;
            for (int i = 0; i <= extras; ++i) {
                this.moveRowImpl(start + i, to + i);
            }
            ChildTableEditorPanel.this.commitChildProperty();
        }

        private void moveRowImpl(int from, int to) {
            RowInfo row = this.m_rowData.remove(from);
            this.m_rowData.add(to, row);
            if (ChildTableEditorPanel.this.m_showSearch) {
                RowInfo unfilteredRow = this.m_unfilteredRowData.remove(from);
                this.m_unfilteredRowData.add(to, unfilteredRow);
                String rowName = this.m_rowNames.remove(from);
                this.m_rowNames.add(to, rowName);
            }
        }

        public RowInfo getRow(int rowIndx) {
            if (this.m_rowData.isEmpty()) {
                return null;
            }
            return this.m_rowData.get(rowIndx);
        }

        public void initialiseColumnHeaders(List<PropertyInfo> columnProps) {
            if (!this.m_columnNames.isEmpty()) {
                this.m_columnNames.clear();
                this.m_columnTypes.clear();
                this.m_columnProps.clear();
            }
            TableColumnModel colModel = ChildTableEditorPanel.this.m_wrapperTable.getColumnModel();
            int i = 0;
            for (PropertyInfo propInfo : columnProps) {
                Class<Boolean> propClass = propInfo.getPropertyClass();
                if (propClass.equals(Boolean.TYPE)) {
                    propClass = Boolean.class;
                }
                String propName = propInfo.getPropertyName();
                this.m_columnProps.add(propName);
                String columnName = PropertyDisplayRegistry.getDisplayName(propName);
                this.m_columnTypes.add(propClass);
                this.m_columnNames.add(columnName);
                TableColumn col = new TableColumn(i++);
                col.setIdentifier(propName);
                col.setHeaderValue(columnName);
                colModel.addColumn(col);
            }
        }

        public void addRow(int row, C rowObject, boolean select) {
            ArrayList<Object> rowList = new ArrayList<Object>();
            for (String string : this.m_columnProps) {
                if (string == null) continue;
                if (row == 0) {
                    ComponentWrapper wrapper = ChildTableEditorPanel.this.getOrCreateTableComponentWrapper(rowObject, string);
                    this.m_componentWrappers.add(wrapper);
                }
                Object propVal = ChildTableEditorPanel.this.getPropertyHelper().getPropertyValue(rowObject, string);
                rowList.add(propVal);
            }
            for (Map.Entry entry : this.m_nonPropColumnLogics.entrySet()) {
                Integer colPos = (Integer)entry.getKey();
                Object colInstance = null;
                try {
                    NonPropertyColumnLogic logic = (NonPropertyColumnLogic)entry.getValue();
                    colInstance = logic.getCellValue(rowObject);
                }
                catch (Exception e) {
                    ChildTableEditorPanel.this.getLogger().log(Level.SEVERE, "NonPropertyColumnLogic failed", e);
                }
                if (row == 0) {
                    this.m_componentWrappers.add(colPos, null);
                }
                rowList.add(colPos, colInstance);
            }
            RowInfo rowInfo = new RowInfo(ChildTableEditorPanel.this, rowObject, rowList);
            if (ChildTableEditorPanel.this.m_showSearch) {
                this.m_rowNames.add(row, rowObject.getName());
                this.m_unfilteredRowData.add(row, rowInfo);
            }
            this.m_rowData.add(row, rowInfo);
            this.fireTableRowsInserted(row, row);
            if (select) {
                ChildTableEditorPanel.this.m_wrapperTable.changeSelection(row, 0, false, false);
                this.setCurrentRowIndx(row);
            }
        }

        public void deleteRow(int row, boolean deleteFromModel) {
            RowInfo rowInfo = this.m_rowData.get(row);
            Object rowObject = rowInfo.getRowObject();
            this.m_rowData.remove(row);
            if (deleteFromModel) {
                if (ChildTableEditorPanel.this.m_showSearch) {
                    int delIndx = this.m_rowNames.indexOf(rowObject.getName());
                    this.m_unfilteredRowData.remove(delIndx);
                    this.m_rowNames.remove(rowObject.getName());
                }
                ChildTableEditorPanel.this.removeFromParent(rowObject);
            }
            if (this.getRowCount() == 1 && ChildTableEditorPanel.this.m_reorderTable != null && ChildTableEditorPanel.this.m_reorderTable.getReorderableBar() != null) {
                ChildTableEditorPanel.this.m_reorderTable.getReorderableBar().setDownEnabled(false);
                ChildTableEditorPanel.this.m_reorderTable.getReorderableBar().setBottomEnabled(false);
            }
            if (this.getRowCount() == 0 && !ChildTableEditorPanel.this.isSearchInProgress()) {
                this.clearRowsCache();
            }
            this.fireTableRowsDeleted(row, row);
        }

        public void deleteRow(int row) {
            this.deleteRow(row, true);
        }

        private boolean isRowMatching(int rowPos, String matchText) {
            String name = this.m_rowNames.get(rowPos).toUpperCase();
            return name.indexOf(matchText.toUpperCase()) != -1;
        }

        public void filterRows(String matchText) {
            this.m_rowData.clear();
            this.m_rowData.addAll(this.m_unfilteredRowData);
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                if (this.isRowMatching(i, matchText)) continue;
                this.deleteRow(i, false);
            }
            this.fireTableStructureChanged();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            NonPropertyColumnLogic logic = this.m_nonPropColumnLogics.get(col);
            boolean retval = logic == null ? ChildTableEditorPanel.this.isTableCellEditable(row, col) : logic.isCellEditable(this.getRow(row).getRowObject());
            return retval;
        }

        public ComponentWrapper getComponentWrapperForColumn(int row, int col) {
            RowInfo rowInfo = this.getRow(row);
            rowInfo.refreshRow(this.m_componentWrappers);
            this.setCurrentRowIndx(row);
            ComponentWrapper wrapper = this.m_componentWrappers.get(col);
            return wrapper;
        }

        public List<String> getRowNames() {
            return this.m_rowNames;
        }

        public void addColumn(String columnName, int insertPosition, Class columnClass, NonPropertyColumnLogic columnLogic, TableCellRenderer cellRenderer) {
            this.m_columnProps.add(insertPosition, null);
            this.m_columnNames.add(insertPosition, columnName);
            this.m_columnTypes.add(insertPosition, columnClass);
            this.m_nonPropColumnLogics.put(insertPosition, columnLogic);
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                RowInfo rowInfo = this.m_rowData.get(i);
                rowInfo.getRowColumns().add(insertPosition, columnLogic.getCellValue(rowInfo.getRowObject()));
            }
            TableColumnModel colModel = ChildTableEditorPanel.this.m_wrapperTable.getColumnModel();
            TableColumn col = new TableColumn(insertPosition);
            col.setIdentifier(columnName);
            col.setHeaderValue(columnName);
            if (cellRenderer == null) {
                cellRenderer = ChildTableEditorPanel.this.m_wrapperTable.getDefaultRenderer(columnClass);
            }
            col.setCellRenderer(new ValidationCellRenderer(cellRenderer));
            colModel.addColumn(col);
            colModel.moveColumn(colModel.getColumnCount() - 1, insertPosition);
            for (int i = 0; i < colModel.getColumnCount(); ++i) {
                colModel.getColumn(i).setModelIndex(i);
            }
            this.fireTableStructureChanged();
        }

        public C[] getChildren() {
            ChildDBObject[] children = (ChildDBObject[])Array.newInstance(ChildTableEditorPanel.this.getChildClass(), this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                children[i] = this.getRow(i).getRowObject();
            }
            return children;
        }

        private boolean isComponentWrapperCell(int colIndx) {
            return !this.m_nonPropColumnLogics.containsKey(colIndx);
        }

        public int getCurrentRowIndx() {
            return this.m_currentRowIndx;
        }

        public void setCurrentRowIndx(int index) {
            this.m_currentRowIndx = index;
        }

        public int getRowIndex(C child) {
            int retval = -1;
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                RowInfo row = this.m_rowData.get(i);
                if (row.getRowObject() != child) continue;
                retval = i;
                break;
            }
            return retval;
        }
    }

    private class ComponentWrapperTable
    extends GenericTable {
        private ComponentWrapperTable() {
        }

        protected void createDefaultRenderers() {
            super.createDefaultRenderers();
            for (Class clz : this.defaultRenderersByColumnClass.keySet()) {
                this.setDefaultRenderer(clz, this.getDefaultRenderer(clz));
            }
            this.setDefaultRenderer(Enum.class, (TableCellRenderer)((Object)new PropertyValueCellRenderer()));
        }

        public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
            super.setDefaultRenderer(columnClass, renderer instanceof ValidationCellRenderer ? renderer : new ValidationCellRenderer(renderer));
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.isAltDown()) {
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
    }

    public static enum NewChildInsertPolicy {
        AFTER_SELECTED_ROW,
        AT_END;

    }
}

