/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ideimpl.db.panels.sql.QueryPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class SQLQueryOwnerPanelLibrary<T extends SQLQueryOwner>
extends PanelLibrary<T> {
    protected static final String QUERY_PANEL_TITLE = UIBundle.get("QUERY_DISPLAY_INFO");
    protected static final String SIMPLE_QUERY_PANEL_TITLE = QUERY_PANEL_TITLE + " ";

    public SQLQueryOwnerPanelLibrary(String type, Map<String, String> helpIDs) {
        super(type, helpIDs);
        SQLQueryEditDialog d = new SQLQueryEditDialog();
        this.addNavigable(QUERY_PANEL_TITLE, d.getMasterNavigable(), "SQLQuery");
        this.addPanel(SIMPLE_QUERY_PANEL_TITLE, QueryPanel.class, "f1_odbvisql_html", "SQLQuery");
    }

    @Override
    protected T newDBObject(DBObjectProvider pro, Schema schema, DBObject parent) {
        SQLQueryOwner retval = (SQLQueryOwner)super.newDBObject(pro, schema, parent);
        if (retval.getSQLQuery() == null) {
            retval.setSQLQuery((SQLQuery)pro.getObjectFactory().newObject(SQLQuery.class, (DBObject)retval));
        }
        return (T)retval;
    }

    public boolean showDeclarativePanels() {
        boolean retval = Boolean.getBoolean("ide.db.forceNoDeclarativeSQLSupport") ? false : (Boolean.getBoolean("ide.db.forceDeclarativeSQLSupport") ? true : !Product.isRaptor());
        return retval;
    }

    @Override
    protected List<String> getTitles(T obj, DBObjectProvider pro, boolean editing) {
        ArrayList<String> retval = new ArrayList<String>();
        if (!this.showDeclarativePanels() || editing && !pro.isEditable(obj)) {
            retval.add(SIMPLE_QUERY_PANEL_TITLE);
        } else {
            retval.add(QUERY_PANEL_TITLE);
        }
        return retval;
    }

    @Override
    protected List<String> getSimpleTitles() {
        ArrayList<String> titles;
        if (this.showDeclarativePanels()) {
            titles = new ArrayList<String>();
            titles.add(SIMPLE_QUERY_PANEL_TITLE);
        } else {
            titles = null;
        }
        return titles;
    }
}

