/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectProviderNode;
import oracle.ide.db.model.DatabaseNode;
import oracle.ideimpl.db.model.ProviderNodeRecognizer;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.util.ModelUtil;

public abstract class DatabaseNodeRecognizer<T>
extends ProviderNodeRecognizer<T> {
    @Override
    public final String getProviderType(T elem) {
        String connName = this.getConnectionName(elem);
        return ModelUtil.hasLength((String)connName) ? "db" : null;
    }

    @Override
    public final Object getProviderIdentifier(T elem) {
        String connName = this.getConnectionName(elem);
        return ModelUtil.hasLength((String)connName) ? DatabaseFactory.encodeIdentifier((String)this.getStoreName(elem), (String)connName) : null;
    }

    @Override
    public final boolean isProviderNode(T elem) {
        return this.isConnectionNode(elem);
    }

    public abstract String getConnectionName(T var1);

    public abstract String getStoreName(T var1);

    public boolean isConnectionNode(T elem) {
        return elem instanceof DatabaseNode;
    }

    public boolean isStoreNode(T elem) {
        return elem instanceof ConnectionStoreNode && !(elem instanceof DBObjectProviderNode) && !DBObjectNodeUtil.isConnectionNode(elem);
    }

    static <T> DatabaseNodeRecognizer<T> createRecognizer(T elem) {
        DatabaseNodeRecognizer retval = null;
        if (elem != null) {
            if (elem instanceof DatabaseNode) {
                retval = new DBNodeRecognizer();
            } else if (elem instanceof DBObjectProviderNode) {
                if ("db".equals(((DBObjectProviderNode)elem).getProviderType())) {
                    retval = new DBProRecognizer();
                }
            } else if (elem instanceof ConnectionStoreNode) {
                retval = new DBStoreNodeRecognizer();
            }
        }
        return retval;
    }

    public static <T> DatabaseNodeRecognizer<T> findRecognizer(T elem) {
        ProviderNodeRecognizer<T> r = ProviderNodeRecognizer.findRecognizer(elem);
        return r instanceof DatabaseNodeRecognizer ? (DatabaseNodeRecognizer)r : null;
    }

    private static String decode(String name, boolean store) {
        String retval = name;
        if (ModelUtil.hasLength((String)name)) {
            String[] decoded = DatabaseFactory.decodeIdentifier((String)name);
            retval = store ? decoded[0] : decoded[1];
        }
        return retval;
    }

    private static class DBStoreNodeRecognizer
    extends DatabaseNodeRecognizer<ConnectionStoreNode> {
        private DBStoreNodeRecognizer() {
        }

        @Override
        public String getConnectionName(ConnectionStoreNode node) {
            return null;
        }

        @Override
        public String getStoreName(ConnectionStoreNode node) {
            return node.getStoreName();
        }
    }

    private static class DBProRecognizer
    extends DatabaseNodeRecognizer<DBObjectProviderNode> {
        private DBProRecognizer() {
        }

        @Override
        public String getConnectionName(DBObjectProviderNode node) {
            return DatabaseNodeRecognizer.decode((String)node.getProviderIdentifier(), false);
        }

        @Override
        public String getStoreName(DBObjectProviderNode node) {
            String retval = node instanceof ConnectionStoreNode ? ((ConnectionStoreNode)((Object)node)).getStoreName() : DatabaseNodeRecognizer.decode((String)node.getProviderIdentifier(), true);
            return retval;
        }
    }

    private static class DBNodeRecognizer
    extends DatabaseNodeRecognizer<DatabaseNode> {
        private DBNodeRecognizer() {
        }

        @Override
        public String getConnectionName(DatabaseNode node) {
            return node.getConnectionName();
        }

        @Override
        public String getStoreName(DatabaseNode node) {
            return node.getStoreName();
        }
    }
}

