/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.components;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.components.ExtendedTableComponentWrapper;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.hive.TblProperty;
import oracle.javatools.db.property.Property;

public class TblPropertiesComponentWrapper
extends ExtendedTableComponentWrapper<TblPropertiesJTable> {
    public TblPropertiesComponentWrapper(String prop) {
        super(new TblPropertiesJTable(prop));
    }

    @Override
    protected void initialiseComponent() {
        Object origVal;
        super.initialiseComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            this.getComponent().setPreferredSize(new Dimension(200, 100));
        }
        if (this.getProvider() instanceof Database && "serDeProperties".equals(Property.getLastProperty((String)this.getPropertyName())) && (origVal = this.getOriginalPropertyValue()) instanceof TblProperty[]) {
            HashSet<String> noRemove = new HashSet<String>();
            for (TblProperty prop : (TblProperty[])origVal) {
                noRemove.add(prop.getName());
            }
            ((TblPropertiesJTable)this.getExtendedTable()).setNonRemoveableProperties(noRemove);
        }
    }

    @Override
    public Object getPropertyValue() {
        return ((TblPropertiesJTable)this.getExtendedTable()).getTblProperties();
    }

    @Override
    public void setPropertyValue(Object val) {
        ((TblPropertiesJTable)this.getExtendedTable()).setTblProperties((TblProperty[])val);
    }

    static class TblPropertiesJTable
    extends KeyValueTable {
        private Collection<String> m_noRemove;

        public TblPropertiesJTable(String property) {
            super(PropertyDisplayRegistry.getDisplayName(property), property);
        }

        public void setNonRemoveableProperties(Collection<String> noRemove) {
            this.m_noRemove = noRemove;
        }

        public void setTblProperties(TblProperty[] props) {
            Vector<Vector> data = new Vector<Vector>();
            if (props != null) {
                for (TblProperty prop : props) {
                    Vector<String> row = new Vector<String>();
                    row.add(prop.getName());
                    row.add(prop.getTablePropertyValue());
                    data.add(row);
                }
            }
            this.setModel(new ExtendedTable.StringTableModel(data, this.getPropertyColumnNames("name", "tablePropertyValue")));
        }

        public TblProperty[] getTblProperties() {
            this.stopCellEditing();
            Vector data = this.getModel().getDataVector();
            TblProperty[] retval = null;
            if (!data.isEmpty()) {
                retval = new TblProperty[data.size()];
                int i = 0;
                for (Vector row : data) {
                    retval[i++] = new TblProperty((String)row.get(0), (String)row.get(1));
                }
            }
            return retval;
        }

        @Override
        protected void addNewRow() {
            ArrayList<String> names = new ArrayList<String>();
            for (Object row : this.getModel().getDataVector()) {
                names.add((String)((Vector)row).get(0));
            }
            String name = DBUtil.getUniqueName(names, (String)"property1");
            this.getModel().addRow(new Object[]{name, null});
        }

        @Override
        protected boolean isReorderable() {
            return false;
        }

        @Override
        protected boolean canRemoveRow(int row) {
            Vector data;
            boolean retval = super.canRemoveRow(row);
            if (retval && this.m_noRemove != null && (data = this.getModel().getDataVector()).size() > row) {
                Vector rowData = (Vector)data.get(row);
                retval = !this.m_noRemove.contains(rowData.get(0));
            }
            return retval;
        }
    }
}

